/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Matcher;
import com.hp.hpl.jena.graph.query.QueryNode;
import com.hp.hpl.jena.graph.query.QueryNodeFactory;
import com.hp.hpl.jena.graph.query.QueryTriple;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import com.ibm.icu.util.StringTokenizer;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestSuite;

public class TestQueryTriple
extends QueryTestBase {
    public static final QueryNodeFactory F = QueryNode.factory;
    protected static final String[][] matchings = new String[][]{{"s P o", "s P o", "y"}, {"s P o", "a Q b", "y"}, {"?x P y", "a P y", "y0=a"}, {"?x P ?y", "go P og", "y0=go;1=og"}, {"?x P ?x", "a P a", "y0=a"}, {"?x P ?x", "a P b", "n"}};

    public TestQueryTriple(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestQueryTriple.class);
    }

    public void testQueryTripleSPO() {
        QueryNode.Fixed S = new QueryNode.Fixed(NodeCreateUtils.create("_subject"));
        QueryNode.Fixed P = new QueryNode.Fixed(NodeCreateUtils.create("predicate"));
        QueryNode.Fixed O = new QueryNode.Fixed(NodeCreateUtils.create("99"));
        QueryTriple t = new QueryTriple(S, P, O);
        TestQueryTriple.assertSame(S, t.S);
        TestQueryTriple.assertSame(P, t.P);
        TestQueryTriple.assertSame(O, t.O);
    }

    public void testQueryTripleClassifySimple() {
        this.testQueryTripleClassifySimple(TestQueryTriple.triple("_x y ?z"));
        this.testQueryTripleClassifySimple(TestQueryTriple.triple("a b 17"));
        this.testQueryTripleClassifySimple(TestQueryTriple.triple("?? y _"));
        this.testQueryTripleClassifySimple(TestQueryTriple.triple("?x y z"));
    }

    protected void testQueryTripleClassifySimple(Triple t) {
        Mapping m = new Mapping(new Node[0]);
        Mapping m2 = new Mapping(new Node[0]);
        HashSet s = new HashSet();
        QueryTriple q = QueryTriple.classify(F, m, t);
        this.testClassifiedOK(t.getSubject(), m2, s, q.S);
        this.testClassifiedOK(t.getPredicate(), m2, s, q.P);
        this.testClassifiedOK(t.getObject(), m2, s, q.O);
    }

    protected void testClassifiedOK(Node node, Mapping m2, Set s, QueryNode q) {
        TestQueryTriple.assertSame(node, q.node);
        TestQueryTriple.assertSame(QueryNode.classify(F, m2, s, node).getClass(), q.getClass());
    }

    public void testJustBoundSO() {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple q = QueryTriple.classify(F, m, TestQueryTriple.triple("?x ?y ?x"));
        TestQueryTriple.assertEquals(QueryNode.JustBound.class, q.O.getClass());
        TestQueryTriple.assertEquals(q.S.index, q.O.index);
    }

    public void testJustBoundSP() {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple q = QueryTriple.classify(F, m, TestQueryTriple.triple("?x ?x ?y"));
        TestQueryTriple.assertEquals(QueryNode.JustBound.class, q.P.getClass());
        TestQueryTriple.assertEquals(q.S.index, q.P.index);
    }

    public void testJustBoundPO() {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple q = QueryTriple.classify(F, m, TestQueryTriple.triple("?x ?y ?y"));
        TestQueryTriple.assertEquals(QueryNode.JustBound.class, q.O.getClass());
        TestQueryTriple.assertEquals(q.P.index, q.O.index);
    }

    public void testJustBoundSPO() {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple q = QueryTriple.classify(F, m, TestQueryTriple.triple("?x ?x ?x"));
        TestQueryTriple.assertEquals(QueryNode.JustBound.class, q.P.getClass());
        TestQueryTriple.assertEquals(QueryNode.JustBound.class, q.O.getClass());
        TestQueryTriple.assertEquals(q.S.index, q.P.index);
        TestQueryTriple.assertEquals(q.S.index, q.O.index);
    }

    public void testSimpleClassifyArray() {
        this.testSimpleClassifyArray(TestQueryTriple.tripleArray(""));
        this.testSimpleClassifyArray(TestQueryTriple.tripleArray("a P b"));
        this.testSimpleClassifyArray(TestQueryTriple.tripleArray("a P b; c Q d"));
        this.testSimpleClassifyArray(TestQueryTriple.tripleArray("?a P ?b; ?b Q ?c"));
        this.testSimpleClassifyArray(TestQueryTriple.tripleArray("?a P ?b; ?b Q ?c; ?a Z ?c"));
    }

    protected void testSimpleClassifyArray(Triple[] triples) {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple[] q = QueryTriple.classify(F, m, triples);
        TestQueryTriple.assertEquals(triples.length, q.length);
        for (int i = 0; i < q.length; ++i) {
            TestQueryTriple.assertEquals(triples[i].getSubject(), q[i].S.node);
            TestQueryTriple.assertEquals(triples[i].getPredicate(), q[i].P.node);
            TestQueryTriple.assertEquals(triples[i].getObject(), q[i].O.node);
        }
    }

    public void testJustBoundConfinement() {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple[] q = QueryTriple.classify(F, m, TestQueryTriple.tripleArray("?x P ?x; ?x Q ?x"));
        TestQueryTriple.assertInstanceOf(QueryNode.Bind.class, q[0].S);
        TestQueryTriple.assertInstanceOf(QueryNode.JustBound.class, q[0].O);
        TestQueryTriple.assertInstanceOf(QueryNode.Bound.class, q[1].S);
    }

    public void testMatch() {
        for (int i = 0; i < matchings.length; ++i) {
            String[] m = matchings[i];
            this.testMatch(TestQueryTriple.triple(m[0]), TestQueryTriple.triple(m[1]), m[2].charAt(0) == 'y', m[2].substring(1));
        }
    }

    protected void testMatch(Triple toClassify, Triple toMatch, boolean result, String bindings) {
        Mapping map = new Mapping(new Node[0]);
        QueryTriple t = QueryTriple.classify(F, map, toClassify);
        Matcher m = t.createMatcher();
        Domain d = new Domain(3);
        TestQueryTriple.assertEquals(result, m.match(d, toMatch));
        StringTokenizer st = new StringTokenizer(bindings, ";");
        while (st.hasMoreTokens()) {
            this.testBinding(d, st.nextToken());
        }
    }

    protected void testBinding(Domain d, String binding) {
        int eq = binding.indexOf(61);
        int index = Integer.parseInt(binding.substring(0, eq));
        Node value = NodeCreateUtils.create(binding.substring(eq + 1));
        TestQueryTriple.assertEquals(value, d.getElement(index));
    }
}

