/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.ConnectionDescription;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.ModelExpansion;
import com.hp.hpl.jena.assembler.assemblers.RDBModelAssembler;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.ReificationStyle;
import junit.framework.Assert;

public class TestRDBModelAssembler
extends AssemblerTestBase {
    public TestRDBModelAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return RDBModelAssembler.class;
    }

    public void testRDBModelAssemblerType() {
        this.testDemandsMinimalType(new RDBModelAssembler(), JA.RDBModel);
    }

    public void testRDBModelVocabulary() {
        Model m = this.model("x rdf:type ja:Connectable; x rdf:type ja:NamedModel");
        Model answer = ModelExpansion.withSchema(m, JA.getSchema());
        TestRDBModelAssembler.assertTrue("should infer x rdf:type ja:RDBModel", answer.contains(TestRDBModelAssembler.statement("x rdf:type ja:RDBModel")));
    }

    public void testInvokesCreateModel() {
        Resource root = this.resourceInModel("x rdf:type ja:RDBModel; x ja:modelName 'spoo'; x ja:connection C");
        final ConnectionDescription C2 = ConnectionDescription.create("eh:/x", "A", "B", "C", "D");
        final Model fake = ModelFactory.createDefaultModel();
        final Mode theMode = new Mode(true, true);
        RDBModelAssembler a = new RDBModelAssembler(){

            public Model openModel(Resource root, ConnectionDescription c, String name, ReificationStyle style, Mode mode) {
                Assert.assertSame(C2, c);
                Assert.assertSame(theMode, mode);
                return fake;
            }
        };
        AssemblerTestBase.NamedObjectAssembler foo = new AssemblerTestBase.NamedObjectAssembler(TestRDBModelAssembler.resource("C"), C2);
        TestRDBModelAssembler.assertSame(fake, a.open(foo, root, theMode));
    }
}

