/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModAssembler;
import arq.cmdline.ModDataset;
import arq.cmdline.ModEngine;
import arq.cmdline.ModResultsOut;
import arq.cmdline.ModTime;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DataSourceImpl;
import com.hp.hpl.jena.sparql.engine.PlanOp;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.QueryExecUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.util.Iterator;

public class sse_query
extends CmdARQ {
    protected final ArgDecl queryFileDecl = new ArgDecl(true, "query", "file");
    protected final ArgDecl printDecl = new ArgDecl(true, "print");
    ModDataset modDataset = new ModAssembler();
    ModResultsOut modResults = new ModResultsOut();
    ModTime modTime = new ModTime();
    ModEngine modEngine = new ModEngine();
    String queryFilename = null;
    String queryString = null;
    boolean printOp = false;
    boolean printPlan = false;
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    boolean needDivider = false;

    public static void main(String[] argv) {
        new sse_query(argv).main();
    }

    public sse_query(String[] argv) {
        super(argv);
        super.add(this.queryFileDecl, "--query=FILE", "Algebra file to execute");
        super.add(this.printDecl, "--print=op/plan", "Print details");
        super.addModule(this.modResults);
        super.addModule(this.modDataset);
        super.addModule(this.modTime);
        super.addModule(this.modEngine);
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(this.queryFileDecl)) {
            this.queryFilename = super.getValue(this.queryFileDecl);
        }
        Iterator iter = this.getValues(this.printDecl).iterator();
        while (iter.hasNext()) {
            String arg = (String)iter.next();
            if (arg.equalsIgnoreCase("op") || arg.equalsIgnoreCase("alg") || arg.equalsIgnoreCase("algebra")) {
                this.printOp = true;
                continue;
            }
            if (arg.equalsIgnoreCase("plan")) {
                this.printPlan = true;
                continue;
            }
            throw new CmdException("Not a recognized print form: " + arg + " : Choices are: query, op, quad");
        }
    }

    protected String getCommandName() {
        return Utils.className(this);
    }

    protected String getSummary() {
        return this.getCommandName() + " --data=<file> --query=<query>";
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    protected void exec() {
        try {
            Op op = null;
            if (this.queryFilename != null) {
                if (this.queryFilename.equals("-")) {
                    try {
                        this.queryString = FileUtils.readWholeFileAsUTF8(System.in);
                    }
                    catch (IOException ex) {
                        throw new CmdException("Error reading stdin", ex);
                    }
                } else {
                    op = SSE.readOp(this.queryFilename);
                }
            }
            if (this.queryString != null) {
                op = SSE.parseOp(this.queryString);
                if (op == null) {
                    System.err.println("Faile to parse : " + this.queryString);
                }
                throw new TerminationException(9);
            }
            if (op == null) {
                System.err.println("No query expression to execute");
                throw new TerminationException(9);
            }
            Dataset dataset = this.modDataset.getDataset();
            if (dataset == null) {
                dataset = new DataSourceImpl();
            }
            this.modTime.startTimer();
            DataSourceGraphImpl dsg = new DataSourceGraphImpl(dataset);
            if (this.printOp || this.printPlan) {
                if (this.printOp) {
                    this.divider();
                    IndentedWriter out = new IndentedWriter(System.out, true);
                    op.output(out);
                    out.flush();
                }
                if (this.printPlan) {
                    QueryIterator qIter = Algebra.exec(op, dsg);
                    PlanOp plan = new PlanOp(op, qIter);
                    this.divider();
                    IndentedWriter out = new IndentedWriter(System.out, false);
                    plan.output(out);
                    out.flush();
                }
                return;
            }
            QueryExecUtils.executeAlgebra(op, dsg, this.modResults.getResultsFormat());
            long time = this.modTime.endTimer();
            if (this.modTime.timingEnabled()) {
                System.out.println("Time: " + this.modTime.timeStr(time));
            }
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
        }
        catch (ResultSetException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        catch (QueryException qEx) {
            throw new CmdException("Query Exeception", qEx);
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (CmdException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Exception", ex);
        }
    }
}

