/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

class DisjunctionMaxScorer
extends Scorer {
    private ArrayList subScorers = new ArrayList();
    private float tieBreakerMultiplier;
    private boolean more = false;
    private boolean firstTime = true;

    public DisjunctionMaxScorer(float tieBreakerMultiplier, Similarity similarity) {
        super(similarity);
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    public void add(Scorer scorer) throws IOException {
        if (scorer.next()) {
            this.subScorers.add(scorer);
            this.more = true;
        }
    }

    public boolean next() throws IOException {
        if (!this.more) {
            return false;
        }
        if (this.firstTime) {
            this.heapify();
            this.firstTime = false;
            return true;
        }
        int lastdoc = ((Scorer)this.subScorers.get(0)).doc();
        do {
            if (((Scorer)this.subScorers.get(0)).next()) {
                this.heapAdjust(0);
                continue;
            }
            this.heapRemoveRoot();
            if (!this.subScorers.isEmpty()) continue;
            this.more = false;
            return false;
        } while (((Scorer)this.subScorers.get(0)).doc() == lastdoc);
        return true;
    }

    public int doc() {
        return ((Scorer)this.subScorers.get(0)).doc();
    }

    public float score() throws IOException {
        int doc = ((Scorer)this.subScorers.get(0)).doc();
        float[] sum = new float[]{((Scorer)this.subScorers.get(0)).score()};
        float[] max2 = new float[]{sum[0]};
        int size = this.subScorers.size();
        this.scoreAll(1, size, doc, sum, max2);
        this.scoreAll(2, size, doc, sum, max2);
        return max2[0] + (sum[0] - max2[0]) * this.tieBreakerMultiplier;
    }

    private void scoreAll(int root, int size, int doc, float[] sum, float[] max2) throws IOException {
        if (root < size && ((Scorer)this.subScorers.get(root)).doc() == doc) {
            float sub = ((Scorer)this.subScorers.get(root)).score();
            sum[0] = sum[0] + sub;
            max2[0] = Math.max(max2[0], sub);
            this.scoreAll((root << 1) + 1, size, doc, sum, max2);
            this.scoreAll((root << 1) + 2, size, doc, sum, max2);
        }
    }

    public boolean skipTo(int target) throws IOException {
        while (this.subScorers.size() > 0 && ((Scorer)this.subScorers.get(0)).doc() < target) {
            if (((Scorer)this.subScorers.get(0)).skipTo(target)) {
                this.heapAdjust(0);
                continue;
            }
            this.heapRemoveRoot();
        }
        if (this.subScorers.size() == 0) {
            this.more = false;
            return false;
        }
        return true;
    }

    public Explanation explain(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void heapify() {
        int size = this.subScorers.size();
        for (int i = (size >> 1) - 1; i >= 0; --i) {
            this.heapAdjust(i);
        }
    }

    private void heapAdjust(int root) {
        Scorer scorer = (Scorer)this.subScorers.get(root);
        int doc = scorer.doc();
        int i = root;
        int size = this.subScorers.size();
        while (i <= (size >> 1) - 1) {
            int lchild = (i << 1) + 1;
            Scorer lscorer = (Scorer)this.subScorers.get(lchild);
            int ldoc = lscorer.doc();
            int rdoc = Integer.MAX_VALUE;
            int rchild = (i << 1) + 2;
            Scorer rscorer = null;
            if (rchild < size) {
                rscorer = (Scorer)this.subScorers.get(rchild);
                rdoc = rscorer.doc();
            }
            if (ldoc < doc) {
                if (rdoc < ldoc) {
                    this.subScorers.set(i, rscorer);
                    this.subScorers.set(rchild, scorer);
                    i = rchild;
                    continue;
                }
                this.subScorers.set(i, lscorer);
                this.subScorers.set(lchild, scorer);
                i = lchild;
                continue;
            }
            if (rdoc < doc) {
                this.subScorers.set(i, rscorer);
                this.subScorers.set(rchild, scorer);
                i = rchild;
                continue;
            }
            return;
        }
    }

    private void heapRemoveRoot() {
        int size = this.subScorers.size();
        if (size == 1) {
            this.subScorers.remove(0);
        } else {
            this.subScorers.set(0, this.subScorers.get(size - 1));
            this.subScorers.remove(size - 1);
            this.heapAdjust(0);
        }
    }
}

