/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.policy;

import net.ponder2.SelfManagedCell;
import net.ponder2.exception.Ponder2AuthorizationException;
import net.ponder2.objects.P2Object;
import net.ponder2.policy.AuthPolicyHolder;
import net.ponder2.policy.AuthPolicySearch;
import net.ponder2.policy.AuthorisationModule;
import net.ponder2.policy.AuthorisationPolicy;

public class BasicAuthModule
extends AuthorisationModule {
    static boolean DEBUG = false;
    static boolean FEEDBACK = false;
    AuthPolicySearch aps = new AuthPolicySearch();

    public void requestOutgoing(AuthPolicyHolder holder, P2Object subjectOID, P2Object targetOID, String operation, P2Object[] args) throws Ponder2AuthorizationException {
        this.print("requestOutgoing (PEP1)", subjectOID, targetOID, operation, args);
        int isAuth = -1;
        if (subjectOID.equals(this.rootDomain)) {
            this.print("requestOutgoing (PEP1): this action is invoked by the SMC and will be authorised!!", operation);
            isAuth = 0;
        } else {
            isAuth = this.aps.search(holder, BasicAuthModule.getValueOf("PEP1"), subjectOID, targetOID, operation, 's', args, null);
        }
        if (isAuth == 0) {
            this.print("requestOutgoing (PEP1): the call is AUTHORIZED", operation);
        } else {
            if (isAuth == 1) {
                this.print("requestOutgoing (PEP1): the call is NOT AUTHORIZED", operation);
                throw new Ponder2AuthorizationException(operation);
            }
            this.print("requestOutgoing (PEP1): NO VALID POLICY WAS FOUND. Going for the default auth policy", operation);
            if (!SelfManagedCell.getDefaulAuthPolicy()) {
                throw new Ponder2AuthorizationException(operation);
            }
        }
    }

    public void requestIncoming(AuthPolicyHolder holder, P2Object subjectOID, P2Object targetOID, String operation, P2Object[] args) throws Ponder2AuthorizationException {
        this.print("requestIncoming (PEP2)", subjectOID, targetOID, operation, args);
        int isAuth = -1;
        if (subjectOID.equals(this.rootDomain)) {
            this.print("requestIncoming (PEP2): this action is invoked by the SMC and will be authorised!!", operation);
            isAuth = 0;
        } else {
            isAuth = this.aps.search(holder, BasicAuthModule.getValueOf("PEP2"), subjectOID, targetOID, operation, 't', args, null);
        }
        if (isAuth == 0) {
            this.print("requestIncoming (PEP2): the call is AUTHORIZED", operation);
        } else {
            if (isAuth == 1) {
                this.print("requestIncoming (PEP2): the call is NOT AUTHORIZED", operation);
                throw new Ponder2AuthorizationException(operation);
            }
            this.print("requestIncoming (PEP2): NO VALID POLICY WAS FOUND. Going for the default auth policy", operation);
            if (!SelfManagedCell.getDefaulAuthPolicy()) {
                throw new Ponder2AuthorizationException(operation);
            }
        }
    }

    public void replyOutgoing(AuthPolicyHolder holder, P2Object subjectOID, P2Object targetOID, String operation, P2Object[] args, P2Object returnedValue) throws Ponder2AuthorizationException {
        short isAuth;
        this.print("replyOutgoing (PEP3)", subjectOID, targetOID, operation, returnedValue);
        if (subjectOID.equals(this.rootDomain)) {
            this.print("replyOutgoing (PEP3): this action is invoked by the SMC and will be authorised!!", operation);
            isAuth = 0;
        } else {
            AuthorisationPolicy policy = holder.getIncomingAuthPol();
            if (policy != null) {
                this.print("replyOutgoing (PEP3): the policy from PEP2 is not null. Goign to evaluate the return condition!", operation);
                isAuth = AuthPolicySearch.evaluate(holder, policy, BasicAuthModule.getValueOf("PEP3"), subjectOID, returnedValue);
            } else {
                this.print("replyOutgoing (PEP3): the policy from PEP2 is null. I need to invoke the search...", operation);
                isAuth = this.aps.search(holder, BasicAuthModule.getValueOf("PEP3"), subjectOID, targetOID, operation, 't', args, returnedValue);
            }
        }
        if (isAuth == 0) {
            this.print("replyOutgoing (PEP3): the call is AUTHORIZED", operation);
        } else {
            if (isAuth == 1) {
                this.print("replyOutgoing (PEP3): the call is NOT AUTHORIZED", operation);
                throw new Ponder2AuthorizationException(operation);
            }
            this.print("replyOutgoing (PEP3): NO VALID POLICY WAS FOUND. Going for the default auth policy", operation);
            if (!SelfManagedCell.getDefaulAuthPolicy()) {
                throw new Ponder2AuthorizationException(operation);
            }
        }
    }

    public void replyIncoming(AuthPolicyHolder holder, P2Object subjectOID, P2Object targetOID, String operation, P2Object[] args, P2Object returnedValue) throws Ponder2AuthorizationException {
        short isAuth;
        this.print("replyIncoming (PEP4)", subjectOID, targetOID, operation, returnedValue);
        if (subjectOID.equals(this.rootDomain)) {
            this.print("replyIncoming (PEP4): this action is invoked by the SMC and will be authorised!!", operation);
            isAuth = 0;
        } else {
            AuthorisationPolicy policy = holder.getOutgoingAuthPol();
            if (policy != null) {
                this.print("replyIncoming (PEP4): the policy from PEP1 is not null. Goign to evaluate the return condition!", operation);
                isAuth = AuthPolicySearch.evaluate(holder, policy, BasicAuthModule.getValueOf("PEP4"), subjectOID, returnedValue);
            } else {
                this.print("replyIncoming (PEP4): the policy from PEP1 is null. I need to invoke the search...", operation);
                isAuth = this.aps.search(holder, BasicAuthModule.getValueOf("PEP4"), subjectOID, targetOID, operation, 's', args, returnedValue);
            }
        }
        if (isAuth == 0) {
            this.print("replyIncoming (PEP4): the call is AUTHORIZED", operation);
        } else {
            if (isAuth == 1) {
                this.print("replyIncoming (PEP4): the call is NOT AUTHORIZED", operation);
                throw new Ponder2AuthorizationException(operation);
            }
            this.print("replyIncoming (PEP4): NO VALID POLICY WAS FOUND. Going for the default auth policy", operation);
            if (!SelfManagedCell.getDefaulAuthPolicy()) {
                throw new Ponder2AuthorizationException(operation);
            }
        }
    }

    private void print(String check, String operation) {
        if (DEBUG || FEEDBACK) {
            System.out.println("BasicAuthModule for op " + operation + " @" + check);
        }
    }

    private void print(String check, P2Object sourceOid, P2Object targetOid, String operation, P2Object ... args) {
        if (DEBUG) {
            System.out.println("BasicAuthModule " + check + " " + sourceOid + " => " + targetOid + " op: " + operation);
        }
    }
}

