/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.policy;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import net.ponder2.P2ManagedObject;
import net.ponder2.SelfManagedCell;
import net.ponder2.objects.P2Object;
import net.ponder2.policy.AuthPolicyHolder;
import net.ponder2.policy.AuthorisationModule;
import net.ponder2.policy.AuthorisationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthPolicySearch {
    public static final short AUTH = 0;
    public static final short NOTAUTH = 1;
    public static final short POL_NOT_DEFINED = 2;
    private Vector<LinkedList<P2ManagedObject>> subjectPath;
    private Vector<LinkedList<P2ManagedObject>> targetPath;
    private Vector<LinkedList<Pair>> pathCombination;
    private static boolean DEBUG = false;

    private void buildPath(P2ManagedObject mObj, Vector<LinkedList<P2ManagedObject>> path) {
        if (mObj == null) {
            System.err.println("PolicySearchingStrategy, buildPath: the managed object is null");
            return;
        }
        LinkedList<P2ManagedObject> currentPath = null;
        if (mObj.getOID().equals(SelfManagedCell.RootDomain.getOID())) {
            if (DEBUG) {
                System.out.println("AuthPolicySearch.buildPath(): this is the root domain");
            }
            currentPath = new LinkedList<P2ManagedObject>();
            currentPath.add(mObj);
            path.add(currentPath);
            return;
        }
        Iterator<P2ManagedObject> parentIter = mObj.getParentSet().iterator();
        P2ManagedObject parentObject = null;
        while (parentIter.hasNext()) {
            currentPath = new LinkedList();
            parentObject = parentIter.next();
            while (!parentObject.getParentSet().isEmpty() && !parentObject.getOID().equals(SelfManagedCell.RootDomain.getOID())) {
                currentPath.addFirst(parentObject);
                if (DEBUG) {
                    System.out.println("\tAuthPolicySearch.buildPath(): just added: " + parentObject.getOID());
                }
                parentObject = parentObject.getParentSet().iterator().next();
            }
            currentPath.addFirst(parentObject);
            if (DEBUG) {
                System.out.println("\tAuthPolicySearch.buildPath(): just added: " + parentObject.getOID());
            }
            path.add(currentPath);
        }
        if (path.size() > 0) {
            path.elementAt(0).addLast(mObj);
        }
        if (DEBUG) {
            System.out.println("\tAuthPolicySearch.buildPath(): just added: " + mObj.getOID());
        }
    }

    private void multiply() {
        this.pathCombination = new Vector();
        for (LinkedList<P2ManagedObject> nextSbjPath : this.subjectPath) {
            Iterator<LinkedList<P2ManagedObject>> targetIter = this.targetPath.iterator();
            while (targetIter.hasNext()) {
                Iterator sbjPathIter = nextSbjPath.iterator();
                LinkedList<P2ManagedObject> nextTrgPath = targetIter.next();
                LinkedList<Pair> pairList = new LinkedList<Pair>();
                while (sbjPathIter.hasNext()) {
                    P2ManagedObject subject = (P2ManagedObject)sbjPathIter.next();
                    for (P2ManagedObject target : nextTrgPath) {
                        Pair pair = new Pair(subject, target);
                        if (pairList.contains(pair)) continue;
                        pairList.add(pair);
                        if (!DEBUG) continue;
                        System.out.println("\tAuthPolicySearch.multiply(): added pair " + pair);
                    }
                }
                this.pathCombination.add(pairList);
            }
        }
    }

    private void findCandidatePolicy(LinkedList<Pair> pairList, String action, char focus, Vector<AuthorisationPolicy> finalPolicyCandidate, Vector<AuthorisationPolicy> normalPolicyCandidate) {
        if (DEBUG) {
            System.out.println("\tAuthPolicySearch.findCandidatePolicy(): BEFORE THE FIND THE NORMAL POLICY VETOR IS " + this.printVector(normalPolicyCandidate));
        }
        Vector<AuthorisationPolicy> tmpFinalNeg = new Vector<AuthorisationPolicy>();
        Vector<AuthorisationPolicy> tmpFinalPos = new Vector<AuthorisationPolicy>();
        Vector<AuthorisationPolicy> tmpNeg = new Vector<AuthorisationPolicy>();
        Vector<AuthorisationPolicy> tmpPos = new Vector<AuthorisationPolicy>();
        ListIterator<Pair> iter = pairList.listIterator(0);
        while (iter.hasNext()) {
            Pair p = iter.next();
            if (DEBUG) {
                System.out.println("\tAuthPolicySearch.findCandidatePolicy(): going to serach for policy on pair: " + p);
            }
            P2ManagedObject subject = p.getFirstElement();
            P2ManagedObject target = p.getSecondElement();
            Iterator<AuthorisationPolicy> pIter = subject.getAuthorisationPolicies().iterator();
            AuthorisationPolicy policy = null;
            while (pIter.hasNext()) {
                policy = pIter.next();
                if (!action.equals(policy.getAction()) && !"*".equals(policy.getAction()) || policy.getTarget() == null || !policy.getTarget().equals(target) || !policy.getSubject().equals(subject) || policy.getFocus() != focus) continue;
                if (policy.isFinal()) {
                    if (policy.isAuthRequestNeg()) {
                        tmpFinalNeg.add(policy);
                    }
                    if (DEBUG) {
                        System.out.println("\t\tAuthPolicySearch.findCandidatePolicy(): added negative final  policy: \n\t\t\t" + policy);
                    } else {
                        tmpFinalPos.add(policy);
                    }
                    if (!DEBUG) continue;
                    System.out.println("\t\tAuthPolicySearch.findCandidatePolicy(): added  final  policy: \n\t\t\t" + policy);
                    continue;
                }
                if (policy.isAuthRequestNeg()) {
                    tmpNeg.add(policy);
                    if (!DEBUG) continue;
                    System.out.println("\t\tAuthPolicySearch.findCandidatePolicy(): added negative normal policy: \n\t\t\t" + policy);
                    continue;
                }
                tmpPos.add(policy);
                if (!DEBUG) continue;
                System.out.println("\t\tAuthPolicySearch.findCandidatePolicy(): added normal policy: \n\t\t\t" + policy);
            }
            finalPolicyCandidate.addAll(tmpFinalNeg);
            finalPolicyCandidate.addAll(tmpFinalPos);
            normalPolicyCandidate.addAll(tmpPos);
            normalPolicyCandidate.addAll(tmpNeg);
            tmpFinalNeg.removeAllElements();
            tmpFinalPos.removeAllElements();
            tmpNeg.removeAllElements();
            tmpPos.removeAllElements();
        }
    }

    public static short evaluate(AuthPolicyHolder holder, AuthorisationPolicy policy, short pepType, P2Object subject, P2Object ... argAttribute) {
        if (pepType == AuthorisationModule.getValueOf("PEP1") || pepType == AuthorisationModule.getValueOf("PEP2")) {
            if (policy.isActive() && policy.checkRequestCondition(subject, argAttribute)) {
                if (!policy.isAuthRequestNeg()) {
                    if (pepType == AuthorisationModule.getValueOf("PEP1")) {
                        holder.setOutgoingAuthPol(policy);
                    } else {
                        holder.setIncomingAuthPol(policy);
                    }
                    if (DEBUG) {
                        System.out.println("\tAuthPolicySearch, evaluate @ PEP" + pepType + ": " + "A VALID POLICY WAS FOUND.\n " + "\t\tThe policy is an AUTH+ and the request condition is true.\n " + "\t\tThe OPERATION " + policy.getAction() + " WILL BE AUTHORIZED");
                    }
                    return 0;
                }
                if (DEBUG) {
                    System.out.println("\tAuthPolicySearch, evaluate @ PEP" + pepType + ": " + "A VALID POLICY WAS FOUND.\n " + "\t\tThe policy is an AUTH- and the request condition is true.\n " + "\t\tThe OPERATION " + policy.getAction() + " WILL BE NOT AUTHORIZED");
                }
                return 1;
            }
        } else if ((pepType == AuthorisationModule.getValueOf("PEP3") || pepType == AuthorisationModule.getValueOf("PEP4")) && policy.isActive() && policy.checkReturnCondition(subject, argAttribute)) {
            if (!policy.isAuthReplyNeg()) {
                if (DEBUG) {
                    System.out.println("\tAuthPolicySearch, evaluate @ PEP" + pepType + ": " + "A VALID POLICY WAS FOUND.\n " + "\t\tThe policy is an AUTH+ and the return condition is true.\n " + "\t\tThe OPERATION " + policy.getAction() + " WILL BE AUTHORIZED");
                }
                return 0;
            }
            if (DEBUG) {
                System.out.println("\tAuthPolicySearch, evaluate @ PEP" + pepType + ": " + "A VALID POLICY WAS FOUND.\n " + "\\ttThe policy is an AUTH- and the return condition is true.\n " + "\t\tThe OPERATION " + policy.getAction() + " WILL BE NOT AUTHORIZED");
            }
            return 1;
        }
        return 2;
    }

    private short findFinalPolicy(Vector<AuthorisationPolicy> finalPolicyCandidate, AuthPolicyHolder holder, short pepType, P2Object subject, P2Object[] args, P2Object result) {
        AuthorisationPolicy policy = null;
        short conditionState = 2;
        int i = 0;
        while (i < finalPolicyCandidate.size()) {
            policy = finalPolicyCandidate.elementAt(i);
            if (pepType == AuthorisationModule.getValueOf("PEP1") || pepType == AuthorisationModule.getValueOf("PEP2")) {
                conditionState = AuthPolicySearch.evaluate(holder, policy, pepType, subject, args);
            } else if (pepType == AuthorisationModule.getValueOf("PEP3") || pepType == AuthorisationModule.getValueOf("PEP4")) {
                conditionState = AuthPolicySearch.evaluate(holder, policy, pepType, subject, result);
            }
            if (conditionState != 2) {
                return conditionState;
            }
            ++i;
        }
        return conditionState;
    }

    private short findNormalPolicy(Vector<AuthorisationPolicy> normalPolicyCandidate, AuthPolicyHolder holder, short pepType, P2Object subject, P2Object[] args, P2Object result) {
        AuthorisationPolicy policy = null;
        short conditionState = 2;
        int i = normalPolicyCandidate.size();
        while (i > 0) {
            policy = normalPolicyCandidate.elementAt(i - 1);
            if (pepType == AuthorisationModule.getValueOf("PEP1") || pepType == AuthorisationModule.getValueOf("PEP2")) {
                conditionState = AuthPolicySearch.evaluate(holder, policy, pepType, subject, args);
            } else if (pepType == AuthorisationModule.getValueOf("PEP3") || pepType == AuthorisationModule.getValueOf("PEP4")) {
                conditionState = AuthPolicySearch.evaluate(holder, policy, pepType, subject, result);
            }
            if (conditionState != 2) {
                return conditionState;
            }
            --i;
        }
        return conditionState;
    }

    public short search(AuthPolicyHolder holder, short pepType, P2Object subject, P2Object target, String action, char focus, P2Object[] args, P2Object result) {
        if (DEBUG) {
            System.out.println("\n\n\nAuthPolicySearch.search(): New Search started @ PEP" + pepType + " for tuple \n" + "\t\tsubject:" + subject + "(" + subject.getOID() + ")\n" + "\t\ttarget:" + target + "(" + target.getOID() + "),\n" + "\t\taction:" + action);
        }
        short conditionState = 2;
        this.subjectPath = new Vector();
        this.targetPath = new Vector();
        if (DEBUG) {
            System.out.println("AuthPolicySearch.search(): going to build the path for subject");
        }
        this.buildPath(subject.getManagedObject(), this.subjectPath);
        if (DEBUG) {
            System.out.println("AuthPolicySearch.search(): going to build the path for target");
        }
        this.buildPath(target.getManagedObject(), this.targetPath);
        if (!this.subjectPath.isEmpty() && !this.targetPath.isEmpty()) {
            if (DEBUG) {
                System.out.println("AuthPolicySearch.search(): going to multiply subject by target paths");
            }
            this.multiply();
            Iterator<LinkedList<Pair>> listIter = this.pathCombination.iterator();
            while (listIter.hasNext()) {
                short tmpConState;
                Vector<AuthorisationPolicy> finalPolicyCandidate = new Vector<AuthorisationPolicy>();
                Vector<AuthorisationPolicy> normalPolicyCandidate = new Vector<AuthorisationPolicy>();
                if (DEBUG) {
                    System.out.println("AuthPolicySearch.search(): going to find candidate policies");
                }
                this.findCandidatePolicy(listIter.next(), action, focus, finalPolicyCandidate, normalPolicyCandidate);
                if (DEBUG) {
                    System.out.println("AuthPolicySearch, search: the vector of final policies for focus " + focus + " is \n\t" + this.printVector(finalPolicyCandidate));
                    System.out.println("AuthPolicySearch, search: the vector of normal policies for focus " + focus + " is \n\t" + this.printVector(normalPolicyCandidate));
                }
                if ((tmpConState = this.findFinalPolicy(finalPolicyCandidate, holder, pepType, subject, args, result)) == 1) {
                    return 1;
                }
                if (tmpConState == 0) {
                    conditionState = 0;
                    continue;
                }
                if (tmpConState != 2) continue;
                tmpConState = this.findNormalPolicy(normalPolicyCandidate, holder, pepType, subject, args, result);
                if (tmpConState == 1) {
                    return 1;
                }
                if (tmpConState != 0) continue;
                conditionState = 0;
            }
        }
        return conditionState;
    }

    private String printVector(Vector<AuthorisationPolicy> policyList) {
        String slist = "[";
        Iterator<AuthorisationPolicy> policyIter = policyList.iterator();
        while (policyIter.hasNext()) {
            slist = String.valueOf(slist) + policyIter.next() + "\n";
        }
        slist = String.valueOf(slist) + "]";
        return slist;
    }

    public static String printState(short state) {
        if (state == 0) {
            return "The subject is AUTORIZED";
        }
        if (1 == state) {
            return "The subject is NOTAUTHORIZED";
        }
        if (2 == state) {
            return "NO POLice was DEFINED for the subject+target+action combo";
        }
        return "the value " + state + " is unknown";
    }

    private class Pair {
        P2ManagedObject firstElement;
        P2ManagedObject secondElement;

        public Pair(P2ManagedObject firstElement, P2ManagedObject secondElement) {
            this.firstElement = firstElement;
            this.secondElement = secondElement;
        }

        public P2ManagedObject getFirstElement() {
            return this.firstElement;
        }

        public void setFirstElement(P2ManagedObject firstElement) {
            this.firstElement = firstElement;
        }

        public P2ManagedObject getSecondElement() {
            return this.secondElement;
        }

        public void setSecondElement(P2ManagedObject secondElement) {
            this.secondElement = secondElement;
        }

        public boolean equals(Object pair) {
            return this.firstElement.equals(((Pair)pair).firstElement) && this.secondElement.equals(((Pair)pair).secondElement);
        }

        public String toString() {
            return "{" + this.firstElement.getOID() + "," + this.secondElement.getOID() + "}";
        }
    }
}

