/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.objects;

import com.twicom.qdparser.TaggedElement;
import net.ponder2.ManagedObject;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2Array;
import net.ponder2.objects.P2NumberP2Adaptor;
import net.ponder2.objects.P2Object;

public class P2Number
extends P2Object
implements ManagedObject {
    int number;

    protected P2Number() {
    }

    public P2Number(int value) {
        this.number = value;
    }

    public P2Number(String string) throws Ponder2ArgumentException {
        try {
            this.number = Integer.parseInt(string);
        }
        catch (NumberFormatException e2) {
            throw new Ponder2ArgumentException("cannot parse '" + string + "' as a number");
        }
    }

    public int asNumber() throws Ponder2ArgumentException {
        return this.number;
    }

    @Ponder2op(value="<")
    protected boolean lt(int aNumber) {
        return this.number < aNumber;
    }

    @Ponder2op(value=">")
    protected boolean gt(int aNumber) {
        return this.number > aNumber;
    }

    @Ponder2op(value="<=")
    protected boolean le(int aNumber) {
        return this.number <= aNumber;
    }

    @Ponder2op(value=">=")
    protected boolean ge(int aNumber) {
        return this.number >= aNumber;
    }

    @Ponder2op(value="==")
    protected boolean eq(int aNumber) {
        return this.number == aNumber;
    }

    @Ponder2op(value="!=")
    protected boolean ne(int aNumber) {
        return this.number != aNumber;
    }

    @Ponder2op(value="+")
    protected int plus(int aNumber) {
        return this.number + aNumber;
    }

    @Ponder2op(value="-")
    protected int minus(int aNumber) {
        return this.number - aNumber;
    }

    @Ponder2op(value="*")
    protected int times(int aNumber) {
        return this.number * aNumber;
    }

    @Ponder2op(value="do:")
    protected void op_do(P2Object source, P2Object aBlock) throws Ponder2Exception {
        int i = 0;
        while (i < this.number) {
            aBlock.operation(source, "value:", P2Object.create(i));
            ++i;
        }
    }

    @Ponder2op(value="collate:")
    protected P2Array op_colate(P2Object source, P2Object aBlock) throws Ponder2Exception {
        P2Array result = new P2Array();
        int i = 0;
        while (i < this.number) {
            result.add(aBlock.operation(source, "value:", P2Object.create(i)));
            ++i;
        }
        return result;
    }

    public P2Object operation(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        return P2NumberP2Adaptor.doOp(this, this, source, operation, args);
    }

    public String toString() {
        return "" + this.number;
    }

    public TaggedElement writeXml() throws Ponder2OperationException {
        TaggedElement xml = super.writeXml();
        xml.setAttribute("value", this.toString());
        return xml;
    }

    public P2Object readXml(TaggedElement xml) throws Ponder2OperationException {
        this.number = Integer.parseInt(xml.getAttribute("value"));
        return this;
    }
}

