/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.objects;

import com.twicom.qdparser.TaggedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.ponder2.ManagedObject;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2Array;
import net.ponder2.objects.P2Block;
import net.ponder2.objects.P2HashP2Adaptor;
import net.ponder2.objects.P2Object;
import net.ponder2.objects.P2String;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2Hash
extends P2Object
implements ManagedObject,
Map<String, P2Object> {
    private Map<String, P2Object> hash;

    public P2Hash() {
        this.hash = new HashMap<String, P2Object>();
    }

    public P2Hash(Map<String, P2Object> hash) {
        this.hash = hash;
    }

    @Override
    public P2Hash asHash() throws Ponder2ArgumentException {
        return this;
    }

    public Map<String, P2Object> asMap() {
        return this.hash;
    }

    protected void set(P2Hash hash) {
        this.clear();
        this.putAll((Map<? extends String, ? extends P2Object>)hash.asMap());
    }

    @Ponder2op(value="do:")
    public void operation_do(P2Object source, P2Block aBlock) throws Ponder2Exception {
        for (Map.Entry<String, P2Object> value : this.hash.entrySet()) {
            aBlock.execute(source, new P2String(value.getKey()), value.getValue());
        }
    }

    @Ponder2op(value="collate:")
    public P2Array operation_collate(P2Object source, P2Block aBlock) throws Ponder2Exception {
        P2Array result = new P2Array();
        for (Map.Entry<String, P2Object> value : this.hash.entrySet()) {
            result.add(aBlock.execute(source, new P2String(value.getKey()), value.getValue()));
        }
        return result;
    }

    @Ponder2op(value="at:put:")
    public P2Object operation_at_put(String aKey, P2Object anObject) {
        this.put(aKey, anObject);
        return anObject;
    }

    @Ponder2op(value="remove:")
    protected P2Object operation_remove(String aKey) {
        return this.remove(aKey);
    }

    @Ponder2op(value="has:")
    protected boolean operation_has(String aKey) {
        return this.containsKey(aKey);
    }

    @Ponder2op(value="at:ifAbsent:")
    public P2Object operation_at_ifAbsent(P2Object source, String aKey, P2Block aBlock) throws Ponder2Exception {
        if (this.containsKey(aKey)) {
            return this.get(aKey);
        }
        return aBlock.operation_value0(source);
    }

    @Ponder2op(value="at:")
    protected P2Object operation_at(String aKey) throws Ponder2ArgumentException {
        P2Object value = this.get(aKey);
        if (value == null) {
            throw new Ponder2ArgumentException("hash key '" + aKey + "' not found");
        }
        return value;
    }

    @Override
    public P2Object operation(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        return P2HashP2Adaptor.doOp(this, this, source, operation, args);
    }

    @Override
    public void clear() {
        this.hash.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hash.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.hash.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, P2Object>> entrySet() {
        return this.hash.entrySet();
    }

    @Override
    public P2Object get(Object key) {
        return this.hash.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.hash.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.hash.keySet();
    }

    @Override
    public P2Object put(String key, P2Object value) {
        return this.hash.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends P2Object> map) {
        this.hash.putAll(map);
    }

    @Override
    public P2Object remove(Object key) {
        return this.hash.remove(key);
    }

    @Override
    public int size() {
        return this.hash.size();
    }

    @Override
    public Collection<P2Object> values() {
        return this.hash.values();
    }

    @Override
    public TaggedElement writeXml() throws Ponder2OperationException {
        TaggedElement xml = super.writeXml();
        for (Map.Entry<String, P2Object> entry : this.hash.entrySet()) {
            TaggedElement xmlEntry = new TaggedElement("entry");
            xmlEntry.setAttribute("name", entry.getKey());
            TaggedElement xmlValue = entry.getValue().writeXml();
            xmlEntry.add(xmlValue);
            xml.add(xmlEntry);
        }
        return xml;
    }

    @Override
    public P2Object readXml(TaggedElement xml) throws Ponder2OperationException, Ponder2ArgumentException {
        for (TaggedElement xmlEntry : xml.getElements()) {
            String name = xmlEntry.getAttribute("name");
            P2Object obj = P2Object.fromXml((TaggedElement)xmlEntry.getChild(0));
            this.hash.put(name, obj);
        }
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (Map.Entry<String, P2Object> entry : this.hash.entrySet()) {
            buf.append(entry.getKey());
            buf.append("=\"");
            if (entry.getValue() == this) {
                buf.append("this");
            } else {
                buf.append(entry.getValue());
            }
            buf.append("\"");
        }
        buf.append("}");
        return buf.toString();
    }
}

