/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.managedobject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Vector;
import net.ponder2.ManagedObject;
import net.ponder2.Util;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.objects.P2Array;
import net.ponder2.objects.P2Block;
import net.ponder2.objects.P2Hash;
import net.ponder2.objects.P2Object;
import net.ponder2.objects.P2String;

public class CsvHash
extends P2Array
implements ManagedObject {
    private char comma = (char)44;
    P2String[] headers;

    @Ponder2op(value="create:")
    CsvHash(String url) {
        try {
            String line;
            URI uri = new URI(url);
            InputStream is = Util.getInputStream(uri);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String header = in.readLine();
            if (header == null) {
                return;
            }
            this.headers = this.split(0, header);
            while ((line = in.readLine()) != null) {
                P2Object[] data = this.split(this.headers.length, line);
                this.add(P2Object.create(data));
            }
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
        catch (URISyntaxException e3) {
            e3.printStackTrace();
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
    }

    @Ponder2op(value="titles")
    P2Object getTitles() {
        return P2Object.create(this.headers);
    }

    @Ponder2op(value="do:")
    void op_do(P2Object source, P2Block aBlock) throws Ponder2Exception {
        P2Object[] oldValue = new P2Object[this.headers.length];
        Iterator<P2Object> iter = this.getValues().iterator();
        while (iter.hasNext()) {
            P2Array line = iter.next().asP2Array();
            P2Hash hash = new P2Hash();
            int i = 0;
            while (i < this.headers.length) {
                P2Object value = line.at(i);
                if (oldValue[i] == null) {
                    oldValue[i] = value;
                }
                if (value.asString().length() == 0) {
                    value = oldValue[i];
                } else {
                    oldValue[i] = value;
                }
                hash.put(this.headers[i].asString(), value);
                ++i;
            }
            aBlock.operation(source, "value:", hash);
        }
    }

    private P2String[] split(int size, String line) {
        Vector<P2String> vec = new Vector<P2String>();
        int findex = 0;
        int tindex = 0;
        while ((long)(tindex = line.indexOf(this.comma, findex)) >= 0L) {
            vec.add(P2Object.create(line.substring(findex, tindex)));
            findex = tindex + 1;
        }
        vec.add(P2Object.create(line.substring(findex)));
        if (size > 0) {
            while (vec.size() < this.headers.length) {
                vec.add(P2Object.create(""));
            }
        }
        return vec.toArray(new P2String[vec.size()]);
    }
}

