/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.ponder2.Domain;
import net.ponder2.ExternalManagedObject;
import net.ponder2.FactoryObjectP2Adaptor;
import net.ponder2.ManagedObject;
import net.ponder2.P2ObjectAdaptor;
import net.ponder2.SelfManagedCellP2Adaptor;
import net.ponder2.Shell;
import net.ponder2.Util;
import net.ponder2.apt.Ponder2op;
import net.ponder2.comms.Transmitter;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.exception.Ponder2RemoteException;
import net.ponder2.objects.P2Block;
import net.ponder2.objects.P2Object;
import net.ponder2.policy.BasicAuthModule;

public class SelfManagedCell
extends Domain
implements ManagedObject {
    public static final String SVNDate = "$Date: 2007-08-07 14:32:12 +0200 (Tue, 07 Aug 2007) $";
    public static final String SVNRevision = "$Rev: 574 $";
    public static boolean SystemTrace = false;
    public static final String EventDomain = "/event";
    public static final String PolicyDomain = "/policy";
    public static P2Object RootDomain = null;
    public static int port = 13570;
    public static Map<String, String> startupArg;
    static boolean defaulAuthPolicy;
    static boolean isAuthModSet;

    static {
        defaulAuthPolicy = false;
        isAuthModSet = false;
    }

    @Ponder2op(value="create")
    public SelfManagedCell(P2Object myP2Object) {
        super(myP2Object);
        P2Object.setSMC(this);
        if (RootDomain == null) {
            RootDomain = myP2Object;
        }
        if (SystemTrace) {
            System.out.println("SelfManagedCell.SelfManagedCell(): my OID is " + myP2Object.getOID());
            System.out.println("SelfManagedCell.SelfManagedCell(): my myP2Objec is  " + myP2Object);
        }
    }

    @Ponder2op(value="exit")
    protected void exit() {
        System.exit(0);
    }

    @Ponder2op(value="exit:")
    protected void exit(int exitStatus) {
        System.exit(exitStatus);
    }

    @Ponder2op(value="load:")
    protected P2Object operation_load(String anObject) throws Ponder2Exception {
        P2Object p2Object = this.loadObject(anObject);
        return p2Object;
    }

    @Ponder2op(value="import:from:")
    protected P2Object operation_import_from(String aName, String aLocation) throws Ponder2Exception {
        P2Object oid = this.getRemoteObject(aName, aLocation);
        return oid;
    }

    @Ponder2op(value="trace:")
    protected boolean trace(boolean aBoolean) {
        SystemTrace = aBoolean;
        return aBoolean;
    }

    @Ponder2op(value="print:")
    protected String print(String aString) {
        if (SystemTrace) {
            System.out.print("Print: ");
        }
        System.out.println(aString);
        return aString;
    }

    @Ponder2op(value="execute:")
    protected P2Object trace(P2Object source, P2Block aBlock) throws Ponder2Exception {
        return aBlock.operation_value0(source);
    }

    public static boolean getDefaulAuthPolicy() {
        return defaulAuthPolicy;
    }

    public P2Object loadObject(String name) throws Ponder2Exception {
        FactoryObjectP2Adaptor p2Object = null;
        try {
            FactoryObjectP2Adaptor object;
            URI uri = new URI(name);
            String scheme = uri.getScheme();
            if (scheme == null) {
                scheme = "resource";
            }
            if (!scheme.equals("resource")) {
                throw new Ponder2ArgumentException("Load Managed Object - Scheme '" + scheme + "' not understood");
            }
            Class<P2ObjectAdaptor> adaptorClass = Util.getManagedObjectAdaptor(uri.getSchemeSpecificPart());
            if (adaptorClass == null) {
                throw new Ponder2ArgumentException("Load Managed Object - Adaptor for '" + uri.getSchemeSpecificPart() + "' not found");
            }
            p2Object = object = new FactoryObjectP2Adaptor(null, "create:", P2Object.create(adaptorClass));
        }
        catch (URISyntaxException e2) {
            throw new Ponder2ArgumentException("Load Managed Object - Bad URI syntax " + e2.getReason());
        }
        return p2Object;
    }

    public P2Object getRemoteObject(String name, String location) throws Ponder2Exception {
        try {
            if (name == null || location == null) {
                throw new Ponder2ArgumentException("Get remote object error: name " + name + " from " + location);
            }
            URI uri = new URI(location);
            String scheme = uri.getScheme();
            if (scheme == null) {
                throw new Ponder2ArgumentException("Get remote object: missing scheme/protocol in " + location);
            }
            Transmitter remote = ExternalManagedObject.getRemote(uri);
            return remote.getObject(uri, name);
        }
        catch (URISyntaxException e2) {
            throw new Ponder2RemoteException("getRemote: " + e2.getMessage());
        }
    }

    public static void start(String[] args) {
        SelfManagedCellP2Adaptor smc;
        String defaultPolicyValue = null;
        Vector<String> bootFiles = new Vector<String>();
        port = 13570;
        int portBase = 13570;
        boolean multipleSMCs = false;
        bootFiles.add("boot.p2");
        startupArg = new HashMap<String, String>();
        try {
            smc = new SelfManagedCellP2Adaptor(null, "create", new P2Object[0]);
        }
        catch (Exception e2) {
            System.out.println("Failed to start SMC: ");
            e2.printStackTrace();
            return;
        }
        int i = 0;
        while (i < args.length) {
            String flag = args[i];
            if (flag.startsWith("-")) {
                if (flag.equals("-port")) {
                    port = portBase = Integer.parseInt(args[++i]);
                } else if (flag.equals("-boot")) {
                    String bootFile;
                    if ((bootFile = args[++i]).equals("-")) {
                        bootFiles.clear();
                    } else {
                        bootFiles.add(bootFile);
                    }
                } else if (flag.equals("-multiple")) {
                    multipleSMCs = true;
                } else if (flag.equals("-trace")) {
                    SystemTrace = true;
                } else if (flag.equals("-address")) {
                    String address = args[++i];
                    try {
                        ExternalManagedObject.loadProtocol(null, address);
                    }
                    catch (Ponder2RemoteException e3) {
                        System.err.println("Failed to allocate address " + address + ": " + e3.getMessage());
                    }
                } else if (flag.equals("-auth")) {
                    defaultPolicyValue = args[++i];
                } else if (flag.equals("-version") || flag.equals("--version")) {
                    System.out.print("Ponder2 Core ");
                    System.out.print(SVNRevision.substring(1, SVNRevision.length() - 2));
                    System.out.print(" ");
                    System.out.print(SVNDate.substring(1, SVNDate.length() - 2));
                    System.out.println();
                    System.exit(0);
                } else {
                    startupArg.put(flag, args[++i]);
                }
            }
            ++i;
        }
        if (portBase != 0 && (port = Shell.initialise(smc, portBase, multipleSMCs)) == 0) {
            System.err.println("Failed to open port " + portBase + ".");
            System.err.println("Use -multiple for multiple SMCs");
            System.err.println("Use -port 0 for no shell access");
            System.exit(1);
        }
        if (defaultPolicyValue != null) {
            isAuthModSet = true;
            defaulAuthPolicy = true;
            BasicAuthModule bAuthMod = new BasicAuthModule();
            bAuthMod.setRootDomain(RootDomain);
            P2ObjectAdaptor.setAuthorisation(bAuthMod);
        }
        for (String bootfile : bootFiles) {
            try {
                Util.parseFile(RootDomain, bootfile);
            }
            catch (Ponder2OperationException e4) {
                System.out.println("Ponder2 operation exception: " + e4.getMessage());
                if (!SystemTrace) continue;
                e4.printStackTrace();
            }
            catch (Ponder2ArgumentException e5) {
                System.out.println("Ponder2 argument exception: " + e5.getMessage());
                if (!SystemTrace) continue;
                e5.printStackTrace();
            }
            catch (Ponder2Exception e6) {
                System.out.println("Ponder2 exception: " + e6.getMessage());
                if (!SystemTrace) continue;
                e6.printStackTrace();
            }
        }
        if (defaultPolicyValue != null) {
            defaulAuthPolicy = defaultPolicyValue.equals("allow");
            System.out.println("SMC, the default authorization policy is " + (defaulAuthPolicy ? "positive" : "negative"));
        }
        if (port != 0) {
            System.out.println("Shell port " + port + " ready");
        }
    }

    public static void main(String[] args) {
        SelfManagedCell.start(args);
    }
}

