/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2;

import com.twicom.qdparser.TaggedElement;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.ponder2.ExternalManagedObjectP2Adaptor;
import net.ponder2.ManagedObject;
import net.ponder2.OID;
import net.ponder2.SelfManagedCell;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2Object;
import net.ponder2.policy.AuthPolicyHolder;
import net.ponder2.policy.AuthorisationModule;

public class P2ObjectAdaptor
extends P2Object
implements Externalizable {
    protected ManagedObject objImpl = null;
    private static AuthorisationModule authorisationModule = null;
    private OID myExternalOID = null;

    public P2ObjectAdaptor() {
    }

    public P2ObjectAdaptor(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        this.create(source, operation, args);
    }

    protected void setObj(ManagedObject obj) {
        this.objImpl = obj;
    }

    protected ManagedObject getObj() {
        return this.objImpl;
    }

    public static void setAuthorisation(AuthorisationModule auth) {
        authorisationModule = auth;
    }

    public P2Object create(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        CreateOperation op = this.getCreateOperation(operation);
        if (SelfManagedCell.SystemTrace) {
            P2ObjectAdaptor.trace("Create", this.getClass().getSimpleName(), operation, args);
        }
        this.objImpl = op.call(this, source, operation, args);
        return this;
    }

    public P2Object operation(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        InstanceOperation op = this.getInstanceOperation(operation);
        if (SelfManagedCell.SystemTrace) {
            P2ObjectAdaptor.trace("Operation", this.getClass().getSimpleName(), operation, args);
        }
        AuthPolicyHolder holder = new AuthPolicyHolder();
        if (authorisationModule != null && source != null) {
            authorisationModule.requestOutgoing(holder, source, this, operation, args);
            if (!(this.objImpl instanceof ExternalManagedObjectP2Adaptor)) {
                authorisationModule.requestIncoming(holder, source, this, operation, args);
            }
        }
        P2Object value = op.call(this, this.objImpl, source, operation, args);
        if (SelfManagedCell.SystemTrace) {
            if (value != null) {
                System.err.println(" => " + value);
            } else {
                System.err.println(" => *** Error: return value is null ***");
            }
        }
        if (authorisationModule != null && source != null) {
            if (!(this.objImpl instanceof ExternalManagedObjectP2Adaptor)) {
                authorisationModule.replyOutgoing(holder, source, this, operation, args, value);
            }
            authorisationModule.replyIncoming(holder, source, this, operation, args, value);
        }
        return value;
    }

    public static void trace(String opType, String className, String operation, P2Object ... args) {
        if (className.endsWith("P2Adaptor")) {
            className = className.substring(0, className.length() - 9);
        }
        System.err.print(String.valueOf(opType) + ": " + className + " " + operation + " ");
        int i = 0;
        while (i < args.length) {
            P2Object value = args[i];
            System.err.print(value + " ");
            ++i;
        }
        System.err.println();
    }

    public CreateOperation getCreateOperation(String opName) throws Ponder2OperationException {
        throw new Ponder2OperationException("Object " + this.getClass().getSimpleName() + " unknown constructor '" + opName + "'");
    }

    public InstanceOperation getInstanceOperation(String opName) throws Ponder2OperationException {
        throw new Ponder2OperationException("Object " + this.getClass() + " unknown operation '" + opName + "'");
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.myExternalOID = (OID)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.myExternalOID.getP2Object();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getOID());
    }

    public TaggedElement writeXml() throws Ponder2OperationException {
        return this.getOID().writeXml();
    }

    public P2Object readXml(TaggedElement xml) throws Ponder2OperationException, Ponder2ArgumentException {
        throw new Ponder2OperationException("P2ObjectAdaptor cannot be read in as a serialised object");
    }

    public static abstract class CreateOperation {
        public abstract ManagedObject call(P2Object var1, P2Object var2, String var3, P2Object ... var4) throws Ponder2Exception;
    }

    public static abstract class InstanceOperation {
        public abstract P2Object call(P2Object var1, ManagedObject var2, P2Object var3, String var4, P2Object ... var5) throws Ponder2Exception;
    }
}

