/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.HashSet;
import java.util.Set;
import net.ponder2.Event;
import net.ponder2.OID;
import net.ponder2.Policy;
import net.ponder2.Ponder2Message;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.objects.P2Object;
import net.ponder2.policy.AuthorisationPolicy;
import net.ponder2.policy.ObligationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2ManagedObject
implements Ponder2Message,
Externalizable {
    private Set<P2ManagedObject> parentSet;
    private Set<ObligationPolicy> obligationPolicySet;
    private Set<AuthorisationPolicy> authorisationPolicySet;
    private OID oid;
    private P2Object p2Object;

    public P2ManagedObject(P2Object p2Object) {
        this.parentSet = new HashSet<P2ManagedObject>();
        this.obligationPolicySet = new HashSet<ObligationPolicy>();
        this.authorisationPolicySet = new HashSet<AuthorisationPolicy>();
        this.oid = new OID(this);
        this.p2Object = p2Object;
    }

    public P2ManagedObject() {
    }

    public OID getOID() {
        return this.oid;
    }

    public boolean isDomain() {
        return this.getOID().isDomain();
    }

    public P2Object getP2Object() {
        return this.p2Object;
    }

    protected void addParent(P2ManagedObject mo) {
        this.parentSet.add(mo);
    }

    protected void removeParent(P2ManagedObject mo) {
        this.parentSet.remove(mo);
    }

    public Set<P2ManagedObject> getParentSet() {
        return this.parentSet;
    }

    public int parentCount() {
        return this.parentSet.size();
    }

    public void applyPolicy(Policy policy) {
        if (policy instanceof ObligationPolicy) {
            this.obligationPolicySet.add((ObligationPolicy)policy);
        } else if (policy instanceof AuthorisationPolicy) {
            this.authorisationPolicySet.add((AuthorisationPolicy)policy);
        }
    }

    public void removePolicy(Policy policy) {
        if (policy instanceof ObligationPolicy) {
            this.obligationPolicySet.remove(policy);
        } else if (policy instanceof AuthorisationPolicy) {
            this.authorisationPolicySet.remove(policy);
        }
    }

    public Set<ObligationPolicy> getObligationPolicies() {
        return this.obligationPolicySet;
    }

    public Set<AuthorisationPolicy> getAuthorisationPolicies() {
        return this.authorisationPolicySet;
    }

    public void sendEvent(Event event) throws Ponder2Exception {
        if (event.setVisited(this)) {
            for (ObligationPolicy policy : this.obligationPolicySet) {
                policy.event(event);
            }
            for (P2ManagedObject mo : this.parentSet) {
                mo.sendEvent(event);
            }
        }
    }

    @Override
    public P2Object create(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        return this.p2Object.create(source, operation, args);
    }

    @Override
    public P2Object operation(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        return this.p2Object.operation(source, operation, args);
    }

    @Override
    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
    }

    protected Object readResolve() throws ObjectStreamException {
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput arg0) throws IOException {
    }
}

