/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.ponder2.ManagedObject;
import net.ponder2.P2ManagedObject;
import net.ponder2.Util;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.objects.P2Array;
import net.ponder2.objects.P2Block;
import net.ponder2.objects.P2Hash;
import net.ponder2.objects.P2Object;
import net.ponder2.objects.P2String;

public class Domain
implements ManagedObject {
    private final Map<String, P2ManagedObject> managedObjects;
    private P2Object myP2Object;

    @Ponder2op(value="create")
    protected Domain(P2Object myP2Object) {
        this.myP2Object = myP2Object;
        myP2Object.getOID().setDomain(true);
        this.managedObjects = new HashMap<String, P2ManagedObject>();
    }

    protected void add(String name, P2ManagedObject mo) {
        mo.addParent(this.myP2Object.getManagedObject());
        this.managedObjects.put(name, mo);
    }

    protected P2ManagedObject remove(String name) throws Ponder2Exception {
        P2ManagedObject mo = this.managedObjects.remove(name);
        if (mo != null && !this.managedObjects.containsValue(mo)) {
            mo.removeParent(this.myP2Object.getManagedObject());
        }
        return mo;
    }

    public P2ManagedObject get(String name) {
        return this.managedObjects.get(name);
    }

    public boolean containsKey(String name) {
        return this.managedObjects.containsKey(name);
    }

    protected String[] names() {
        int size = this.managedObjects.size();
        return this.managedObjects.keySet().toArray(new String[size]);
    }

    @Ponder2op(value="listNames")
    protected P2Object operation_listNames() {
        String[] names = this.names();
        P2Object[] values = new P2Object[names.length];
        int i = 0;
        while (i < names.length) {
            values[i] = new P2String(names[i]);
            ++i;
        }
        return new P2Array(values);
    }

    @Ponder2op(value="listObjects")
    protected P2Object operation_listObjects() {
        Collection<P2ManagedObject> mos = this.managedObjects.values();
        P2Object[] values = new P2Object[mos.size()];
        int i = 0;
        for (P2ManagedObject mo : mos) {
            values[i++] = mo.getP2Object();
        }
        return new P2Array(values);
    }

    @Ponder2op(value="asHash")
    protected P2Hash operation_asHash() {
        HashMap<String, P2Object> hash = new HashMap<String, P2Object>();
        for (Map.Entry<String, P2ManagedObject> entry : this.managedObjects.entrySet()) {
            hash.put(entry.getKey(), entry.getValue().getP2Object());
        }
        return new P2Hash(hash);
    }

    @Ponder2op(value="at:")
    protected P2Object operation_at(String aName) {
        P2ManagedObject mo = this.get(aName);
        return mo != null ? mo.getP2Object() : P2Object.create();
    }

    @Ponder2op(value="at:ifAbsent:")
    protected P2Object operation_at(P2Object source, String aName, P2Block aBlock) throws Ponder2Exception {
        return this.operation_asHash().operation_at_ifAbsent(source, aName, aBlock);
    }

    @Ponder2op(value="at:put:")
    protected P2Object operation_at_add(String aName, P2Object p2Object) {
        this.add(aName, p2Object.getManagedObject());
        return p2Object;
    }

    @Ponder2op(value="do:")
    protected void operation_do(P2Object source, P2Block aBlock) throws Ponder2Exception {
        this.operation_asHash().operation_do(source, aBlock);
    }

    @Ponder2op(value="collate:")
    protected P2Array operation_collate(P2Object source, P2Block aBlock) throws Ponder2Exception {
        return this.operation_asHash().operation_collate(source, aBlock);
    }

    @Ponder2op(value="resolve:")
    protected P2Object operation_resolve(String aPath) throws Ponder2Exception {
        return Util.resolve(this.myP2Object, aPath);
    }

    @Ponder2op(value="remove:")
    protected P2Object operation_remove(String aName) throws Ponder2Exception {
        P2ManagedObject mo = this.remove(aName);
        return mo != null ? mo.getP2Object() : P2Object.create();
    }
}

