/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.XMLChar;

public class schemagen {
    public static final String NS = "http://jena.hpl.hp.com/2003/04/schemagen#";
    public static final String DEFAULT_CONFIG_URI = "file:schemagen.rdf";
    public static final String DEFAULT_MARKER = "%";
    public static final String DEFAULT_TEMPLATE = "public static final %valclass% %valname% = m_model.%valcreator%( \"%valuri%\" );";
    public static final String DEFAULT_INDIVIDUAL_TEMPLATE = "public static final %valclass% %valname% = m_model.%valcreator%( \"%valuri%\", %valtype% );";
    public static final String DEFAULT_HEADER_TEMPLATE = "/* CVS $Id: $ */%nl%%package% %nl%%imports% %nl%/**%nl% * Vocabulary definitions from %sourceURI% %nl% * @author Auto-generated by schemagen on %date% %nl% */";
    public static final int COMMENT_LENGTH_LIMIT = 80;
    protected static final Object OPT_CONFIG_FILE = new Object();
    protected static final Object OPT_NO_COMMENTS = new Object();
    protected static final Object OPT_INPUT = new Object();
    protected static final Object OPT_LANG_DAML = new Object();
    protected static final Object OPT_LANG_OWL = new Object();
    protected static final Object OPT_LANG_RDFS = new Object();
    protected static final Object OPT_OUTPUT = new Object();
    protected static final Object OPT_HEADER = new Object();
    protected static final Object OPT_FOOTER = new Object();
    protected static final Object OPT_ROOT = new Object();
    protected static final Object OPT_MARKER = new Object();
    protected static final Object OPT_PACKAGENAME = new Object();
    protected static final Object OPT_ONTOLOGY = new Object();
    protected static final Object OPT_CLASSNAME = new Object();
    protected static final Object OPT_CLASSDEC = new Object();
    protected static final Object OPT_NAMESPACE = new Object();
    protected static final Object OPT_DECLARATIONS = new Object();
    protected static final Object OPT_PROPERTY_SECTION = new Object();
    protected static final Object OPT_CLASS_SECTION = new Object();
    protected static final Object OPT_INDIVIDUALS_SECTION = new Object();
    protected static final Object OPT_NOPROPERTIES = new Object();
    protected static final Object OPT_NOCLASSES = new Object();
    protected static final Object OPT_NOINDIVIDUALS = new Object();
    protected static final Object OPT_NOHEADER = new Object();
    protected static final Object OPT_PROP_TEMPLATE = new Object();
    protected static final Object OPT_CLASS_TEMPLATE = new Object();
    protected static final Object OPT_INDIVIDUAL_TEMPLATE = new Object();
    protected static final Object OPT_UC_NAMES = new Object();
    protected static final Object OPT_INCLUDE = new Object();
    protected static final Object OPT_CLASSNAME_SUFFIX = new Object();
    protected static final Object OPT_ENCODING = new Object();
    protected static final Object OPT_HELP = new Object();
    protected static final Object OPT_DOS = new Object();
    protected static final Object OPT_USE_INF = new Object();
    protected static final Object OPT_STRICT_INDIVIDUALS = new Object();
    public static final String[] JAVA_KEYWORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};
    private static List KEYWORD_LIST = Arrays.asList(JAVA_KEYWORDS);
    protected List m_cmdLineArgs;
    protected Resource m_root;
    protected Model m_config = ModelFactory.createDefaultModel();
    protected OntModel m_source;
    protected PrintStream m_output;
    protected Object[][] m_optionDefinitions = new Object[][]{{OPT_CONFIG_FILE, new OptionDefinition("-c", null)}, {OPT_ROOT, new OptionDefinition("-r", null)}, {OPT_NO_COMMENTS, new OptionDefinition("--nocomments", "noComments")}, {OPT_INPUT, new OptionDefinition("-i", "input")}, {OPT_LANG_DAML, new OptionDefinition("--daml", "daml")}, {OPT_LANG_OWL, new OptionDefinition("--owl", "owl")}, {OPT_LANG_RDFS, new OptionDefinition("--rdfs", "rdfs")}, {OPT_OUTPUT, new OptionDefinition("-o", "output")}, {OPT_HEADER, new OptionDefinition("--header", "header")}, {OPT_FOOTER, new OptionDefinition("--footer", "footer")}, {OPT_MARKER, new OptionDefinition("--marker", "marker")}, {OPT_PACKAGENAME, new OptionDefinition("--package", "package")}, {OPT_ONTOLOGY, new OptionDefinition("--ontology", "ontology")}, {OPT_CLASSNAME, new OptionDefinition("-n", "classname")}, {OPT_CLASSDEC, new OptionDefinition("--classdec", "classdec")}, {OPT_NAMESPACE, new OptionDefinition("-a", "namespace")}, {OPT_DECLARATIONS, new OptionDefinition("--declarations", "declarations")}, {OPT_PROPERTY_SECTION, new OptionDefinition("--propSection", "propSection")}, {OPT_CLASS_SECTION, new OptionDefinition("--classSection", "classSection")}, {OPT_INDIVIDUALS_SECTION, new OptionDefinition("--individualsSection", "individualsSection")}, {OPT_NOPROPERTIES, new OptionDefinition("--noproperties", "noproperties")}, {OPT_NOCLASSES, new OptionDefinition("--noclasses", "noclasses")}, {OPT_NOINDIVIDUALS, new OptionDefinition("--noindividuals", "noindividuals")}, {OPT_PROP_TEMPLATE, new OptionDefinition("--propTemplate", "propTemplate")}, {OPT_CLASS_TEMPLATE, new OptionDefinition("--classTemplate", "classTemplate")}, {OPT_INDIVIDUAL_TEMPLATE, new OptionDefinition("--individualTemplate", "individualTemplate")}, {OPT_UC_NAMES, new OptionDefinition("--uppercase", "uppercase")}, {OPT_INCLUDE, new OptionDefinition("--include", "include")}, {OPT_CLASSNAME_SUFFIX, new OptionDefinition("--classnamesuffix", "classnamesuffix")}, {OPT_NOHEADER, new OptionDefinition("--noheader", "noheader")}, {OPT_ENCODING, new OptionDefinition("-e", "encoding")}, {OPT_HELP, new OptionDefinition("--help", null)}, {OPT_DOS, new OptionDefinition("--dos", "dos")}, {OPT_USE_INF, new OptionDefinition("--inference", "inference")}, {OPT_STRICT_INDIVIDUALS, new OptionDefinition("--strictIndividuals", "strictIndividuals")}};
    protected List m_replacements = new ArrayList();
    protected String m_nl = "\n";
    protected int m_indentStep = 4;
    protected Set m_usedNames = new HashSet();
    protected Map m_resourcesToNames = new HashMap();
    protected List m_includeURI = new ArrayList();

    public static void main(String[] args) {
        new schemagen().go(args);
    }

    protected void go(String[] args) {
        block4: {
            this.m_cmdLineArgs = Arrays.asList(args);
            if (this.m_cmdLineArgs.contains(this.getOpt((Object)schemagen.OPT_HELP).m_cmdLineForm)) {
                this.usage();
            }
            String configURL = DEFAULT_CONFIG_URI;
            if (this.hasValue(OPT_CONFIG_FILE)) {
                configURL = this.urlCheck(this.getValue(OPT_CONFIG_FILE));
            }
            try {
                FileManager.get().readModel(this.m_config, configURL);
            }
            catch (Exception e2) {
                if (configURL.equals(DEFAULT_CONFIG_URI)) break block4;
                this.abort("Failed to read configuration from URI " + configURL, e2);
            }
        }
        this.processInput();
    }

    protected void processInput() {
        this.determineConfigRoot();
        this.determineLanguage();
        this.selectInput();
        this.selectOutput();
        this.setGlobalReplacements();
        this.processHeader();
        this.writeClassDeclaration();
        this.writeInitialDeclarations();
        this.writeProperties();
        this.writeClasses();
        this.writeIndividuals();
        this.writeClassClose();
        this.processFooter();
        this.closeOutput();
    }

    protected void determineConfigRoot() {
        if (this.hasValue(OPT_ROOT)) {
            String rootURI = this.getValue(OPT_ROOT);
            this.m_root = this.m_config.getResource(rootURI);
        } else {
            StmtIterator i = this.m_config.listStatements(null, RDF.type, this.m_config.getResource("http://jena.hpl.hp.com/2003/04/schemagen#Config"));
            this.m_root = i.hasNext() ? i.nextStatement().getSubject() : this.m_config.createResource();
        }
        this.m_includeURI.addAll(this.getAllValues(OPT_INCLUDE));
    }

    protected void determineLanguage() {
        OntModelSpec s = null;
        s = this.isTrue(OPT_LANG_DAML) ? (this.isTrue(OPT_USE_INF) ? OntModelSpec.DAML_MEM_RULE_INF : OntModelSpec.DAML_MEM) : (this.isTrue(OPT_LANG_RDFS) ? (this.isTrue(OPT_USE_INF) ? OntModelSpec.RDFS_MEM_RDFS_INF : OntModelSpec.RDFS_MEM) : (this.isTrue(OPT_USE_INF) ? OntModelSpec.OWL_MEM_RULE_INF : OntModelSpec.OWL_MEM));
        this.m_source = ModelFactory.createOntologyModel(s, null);
        this.m_source.getDocumentManager().setProcessImports(false);
    }

    protected void selectInput() {
        if (!this.hasResourceValue(OPT_INPUT)) {
            this.usage();
        }
        String input = this.urlCheck(this.getValue(OPT_INPUT));
        String syntax = this.getValue(OPT_ENCODING);
        try {
            FileManager.get().readModel(this.m_source, input, syntax);
        }
        catch (JenaException e2) {
            this.abort("Failed to read input source " + input, e2);
        }
    }

    protected void selectOutput() {
        String outFile = this.getValue(OPT_OUTPUT);
        if (outFile == null) {
            this.m_output = System.out;
        } else {
            try {
                File out = new File(outFile);
                if (out.isDirectory()) {
                    String fileName = outFile + System.getProperty("file.separator") + this.getClassName() + ".java";
                    out = new File(fileName);
                }
                this.m_output = new PrintStream(new FileOutputStream(out));
            }
            catch (Exception e2) {
                this.abort("I/O error while trying to open file for writing: " + outFile, e2);
            }
        }
        if (this.isTrue(OPT_DOS)) {
            this.m_nl = "\r\n";
        }
    }

    protected void processHeader() {
        String header;
        String string = header = this.hasValue(OPT_HEADER) ? this.getValue(OPT_HEADER) : DEFAULT_HEADER_TEMPLATE;
        if (!this.isTrue(OPT_NOHEADER)) {
            this.writeln(0, this.substitute(header));
        } else {
            this.writeln(0, "import com.hp.hpl.jena.rdf.model.*;");
            if (this.isTrue(OPT_ONTOLOGY)) {
                this.writeln(0, "import com.hp.hpl.jena.ontology.*;");
            }
        }
    }

    protected void processFooter() {
        String footer = this.getValue(OPT_FOOTER);
        if (footer != null) {
            this.writeln(0, this.substitute(footer));
        }
    }

    protected void setGlobalReplacements() {
        this.addReplacementPattern("date", new SimpleDateFormat("dd MMM yyyy HH:mm").format(new Date()));
        this.addReplacementPattern("package", this.hasValue(OPT_PACKAGENAME) ? "package " + this.getValue(OPT_PACKAGENAME) + ";" : "");
        this.addReplacementPattern("imports", this.getImports());
        this.addReplacementPattern("classname", this.getClassName());
        this.addReplacementPattern("sourceURI", this.getResource(OPT_INPUT).getURI());
        this.addReplacementPattern("nl", this.m_nl);
    }

    protected void addReplacementPattern(String key, String replacement) {
        if (replacement != null && key != null) {
            String marker = this.getValue(OPT_MARKER);
            marker = marker == null ? DEFAULT_MARKER : marker;
            try {
                this.m_replacements.add(new Replacement(Pattern.compile(marker + key + marker), replacement));
            }
            catch (PatternSyntaxException e2) {
                this.abort("Malformed regexp pattern " + marker + key + marker, e2);
            }
        }
    }

    protected void pop(int n) {
        for (int i = 0; i < n; ++i) {
            this.m_replacements.remove(this.m_replacements.size() - 1);
        }
    }

    protected void closeOutput() {
        this.m_output.flush();
        this.m_output.close();
    }

    protected boolean isTrue(Object option) {
        return this.getOpt(option).isTrue();
    }

    protected boolean hasValue(Object option) {
        return this.getOpt(option).hasValue();
    }

    protected boolean hasResourceValue(Object option) {
        return this.getOpt(option).hasResourceValue();
    }

    protected String getValue(Object option) {
        return this.getOpt(option).getValue();
    }

    protected List getAllValues(Object option) {
        Object s;
        ArrayList values = new ArrayList();
        OptionDefinition opt = this.getOpt(option);
        StmtIterator i = this.m_cmdLineArgs.iterator();
        while (i.hasNext()) {
            s = (String)i.next();
            if (!((String)s).equals(opt.m_cmdLineForm)) continue;
            values.add(i.next());
        }
        i = this.m_root.listProperties(opt.m_prop);
        while (i.hasNext()) {
            s = i.nextStatement();
            if (s.getObject() instanceof Literal) {
                values.add(s.getString());
                continue;
            }
            values.add(s.getResource().getURI());
        }
        return values;
    }

    protected Resource getResource(Object option) {
        return this.getOpt(option).getResource();
    }

    protected OptionDefinition getOpt(Object option) {
        for (int i = 0; i < this.m_optionDefinitions.length; ++i) {
            if (this.m_optionDefinitions[i][0] != option) continue;
            return (OptionDefinition)this.m_optionDefinitions[i][1];
        }
        return null;
    }

    protected void abort(String msg, Exception e2) {
        System.err.println(msg);
        if (e2 != null) {
            System.err.println(e2);
        }
        System.exit(1);
    }

    protected void usage() {
        System.err.println("Usage:");
        System.err.println("  java jena.schemagen [options ...]");
        System.err.println();
        System.err.println("Commonly used options include:");
        System.err.println("   -i <input> the source document as a file or URL.");
        System.err.println("   -n <name> the name of the created Java class.");
        System.err.println("   -a <uri> the namespace URI of the source document.");
        System.err.println("   -o <file> the file to write the generated class into.");
        System.err.println("   -o <dir> the directory in which the generated Java class is created.");
        System.err.println("            By default, output goes to stdout.");
        System.err.println("   -e <encoding> the encoding of the input document (N3, RDF/XML, etc).");
        System.err.println("   -c <config> a filename or URL for an RDF document containing ");
        System.err.println("               configuration parameters.");
        System.err.println();
        System.err.println("Many other options are available. See the schemagen HOWTO in the ");
        System.err.println("Jena documentation for full details.");
        System.exit(1);
    }

    protected String substitute(String sIn) {
        String s = sIn;
        Iterator i = this.m_replacements.iterator();
        while (i.hasNext()) {
            Replacement r = (Replacement)i.next();
            s = r.pattern.matcher(s).replaceAll(r.sub);
        }
        return s;
    }

    protected int indentTo(int i, StringBuffer buf) {
        int indent = i * this.m_indentStep;
        for (int j = 0; j < indent; ++j) {
            buf.append(' ');
        }
        return indent;
    }

    protected void writeln(int indent) {
        this.writeln(indent, "");
    }

    protected void writeln(int indent, String s) {
        this.write(indent, s);
        this.m_output.print(this.m_nl);
    }

    protected void write(int indentLevel, String s) {
        for (int i = 0; i < this.m_indentStep * indentLevel; ++i) {
            this.m_output.print(" ");
        }
        this.m_output.print(s);
    }

    protected String getImports() {
        StringBuffer buf = new StringBuffer();
        buf.append("import com.hp.hpl.jena.rdf.model.*;");
        buf.append(this.m_nl);
        if (this.useOntology()) {
            buf.append("import com.hp.hpl.jena.ontology.*;");
        }
        return buf.toString();
    }

    protected String getClassName() {
        int i;
        if (this.hasValue(OPT_CLASSNAME)) {
            return this.getValue(OPT_CLASSNAME);
        }
        String uri = this.getValue(OPT_INPUT);
        uri = uri.endsWith("#") ? uri.substring(0, uri.length() - 1) : uri;
        uri = uri.endsWith(".daml") ? uri.substring(0, uri.length() - 5) : uri;
        uri = uri.endsWith(".owl") ? uri.substring(0, uri.length() - 4) : uri;
        uri = uri.endsWith(".rdf") ? uri.substring(0, uri.length() - 4) : uri;
        uri = uri.endsWith(".rdfs") ? uri.substring(0, uri.length() - 5) : uri;
        uri = uri.endsWith(".n3") ? uri.substring(0, uri.length() - 3) : uri;
        uri = uri.endsWith(".xml") ? uri.substring(0, uri.length() - 4) : uri;
        for (i = uri.length() - 1; i > 0; --i) {
            if (Character.isUnicodeIdentifierPart(uri.charAt(i)) || uri.charAt(i) == '-') continue;
            ++i;
            break;
        }
        String name = uri.substring(i);
        if (this.hasValue(OPT_CLASSNAME_SUFFIX)) {
            name = name + this.getValue(OPT_CLASSNAME_SUFFIX);
        }
        return this.asLegalJavaID(name, true);
    }

    protected boolean useOntology() {
        return this.isTrue(OPT_ONTOLOGY);
    }

    protected boolean noComments() {
        return this.isTrue(OPT_NO_COMMENTS);
    }

    protected String asLegalJavaID(String s, boolean cap) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        try {
            while (!Character.isJavaIdentifierStart(s.charAt(i))) {
                ++i;
            }
        }
        catch (StringIndexOutOfBoundsException e2) {
            System.err.println("Could not identify legal Java identifier start character in '" + s + "', replacing with __");
            return "__";
        }
        buf.append(cap ? Character.toUpperCase(s.charAt(i)) : s.charAt(i));
        ++i;
        while (i < s.length()) {
            char c = s.charAt(i);
            buf.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
            ++i;
        }
        if (KEYWORD_LIST.contains(buf.toString())) {
            buf.append('_');
        }
        return buf.toString();
    }

    protected void writeClassDeclaration() {
        this.write(0, "public class ");
        this.write(0, this.getClassName());
        this.write(0, " ");
        if (this.hasValue(OPT_CLASSDEC)) {
            this.write(0, this.getValue(OPT_CLASSDEC));
        }
        this.writeln(0, "{");
    }

    protected void writeClassClose() {
        this.writeln(0, "}");
    }

    protected void writeInitialDeclarations() {
        this.writeModelDeclaration();
        this.writeNamespace();
        if (this.hasValue(OPT_DECLARATIONS)) {
            this.writeln(0, this.getValue(OPT_DECLARATIONS));
        }
    }

    protected void writeModelDeclaration() {
        if (this.useOntology()) {
            String lang = "OWL";
            if (this.isTrue(OPT_LANG_DAML)) {
                lang = "DAML";
            } else if (this.isTrue(OPT_LANG_RDFS)) {
                lang = "RDFS";
            }
            this.writeln(1, "/** <p>The ontology model that holds the vocabulary terms</p> */");
            this.writeln(1, "private static OntModel m_model = ModelFactory.createOntologyModel( OntModelSpec." + lang + "_MEM, null );");
        } else {
            this.writeln(1, "/** <p>The RDF model that holds the vocabulary terms</p> */");
            this.writeln(1, "private static Model m_model = ModelFactory.createDefaultModel();");
        }
        this.writeln(1);
    }

    protected void writeNamespace() {
        String nsURI = this.determineNamespaceURI();
        this.writeln(1, "/** <p>The namespace of the vocabulary as a string</p> */");
        this.writeln(1, "public static final String NS = \"" + nsURI + "\";");
        this.writeln(1);
        this.writeln(1, "/** <p>The namespace of the vocabulary as a string</p>");
        this.writeln(1, " *  @see #NS */");
        this.writeln(1, "public static String getURI() {return NS;}");
        this.writeln(1);
        this.writeln(1, "/** <p>The namespace of the vocabulary as a resource</p> */");
        this.writeln(1, "public static final Resource NAMESPACE = m_model.createResource( NS );");
        this.writeln(1);
    }

    protected String determineNamespaceURI() {
        if (this.hasResourceValue(OPT_NAMESPACE)) {
            String ns = this.getResource(OPT_NAMESPACE).getURI();
            this.m_includeURI.add(ns);
            return ns;
        }
        String defaultNS = this.m_source.getNsPrefixURI("");
        if (defaultNS == null) {
            defaultNS = this.m_source.getBaseModel().getNsPrefixURI("");
        }
        if (defaultNS != null) {
            this.m_includeURI.add(defaultNS);
            return defaultNS;
        }
        try {
            Resource ont = this.m_source.getBaseModel().listStatements(null, RDF.type, this.m_source.getProfile().ONTOLOGY()).nextStatement().getSubject();
            String uri = ont.getURI();
            char ch = uri.charAt(uri.length() - 1);
            boolean endsWithNCNameCh = XMLChar.isNCName(ch);
            uri = endsWithNCNameCh ? uri + "#" : uri;
            this.m_includeURI.add(uri);
            return uri;
        }
        catch (Exception e2) {
            this.abort("Could not determine the base URI for the input vocabulary", null);
            return null;
        }
    }

    protected void writeProperties() {
        if (this.isTrue(OPT_NOPROPERTIES)) {
            return;
        }
        if (this.hasValue(OPT_PROPERTY_SECTION)) {
            this.writeln(0, this.getValue(OPT_PROPERTY_SECTION));
        }
        if (this.useOntology()) {
            this.writeObjectProperties();
            this.writeDatatypeProperties();
            this.writeAnnotationProperties();
            this.writeRDFProperties(true);
        } else {
            this.writeRDFProperties(false);
        }
    }

    protected void writeObjectProperties() {
        String template;
        String string = template = this.hasValue(OPT_PROP_TEMPLATE) ? this.getValue(OPT_PROP_TEMPLATE) : DEFAULT_TEMPLATE;
        if (!this.isTrue(OPT_LANG_RDFS)) {
            ExtendedIterator i = this.m_source.listObjectProperties();
            while (i.hasNext()) {
                this.writeValue((Resource)i.next(), template, "ObjectProperty", "createObjectProperty", "_PROP");
            }
        }
    }

    protected void writeDatatypeProperties() {
        String template;
        String string = template = this.hasValue(OPT_PROP_TEMPLATE) ? this.getValue(OPT_PROP_TEMPLATE) : DEFAULT_TEMPLATE;
        if (!this.isTrue(OPT_LANG_RDFS)) {
            ExtendedIterator i = this.m_source.listDatatypeProperties();
            while (i.hasNext()) {
                this.writeValue((Resource)i.next(), template, "DatatypeProperty", "createDatatypeProperty", "_PROP");
            }
        }
    }

    protected void writeAnnotationProperties() {
        String template;
        String string = template = this.hasValue(OPT_PROP_TEMPLATE) ? this.getValue(OPT_PROP_TEMPLATE) : DEFAULT_TEMPLATE;
        if (!this.isTrue(OPT_LANG_RDFS)) {
            ExtendedIterator i = this.m_source.listAnnotationProperties();
            while (i.hasNext()) {
                this.writeValue((Resource)i.next(), template, "AnnotationProperty", "createAnnotationProperty", "_PROP");
            }
        }
    }

    protected void writeRDFProperties(boolean useOntProperty) {
        String propType;
        String template = this.hasValue(OPT_PROP_TEMPLATE) ? this.getValue(OPT_PROP_TEMPLATE) : DEFAULT_TEMPLATE;
        String string = propType = useOntProperty ? "OntProperty" : "Property";
        Resource[] props = this.isTrue(OPT_LANG_OWL) ? new Resource[]{OWL.ObjectProperty, OWL.DatatypeProperty, RDF.Property} : (this.isTrue(OPT_LANG_DAML) ? new Resource[]{DAML_OIL.ObjectProperty, DAML_OIL.DatatypeProperty, RDF.Property} : new Resource[]{RDF.Property});
        for (int j = 0; j < props.length; ++j) {
            StmtIterator i = this.m_source.listStatements(null, RDF.type, props[j]);
            while (i.hasNext()) {
                this.writeValue(i.nextStatement().getSubject(), template, propType, "create" + propType, "_PROP");
            }
        }
    }

    protected void writeClasses() {
        if (this.isTrue(OPT_NOCLASSES)) {
            return;
        }
        if (this.hasValue(OPT_CLASS_SECTION)) {
            this.writeln(0, this.getValue(OPT_CLASS_SECTION));
        }
        if (this.useOntology()) {
            this.writeOntClasses();
        } else {
            this.writeRDFClasses();
        }
    }

    protected void writeOntClasses() {
        String template = this.hasValue(OPT_CLASS_TEMPLATE) ? this.getValue(OPT_CLASS_TEMPLATE) : DEFAULT_TEMPLATE;
        ExtendedIterator i = this.m_source.listClasses();
        while (i.hasNext()) {
            this.writeValue((Resource)i.next(), template, "OntClass", "createClass", "_CLASS");
        }
    }

    protected void writeRDFClasses() {
        String template = this.hasValue(OPT_CLASS_TEMPLATE) ? this.getValue(OPT_CLASS_TEMPLATE) : DEFAULT_TEMPLATE;
        Resource cls = OWL.Class;
        if (this.isTrue(OPT_LANG_DAML)) {
            cls = DAML_OIL.Class;
        } else if (this.isTrue(OPT_LANG_RDFS)) {
            cls = RDFS.Class;
        }
        StmtIterator i = this.m_source.listStatements(null, RDF.type, cls);
        while (i.hasNext()) {
            this.writeValue(i.nextStatement().getSubject(), template, "Resource", "createResource", "_CLASS");
        }
    }

    protected void writeIndividuals() {
        if (this.isTrue(OPT_NOINDIVIDUALS)) {
            return;
        }
        if (this.hasValue(OPT_INDIVIDUALS_SECTION)) {
            this.writeln(0, this.getValue(OPT_INDIVIDUALS_SECTION));
        }
        if (this.useOntology()) {
            this.writeOntIndividuals();
        } else {
            this.writeRDFIndividuals();
        }
    }

    protected void writeOntIndividuals() {
        String template = this.hasValue(OPT_INDIVIDUAL_TEMPLATE) ? this.getValue(OPT_INDIVIDUAL_TEMPLATE) : DEFAULT_INDIVIDUAL_TEMPLATE;
        StmtIterator i = this.m_source.listStatements(null, RDF.type, (RDFNode)null);
        block0: while (i.hasNext()) {
            Resource candObj;
            Statement candidate = i.nextStatement();
            if (!(candidate.getObject() instanceof Resource) || (candObj = (Resource)candidate.getObject()).isAnon()) continue;
            String uri = candObj.getURI();
            Iterator j = this.m_includeURI.iterator();
            while (j.hasNext()) {
                if (!uri.startsWith((String)j.next())) continue;
                Resource ind = candidate.getSubject();
                String varName = (String)this.m_resourcesToNames.get(candidate.getObject());
                String valType = varName != null ? varName : "m_model.createClass( \"" + uri + "\" )";
                this.addReplacementPattern("valtype", valType);
                this.writeValue(ind, template, "Individual", "createIndividual", "_INSTANCE");
                this.pop(1);
                continue block0;
            }
        }
    }

    protected void writeRDFIndividuals() {
        String template = this.hasValue(OPT_INDIVIDUAL_TEMPLATE) ? this.getValue(OPT_INDIVIDUAL_TEMPLATE) : DEFAULT_TEMPLATE;
        StmtIterator i = this.m_source.listStatements(null, RDF.type, (RDFNode)null);
        block0: while (i.hasNext()) {
            Resource candObj;
            Statement candidate = i.nextStatement();
            if (!(candidate.getObject() instanceof Resource) || (candObj = candidate.getResource()).isAnon()) continue;
            String uri = candObj.getURI();
            Iterator j = this.m_includeURI.iterator();
            while (j.hasNext()) {
                if (!uri.startsWith((String)j.next())) continue;
                this.writeValue(candidate.getSubject(), template, "Resource", "createResource", "_INSTANCE");
                continue block0;
            }
        }
    }

    protected void writeValue(Resource r, String template, String valueClass, String creator, String disambiguator) {
        if (!this.filter(r)) {
            if (!this.noComments() && this.hasComment(r)) {
                this.writeln(1, this.formatComment(this.getComment(r)));
            }
            this.addReplacementPattern("valuri", r.getURI());
            this.addReplacementPattern("valname", this.getValueName(r, disambiguator));
            this.addReplacementPattern("valclass", valueClass);
            this.addReplacementPattern("valcreator", creator);
            this.writeln(1, this.substitute(template));
            this.writeln(1);
            this.pop(4);
        }
    }

    protected boolean hasComment(Resource r) {
        return r.hasProperty(RDFS.comment) || r.hasProperty(DAML_OIL.comment);
    }

    protected String getComment(Resource r) {
        StringBuffer comment = new StringBuffer();
        NodeIterator ni = this.m_source.listObjectsOfProperty(r, RDFS.comment);
        while (ni.hasNext()) {
            RDFNode n = ni.nextNode();
            if (n instanceof Literal) {
                comment.append(((Literal)n).getLexicalForm().trim());
                continue;
            }
            LogFactory.getLog(this.getClass()).debug("Not a literal: " + n);
        }
        ni = this.m_source.listObjectsOfProperty(r, DAML_OIL.comment);
        while (ni.hasNext()) {
            comment.append(((Literal)ni.nextNode()).getLexicalForm().trim());
        }
        return comment.toString();
    }

    protected String formatComment(String comment) {
        StringBuffer buf = new StringBuffer();
        buf.append("/** <p>");
        boolean inSpace = false;
        int pos = buf.length();
        boolean singleLine = true;
        for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            if (Character.isWhitespace(c)) {
                if (inSpace) continue;
                c = ' ';
                inSpace = true;
            } else {
                inSpace = false;
            }
            if (c == '\\') {
                c = comment.charAt(++i);
                switch (c) {
                    case 'n': {
                        buf.append(this.m_nl);
                        pos = this.indentTo(1, buf);
                        buf.append(" *  ");
                        pos += 3;
                        singleLine = false;
                        break;
                    }
                }
            } else if (c == '<') {
                buf.append("&lt;");
                pos += 4;
            } else if (c == '>') {
                buf.append("&gt;");
                pos += 4;
            } else if (c == '&') {
                buf.append("&amp;");
                pos += 5;
            } else {
                buf.append(c);
                ++pos;
            }
            if (pos <= 80 || !inSpace) continue;
            buf.append(this.m_nl);
            pos = this.indentTo(1, buf);
            buf.append(" *  ");
            pos += 3;
            singleLine = false;
        }
        buf.append("</p>");
        buf.append(singleLine ? "" : this.m_nl);
        this.indentTo(singleLine ? 0 : 1, buf);
        buf.append(" */");
        return buf.toString();
    }

    protected boolean filter(Resource r) {
        if (r.isAnon()) {
            return true;
        }
        if (this.m_resourcesToNames.containsKey(r)) {
            return true;
        }
        Iterator i = this.m_includeURI.iterator();
        while (i.hasNext()) {
            String uri = (String)i.next();
            if (!r.getURI().startsWith(uri)) continue;
            return false;
        }
        if (!this.isTrue(OPT_STRICT_INDIVIDUALS)) {
            StmtIterator j = r.listProperties(RDF.type);
            while (j.hasNext()) {
                Resource typeRes = j.nextStatement().getResource();
                if (typeRes.isAnon()) continue;
                String typeURI = typeRes.getURI();
                Iterator i2 = this.m_includeURI.iterator();
                while (i2.hasNext()) {
                    String uri = (String)i2.next();
                    if (!typeURI.startsWith(uri)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected String getValueName(Resource r, String disambiguator) {
        String name = this.isTrue(OPT_UC_NAMES) ? this.getUCValueName(r) : r.getLocalName();
        name = this.asLegalJavaID(name, false);
        int attempt = 0;
        String baseName = name;
        while (this.m_usedNames.contains(name)) {
            name = attempt == 0 ? name + disambiguator : baseName + disambiguator + attempt;
            ++attempt;
        }
        this.m_usedNames.add(name);
        this.m_resourcesToNames.put(r, name);
        return name;
    }

    protected String getUCValueName(Resource r) {
        StringBuffer buf = new StringBuffer();
        String localName = r.getLocalName();
        char lastChar = '\u0000';
        for (int i = 0; i < localName.length(); ++i) {
            char c = localName.charAt(i);
            if (Character.isLowerCase(lastChar) && Character.isUpperCase(c)) {
                buf.append('_');
            }
            buf.append(Character.toUpperCase(c));
            lastChar = c;
        }
        return buf.toString();
    }

    protected String urlCheck(String uriOrFile) {
        boolean legal = true;
        String url = uriOrFile;
        try {
            new URL(url);
        }
        catch (MalformedURLException ignore) {
            legal = false;
        }
        if (!legal) {
            legal = true;
            String slash = System.getProperty("file.separator");
            url = "file:" + (uriOrFile.startsWith(slash) ? slash + slash : "") + uriOrFile;
            try {
                new URL(url);
            }
            catch (MalformedURLException ignore) {
                legal = false;
            }
        }
        if (!legal) {
            this.abort("Could not parse " + uriOrFile + " as a legal URL or a file reference. Aborting.", null);
        }
        return url;
    }

    protected class Replacement {
        protected String sub;
        protected Pattern pattern;

        protected Replacement(Pattern pattern, String sub) {
            this.sub = sub;
            this.pattern = pattern;
        }
    }

    protected class OptionDefinition {
        protected String m_cmdLineForm;
        protected Property m_prop;

        protected OptionDefinition(String cmdLineForm, String name) {
            this.m_cmdLineForm = cmdLineForm;
            if (name != null) {
                this.m_prop = schemagen.this.m_config.getProperty(schemagen.NS, name);
            }
        }

        protected boolean isTrue() {
            if (schemagen.this.m_cmdLineArgs.contains(this.m_cmdLineForm)) {
                return true;
            }
            if (schemagen.this.m_root.hasProperty(this.m_prop)) {
                return schemagen.this.m_root.getRequiredProperty(this.m_prop).getBoolean();
            }
            return false;
        }

        protected String getValue() {
            int index = schemagen.this.m_cmdLineArgs.indexOf(this.m_cmdLineForm);
            if (index >= 0) {
                try {
                    return (String)schemagen.this.m_cmdLineArgs.get(index + 1);
                }
                catch (IndexOutOfBoundsException e2) {
                    System.err.println("Value for parameter " + this.m_cmdLineForm + " not set! Aborting.");
                }
            }
            if (this.m_prop != null && schemagen.this.m_root.hasProperty(this.m_prop)) {
                RDFNode val = schemagen.this.m_root.getRequiredProperty(this.m_prop).getObject();
                if (val instanceof Literal) {
                    return ((Literal)val).getLexicalForm();
                }
                return ((Resource)val).getURI().toString();
            }
            return null;
        }

        protected boolean hasValue() {
            return this.getValue() != null;
        }

        protected Resource getResource() {
            int index = schemagen.this.m_cmdLineArgs.indexOf(this.m_cmdLineForm);
            if (index >= 0) {
                try {
                    return schemagen.this.m_config.getResource((String)schemagen.this.m_cmdLineArgs.get(index + 1));
                }
                catch (IndexOutOfBoundsException e2) {
                    System.err.println("Value for parameter " + this.m_cmdLineForm + " not set! Aborting.");
                }
            }
            if (this.m_prop != null && schemagen.this.m_root.hasProperty(this.m_prop)) {
                return schemagen.this.m_root.getRequiredProperty(this.m_prop).getResource();
            }
            return null;
        }

        protected boolean hasResourceValue() {
            return this.getResource() != null;
        }
    }
}

