/*
 * Decompiled with CFR 0.152.
 */
package hospital.actors;

import hospital.actors.gui.NurseGUI;
import net.ponder2.ManagedObject;
import net.ponder2.Util;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2AuthorizationException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2ResolveException;
import net.ponder2.objects.P2Object;

public class NurseMO
implements ManagedObject {
    protected NurseGUI myGUI;
    protected String name;
    protected String myPath;
    protected int level;
    protected P2Object myP2Object;

    @Ponder2op(value="createname:level:path:")
    public NurseMO(P2Object myP2Object, String name, int level, String myPath) {
        this.myP2Object = myP2Object;
        this.name = name;
        this.level = level;
        this.myPath = myPath;
        this.myGUI = new NurseGUI();
        this.myGUI.start(this);
    }

    @Ponder2op(value="checkpatient:level:")
    public String checkRecord(String patientPath, int nurseLevel) {
        System.out.println("NurseMO.checkRecord(): going to call the patient on path: " + patientPath);
        P2Object patientOID = null;
        P2Object patientRecord = null;
        try {
            patientOID = Util.resolve(patientPath);
            patientRecord = patientOID.operation(this.myP2Object, "getrecord", P2Object.create(nurseLevel));
        }
        catch (Ponder2AuthorizationException e2) {
            System.out.println("NurseMO.checkRecord(): A Ponder2AuthorizationException OCCURED!!!!");
            System.out.println("NurseMO.checkRecord(): This nurse does not have the permission of access the patient record.");
            return " A Ponder2AuthorizationException OCCURED! This nurse does not have the permission of access the patient record.";
        }
        catch (Ponder2ResolveException e3) {
            System.out.println("NurseMO.checkRecord(): A Ponder2ResolveException OCCURED!!!!");
            return "A Ponder2ResolveException occured. Please make sure that the correct path to the patient is specified.";
        }
        catch (Ponder2Exception e4) {
            System.out.println("NurseMO.checkRecord(): A Ponder2Exception OCCURED!!!!");
            e4.printStackTrace();
            return "A Ponder2Exception OCCURED!!!!";
        }
        return "The patient record is " + patientRecord.toString();
    }

    public String getNursePath() {
        return this.myPath;
    }

    public int getNurseLevel() {
        return this.level;
    }
}

