/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.util.StringUtils;

public class OwlHandler {
    public static void getStatements(Model model) {
        StmtIterator iter = model.listStatements();
        while (iter.hasNext()) {
            Statement stmt = (Statement)iter.next();
            Resource subject = stmt.getSubject();
            System.out.println("Subject = " + subject.getURI());
            Property predicate = stmt.getPredicate();
            System.out.println("Predicate = " + predicate.getLocalName());
            RDFNode obj = stmt.getObject();
            System.out.println("Object = " + obj.toString());
        }
    }

    public static boolean containsDevice(Model model, String device) {
        String queryString = StringUtils.join("\n", new String[]{"PREFIX pf: <http://www.owl-ontologies.com/Ontology1196156810.owl#>", "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "ASK ", "{ ?subject rdf:type pf:Router . ", "}"});
        Query query2 = QueryFactory.create(queryString);
        QueryExecution qexec = QueryExecutionFactory.create(query2, model);
        boolean result = qexec.execAsk();
        qexec.close();
        return result;
    }

    public static String getDeviceName(Model model, String device) {
        if (!OwlHandler.containsDevice(model, device)) {
            System.out.println(String.valueOf(device) + "not found!!");
            return null;
        }
        String queryString = StringUtils.join("\n", new String[]{"PREFIX pf: <http://www.owl-ontologies.com/Ontology1196156810.owl#>", "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "SELECT ?subject ", "WHERE { ?subject rdf:type pf:" + device + " . ", "}"});
        Query query2 = QueryFactory.create(queryString);
        QueryExecution qexec = QueryExecutionFactory.create(query2, model);
        String device_name = "";
        try {
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                String name = OwlHandler.extractName(soln);
                device_name = String.valueOf(device_name) + name;
            }
        }
        finally {
            qexec.close();
        }
        return device_name;
    }

    public static int getDeviceCount(Model model, String device) {
        if (!OwlHandler.containsDevice(model, device)) {
            System.out.println(String.valueOf(device) + "not found!!");
            return 0;
        }
        String queryString = StringUtils.join("\n", new String[]{"PREFIX pf: <http://www.owl-ontologies.com/Ontology1196156810.owl#>", "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "SELECT ?subject ", "WHERE { ?subject rdf:type pf:" + device + " . ", "}"});
        Query query2 = QueryFactory.create(queryString);
        QueryExecution qexec = QueryExecutionFactory.create(query2, model);
        int counter = 0;
        try {
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                ++counter;
                results.nextSolution();
            }
        }
        finally {
            qexec.close();
        }
        return counter;
    }

    public static String getDeviceAt(Model model, String device, int index) {
        if (!OwlHandler.containsDevice(model, device)) {
            System.out.println(String.valueOf(device) + "not found!!");
            return null;
        }
        String queryString = StringUtils.join("\n", new String[]{"PREFIX pf: <http://www.owl-ontologies.com/Ontology1196156810.owl#>", "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "SELECT ?subject ", "WHERE { ?subject rdf:type pf:" + device + " . ", "}"});
        Query query2 = QueryFactory.create(queryString);
        QueryExecution qexec = QueryExecutionFactory.create(query2, model);
        int array_index = 0;
        String[] names = new String[OwlHandler.getDeviceCount(model, device)];
        try {
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                names[array_index] = OwlHandler.extractName(soln);
                ++array_index;
            }
        }
        finally {
            qexec.close();
        }
        return names[index];
    }

    public static String extractName(QuerySolution solution) {
        String workstring = solution.toString();
        int start = workstring.indexOf("#") + 1;
        int end = workstring.indexOf(">");
        String name = workstring.substring(start, end);
        return name;
    }
}

