/*
 * Decompiled with CFR 0.152.
 */
package com.twicom.qdparser;

import com.twicom.qdparser.Element;
import com.twicom.qdparser.TextElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TaggedElement
extends Element
implements Cloneable {
    String nameSpace;
    String tagName;
    String name;
    private int line;
    private int col;
    Map attributes;
    List elements;
    private String comment;

    public TaggedElement(String tag) {
        this(null, tag);
    }

    public TaggedElement(String nameSpace, String tagName) {
        this.nameSpace = nameSpace;
        this.tagName = tagName;
        this.name = nameSpace == null ? tagName : String.valueOf(nameSpace) + ":" + tagName;
        this.attributes = null;
        this.elements = null;
        this.comment = null;
        this.col = 0;
        this.line = 0;
    }

    public TaggedElement(String tag, Object[] children) {
        this(null, tag, children);
    }

    public TaggedElement(String nameSpace, String tag, Object[] children) {
        this(nameSpace, tag);
        int i = 0;
        while (i < children.length) {
            Object obj = children[i];
            if (obj instanceof Element) {
                this.add((Element)obj);
            } else {
                this.add(obj.toString());
            }
            ++i;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TaggedElement newElement = (TaggedElement)super.clone();
        if (this.attributes != null) {
            newElement.attributes = new HashMap(this.attributes);
        }
        if (this.elements != null) {
            newElement.elements = new ArrayList();
            Iterator it = this.elements.iterator();
            while (it.hasNext()) {
                newElement.elements.add(((Element)it.next()).clone());
            }
        }
        return newElement;
    }

    public String getName() {
        return this.name;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getTag() {
        return this.tagName;
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    public String getAttribute(String name, String defaultValue) {
        String result = this.getAttribute(name);
        return result == null ? defaultValue : result;
    }

    public void delAttribute(String string) {
        if (this.hasAttributes()) {
            this.attributes.remove(string);
        }
    }

    public boolean hasAttribute(String name) {
        return this.attributes == null ? false : this.attributes.containsKey(name);
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public Map getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes;
    }

    public int elements() {
        return this.elements == null ? 0 : this.elements.size();
    }

    public boolean hasElements() {
        return this.elements() != 0;
    }

    public void clearElements() {
        if (this.elements != null) {
            this.elements.clear();
        }
    }

    public void add(Element element) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        this.elements.add(element);
    }

    public void add(String string) {
        this.add(new TextElement(string));
    }

    public Element getChild(int i) {
        if (i < 0 || i >= this.elements()) {
            return null;
        }
        return (Element)this.elements.get(i);
    }

    public void replace(int index, Element newElement) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        if (index >= this.elements.size()) {
            this.elements.add(newElement);
        } else {
            this.elements.set(index, newElement);
        }
    }

    public Element remove(int index) {
        Element result = null;
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        if (index >= 0 && index < this.elements.size()) {
            result = (Element)this.elements.remove(index);
        }
        return result;
    }

    public boolean remove(Element element) {
        return this.elements.remove(element);
    }

    public TaggedElement find(String name) {
        int i = 0;
        while (i < this.elements.size()) {
            Element element = (Element)this.elements.get(i);
            if (element instanceof TaggedElement && ((TaggedElement)element).getName().equals(name)) {
                return (TaggedElement)element;
            }
            ++i;
        }
        return null;
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public List getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        return this.elements;
    }

    public Iterator iterator() {
        return this.getElements().iterator();
    }

    public void setLocation(int line, int col) {
        this.line = line;
        this.col = col;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        return this.toString(true);
    }

    protected StringBuffer toString(StringBuffer sb, boolean formatted, int level) {
        if (formatted && level > 0) {
            sb.append("\r\n");
            int i = level;
            while (i > 0) {
                sb.append("  ");
                --i;
            }
        }
        String nsTagName = this.nameSpace == null ? this.tagName : "nsqdp:" + this.tagName;
        sb.append("<" + nsTagName);
        if (this.nameSpace != null) {
            sb.append(" xmlns:nsqdp='" + this.nameSpace + "'");
        }
        if (this.hasAttributes()) {
            Iterator it = this.getAttributes().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                sb.append(String.valueOf(' ') + (String)entry.getKey() + '=');
                sb.append("'" + Element.quote((String)entry.getValue()) + "'");
            }
        }
        boolean formatThis = formatted;
        if (!this.hasElements()) {
            sb.append("/>");
        } else {
            sb.append(">");
            Iterator it = this.elements.iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                formatThis = element instanceof TextElement ? false : formatted;
                element.toString(sb, formatThis, level + 1);
                if (!(element instanceof TextElement) || !it.hasNext()) continue;
                sb.append("<!-- -->");
            }
            if (formatThis && level >= 0) {
                sb.append("\r\n");
                int i = level;
                while (i > 0) {
                    sb.append("  ");
                    --i;
                }
            }
            sb.append("</" + nsTagName + ">");
        }
        return sb;
    }
}

