/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.OneToManyMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;

public class TestOneToManyMap
extends TestCase {
    private String s0 = "s0";
    private String s1 = "s1";
    private String s2 = "s2";
    private String s3 = "s3";
    private String s4 = "s4";

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testConstruct0() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertNotNull(map0);
        TestOneToManyMap.assertTrue(map0.isEmpty());
        OneToManyMap map1 = new OneToManyMap(map0);
        TestOneToManyMap.assertNotNull(map1);
        TestOneToManyMap.assertTrue(map1.isEmpty());
    }

    public void testConstruct1() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue(map0.contains(this.s0, this.s1));
        OneToManyMap map1 = new OneToManyMap(map0);
        TestOneToManyMap.assertTrue(map0.contains(this.s0, this.s1));
        map0.put(this.s0, this.s2);
        TestOneToManyMap.assertTrue(map0.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse(map0.contains(this.s1, this.s2));
    }

    public void testClear() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue(map0.contains(this.s0, this.s1));
        TestOneToManyMap.assertFalse(map0.isEmpty());
        map0.clear();
        TestOneToManyMap.assertFalse(map0.contains(this.s0, this.s1));
        TestOneToManyMap.assertTrue(map0.isEmpty());
    }

    public void testContainsKey() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertFalse(map0.containsKey(this.s0));
        TestOneToManyMap.assertFalse(map0.containsKey(this.s1));
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue(map0.containsKey(this.s0));
        TestOneToManyMap.assertFalse(map0.containsKey(this.s1));
    }

    public void testContainsValue() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertFalse(map0.containsValue(this.s0));
        TestOneToManyMap.assertFalse(map0.containsValue(this.s1));
        TestOneToManyMap.assertFalse(map0.containsValue(this.s2));
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertFalse(map0.containsValue(this.s0));
        TestOneToManyMap.assertTrue(map0.containsValue(this.s1));
        TestOneToManyMap.assertFalse(map0.containsValue(this.s2));
        map0.put(this.s0, this.s2);
        TestOneToManyMap.assertFalse(map0.containsValue(this.s0));
        TestOneToManyMap.assertTrue(map0.containsValue(this.s1));
        TestOneToManyMap.assertTrue(map0.containsValue(this.s2));
    }

    public void testContains() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertFalse(map0.contains(this.s0, this.s1));
        TestOneToManyMap.assertFalse(map0.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse(map0.contains(this.s1, this.s2));
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue(map0.contains(this.s0, this.s1));
        TestOneToManyMap.assertFalse(map0.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse(map0.contains(this.s1, this.s2));
        map0.put(this.s0, this.s2);
        TestOneToManyMap.assertTrue(map0.contains(this.s0, this.s1));
        TestOneToManyMap.assertTrue(map0.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse(map0.contains(this.s1, this.s2));
    }

    public void testEntrySet() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s0, this.s2);
        map0.put(this.s3, this.s4);
        boolean s0s1 = false;
        boolean s0s2 = false;
        boolean s3s4 = false;
        Iterator i = map0.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e2 = (Map.Entry)i.next();
            if (e2.getKey().equals(this.s0) && e2.getValue().equals(this.s1)) {
                s0s1 = true;
                continue;
            }
            if (e2.getKey().equals(this.s0) && e2.getValue().equals(this.s2)) {
                s0s2 = true;
                continue;
            }
            if (e2.getKey().equals(this.s3) && e2.getValue().equals(this.s4)) {
                s3s4 = true;
                continue;
            }
            throw new IllegalArgumentException("unexpected: " + e2);
        }
        TestOneToManyMap.assertTrue(s0s1);
        TestOneToManyMap.assertTrue(s0s2);
        TestOneToManyMap.assertTrue(s3s4);
    }

    public void testEquals() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s0, this.s2);
        map0.put(this.s3, this.s4);
        OneToManyMap map1 = new OneToManyMap();
        map1.put(this.s3, this.s4);
        map1.put(this.s0, this.s1);
        map1.put(this.s0, this.s2);
        OneToManyMap map2 = new OneToManyMap();
        map2.put(this.s0, this.s2);
        map2.put(this.s3, this.s4);
        TestOneToManyMap.assertTrue(map0.equals(map1));
        TestOneToManyMap.assertTrue(map1.equals(map0));
        TestOneToManyMap.assertTrue(map0.hashCode() == map1.hashCode());
        TestOneToManyMap.assertFalse(map0.equals(map2));
        TestOneToManyMap.assertFalse(map2.equals(map0));
    }

    public void testGet() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertNull(map0.get(this.s0));
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertEquals((Object)this.s1, map0.get(this.s0));
        map0.put(this.s0, this.s2);
        TestOneToManyMap.assertTrue(map0.get(this.s0).equals(this.s1) || map0.get(this.s0).equals(this.s2));
    }

    public void testGetAll() {
        OneToManyMap map0 = new OneToManyMap();
        Iterator i = map0.getAll(this.s0);
        TestOneToManyMap.assertNotNull(i);
        TestOneToManyMap.assertFalse(i.hasNext());
        map0.put(this.s0, this.s1);
        i = map0.getAll(this.s0);
        TestOneToManyMap.assertNotNull(i);
        TestOneToManyMap.assertTrue(i.hasNext());
        TestOneToManyMap.assertEquals((Object)this.s1, i.next());
        TestOneToManyMap.assertFalse(i.hasNext());
        map0.put(this.s0, this.s2);
        i = map0.getAll(this.s0);
        TestOneToManyMap.assertNotNull(i);
        boolean founds1 = false;
        boolean founds2 = false;
        while (i.hasNext()) {
            Object x = i.next();
            if (x.equals(this.s1)) {
                founds1 = true;
                continue;
            }
            if (x.equals(this.s2)) {
                founds2 = true;
                continue;
            }
            throw new IllegalArgumentException(x.toString());
        }
        TestOneToManyMap.assertTrue(founds1);
        TestOneToManyMap.assertTrue(founds2);
    }

    public void testKeySet() {
        OneToManyMap map0 = new OneToManyMap();
        HashSet<String> keys = new HashSet<String>();
        TestOneToManyMap.assertEquals(keys, map0.keySet());
        map0.put(this.s0, this.s1);
        keys.add(this.s0);
        TestOneToManyMap.assertEquals(keys, map0.keySet());
        map0.put(this.s2, this.s1);
        keys.add(this.s2);
        TestOneToManyMap.assertEquals(keys, map0.keySet());
    }

    public void testPutAll0() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s0, this.s2);
        map0.put(this.s3, this.s4);
        OneToManyMap map1 = new OneToManyMap();
        map1.put(this.s0, this.s2);
        map1.put(this.s3, this.s4);
        map1.put(this.s0, this.s1);
        OneToManyMap map2 = new OneToManyMap();
        map2.putAll((Map)map1);
        TestOneToManyMap.assertEquals(map0, map2);
    }

    public void testPutAll1() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s3, this.s4);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put(this.s3, this.s4);
        map1.put(this.s0, this.s1);
        OneToManyMap map2 = new OneToManyMap();
        map2.putAll(map1);
        TestOneToManyMap.assertEquals(map0, map2);
    }

    public void testRemove0() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s3, this.s4);
        map0.remove(this.s0);
        map0.remove(this.s3);
        TestOneToManyMap.assertTrue(map0.isEmpty());
    }

    public void testRemove1() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s0, this.s2);
        map0.put(this.s3, this.s4);
        map0.remove(this.s0, this.s2);
        map0.remove(this.s3, this.s4);
        TestOneToManyMap.assertFalse(map0.isEmpty());
        map0.remove(this.s0, this.s1);
        TestOneToManyMap.assertTrue(map0.isEmpty());
    }

    public void testSize() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertEquals(0, map0.size());
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertEquals(1, map0.size());
        map0.put(this.s0, this.s2);
        TestOneToManyMap.assertEquals(2, map0.size());
        map0.put(this.s3, this.s4);
        TestOneToManyMap.assertEquals(3, map0.size());
        map0.remove(this.s0, this.s2);
        TestOneToManyMap.assertEquals(2, map0.size());
        map0.remove(this.s3, this.s4);
        TestOneToManyMap.assertEquals(1, map0.size());
        map0.remove(this.s0, this.s1);
        TestOneToManyMap.assertEquals(0, map0.size());
    }

    public void testValues() {
        OneToManyMap map0 = new OneToManyMap();
        HashSet<String> vals = new HashSet<String>();
        TestOneToManyMap.assertEquals(vals, map0.values());
        map0.put(this.s0, this.s1);
        vals.add(this.s1);
        TestOneToManyMap.assertEquals(vals, map0.values());
        map0.put(this.s2, this.s1);
        TestOneToManyMap.assertEquals(vals, map0.values());
        map0.put(this.s2, this.s3);
        vals.add(this.s3);
        TestOneToManyMap.assertEquals(vals, map0.values());
    }
}

