/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestSuite;

public class TestIteratorCollection
extends GraphTestBase {
    public TestIteratorCollection(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestIteratorCollection.class);
    }

    public void testEmptyToEmptySet() {
        TestIteratorCollection.assertEquals(CollectionFactory.createHashedSet(), IteratorCollection.iteratorToSet(NullIterator.instance));
    }

    public void testSingletonToSingleSet() {
        TestIteratorCollection.assertEquals(this.oneSet("single"), TestIteratorCollection.iteratorToSet(new SingletonIterator("single")));
    }

    public void testLotsToSet() {
        Object[] elements = new Object[]{"now", "is", "the", "time"};
        Iterator<Object> it = Arrays.asList(elements).iterator();
        TestIteratorCollection.assertEquals(this.setLots(elements), IteratorCollection.iteratorToSet(it));
    }

    public void testCloseForSet() {
        this.testCloseForSet(new Object[0]);
        this.testCloseForSet(new Object[]{"one"});
        this.testCloseForSet(new Object[]{"to", "free", "for"});
        this.testCloseForSet(new Object[]{"another", "one", "plus", Boolean.FALSE});
        this.testCloseForSet(new Object[]{"the", "king", "is", "in", "his", "counting", "house"});
    }

    protected void testCloseForSet(Object[] objects) {
        final boolean[] closed = new boolean[]{false};
        WrappedIterator iterator = new WrappedIterator(Arrays.asList(objects).iterator()){

            public void close() {
                super.close();
                closed[0] = true;
            }
        };
        TestIteratorCollection.iteratorToSet(iterator);
        TestIteratorCollection.assertTrue(closed[0]);
    }

    public void testEmptyToEmptyList() {
        TestIteratorCollection.assertEquals(new ArrayList(), IteratorCollection.iteratorToList(NullIterator.instance));
    }

    public void testSingletonToSingletonList() {
        TestIteratorCollection.assertEquals(this.oneList("just one"), IteratorCollection.iteratorToList(new SingletonIterator("just one")));
    }

    public void testLotsToList() {
        List<Object> list = Arrays.asList("to", "be", "or", "not", "to", "be");
        TestIteratorCollection.assertEquals(list, IteratorCollection.iteratorToList(list.iterator()));
    }

    public void testCloseForList() {
        this.testCloseForList(new Object[0]);
        this.testCloseForList(new Object[]{"one"});
        this.testCloseForList(new Object[]{"to", "free", "for"});
        this.testCloseForList(new Object[]{"another", "one", "plus", Boolean.FALSE});
        this.testCloseForList(new Object[]{"the", "king", "is", "in", "his", "counting", "house"});
    }

    protected void testCloseForList(Object[] objects) {
        final boolean[] closed = new boolean[]{false};
        WrappedIterator iterator = new WrappedIterator(Arrays.asList(objects).iterator()){

            public void close() {
                super.close();
                closed[0] = true;
            }
        };
        TestIteratorCollection.iteratorToList(iterator);
        TestIteratorCollection.assertTrue(closed[0]);
    }

    protected Set oneSet(Object x) {
        HashSet<Object> result = new HashSet<Object>();
        result.add(x);
        return result;
    }

    protected Set setLots(Object[] elements) {
        HashSet<Object> result = new HashSet<Object>();
        for (int i = 0; i < elements.length; ++i) {
            result.add(elements[i]);
        }
        return result;
    }

    protected List oneList(Object x) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(x);
        return result;
    }
}

