/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprNotComparableException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueDecimal;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueDouble;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueFloat;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueInteger;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.util.Utils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestXSDFuncOp
extends TestCase {
    private static final double accuracyExact_D = 0.0;
    private static final double accuracyExact_F = 0.0;
    private static final double accuracyClose_D = 1.0E-6;
    private static final double accuracyClose_F = (double)1.0E-6f;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestXSDFuncOp.class);
        ts.setName(Utils.classShortName(TestXSDFuncOp.class));
        return ts;
    }

    public void testAddIntegerInteger() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeInteger(7L);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not an integer: " + r, r.isInteger());
        TestXSDFuncOp.assertTrue("Not a NodeValueInteger: " + r, r instanceof NodeValueInteger);
        TestXSDFuncOp.assertEquals("Wrong result", 12L, r.getInteger().longValue());
    }

    public void testAddDecimalDecimal() {
        NodeValue nv1 = NodeValue.makeDecimal(4.3);
        NodeValue nv2 = NodeValue.makeDecimal(3.7);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertEquals("Wrong result", 8.0, r.getDecimal().doubleValue(), 0.0);
    }

    public void testAddFloatFloat() {
        NodeValue nv1 = NodeValue.makeFloat(7.5f);
        NodeValue nv2 = NodeValue.makeFloat(2.5f);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a float: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueFloat: " + r, r instanceof NodeValueFloat);
        TestXSDFuncOp.assertEquals("Wrong result", 10.0, (double)r.getFloat(), 0.0);
        TestXSDFuncOp.assertEquals("Wrong result (as doubles)", 10.0, r.getDouble(), 0.0);
    }

    public void testAddDoubleDouble() {
        NodeValue nv1 = NodeValue.makeDouble(7.5);
        NodeValue nv2 = NodeValue.makeDouble(2.5);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 10.0, r.getDouble(), 0.0);
    }

    public void testAddIntegerDecimal() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeDecimal(7L);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertEquals("Wrong result", 12L, r.getDecimal().longValue());
    }

    public void testAddDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal(7L);
        NodeValue nv2 = NodeValue.makeInteger(5L);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertEquals("Wrong result", 12L, r.getDecimal().longValue());
    }

    public void testAddIntegerFloat() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeFloat(7.0f);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a float: " + r, r.isFloat());
        TestXSDFuncOp.assertTrue("Not a NodeValueFloat: " + r, r instanceof NodeValueFloat);
        TestXSDFuncOp.assertEquals("Wrong result", 12.0, r.getDouble(), 0.0);
    }

    public void testAddFloatInteger() {
        NodeValue nv1 = NodeValue.makeFloat(7.0f);
        NodeValue nv2 = NodeValue.makeInteger(5L);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a float: " + r, r.isFloat());
        TestXSDFuncOp.assertTrue("Not a NodeValueFloat: " + r, r instanceof NodeValueFloat);
        TestXSDFuncOp.assertEquals("Wrong result", 12.0, r.getDouble(), 0.0);
    }

    public void testAddIntegerDouble() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeDouble(7.0);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 12.0, r.getDouble(), 0.0);
    }

    public void testAddDoubleInteger() {
        NodeValue nv1 = NodeValue.makeDouble(7.0);
        NodeValue nv2 = NodeValue.makeInteger(5L);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 12.0, r.getDouble(), 0.0);
    }

    public void testAddDecimalFloat() {
        NodeValue nv1 = NodeValue.makeDecimal(3.5);
        NodeValue nv2 = NodeValue.makeFloat(4.5f);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a Float: " + r, r.isFloat());
        TestXSDFuncOp.assertTrue("Not a NodeValueFloat: " + r, r instanceof NodeValueFloat);
        TestXSDFuncOp.assertEquals("Wrong result", 8.0, (double)r.getFloat(), 0.0);
    }

    public void testAddFloatDecimal() {
        NodeValue nv1 = NodeValue.makeFloat(4.5f);
        NodeValue nv2 = NodeValue.makeDecimal(3.5);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a Float: " + r, r.isFloat());
        TestXSDFuncOp.assertTrue("Not a NodeValueFloat: " + r, r instanceof NodeValueFloat);
        TestXSDFuncOp.assertEquals("Wrong result", 8.0, (double)r.getFloat(), 0.0);
    }

    public void testAddDecimalDouble() {
        NodeValue nv1 = NodeValue.makeDecimal(3.5);
        NodeValue nv2 = NodeValue.makeDouble(4.5);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 8.0, r.getDouble(), 0.0);
    }

    public void testAddDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble(4.5);
        NodeValue nv2 = NodeValue.makeDecimal(3.5);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 8.0, r.getDouble(), 0.0);
    }

    public void testAddDoubleFloat() {
        NodeValue nv1 = NodeValue.makeDouble(4.5);
        NodeValue nv2 = NodeValue.makeFloat(3.5f);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 8.0, r.getDouble(), 0.0);
    }

    public void testAddFloatDouble() {
        NodeValue nv1 = NodeValue.makeFloat(4.5f);
        NodeValue nv2 = NodeValue.makeDouble(3.5);
        NodeValue r = XSDFuncOp.add(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 8.0, r.getDouble(), 0.0);
    }

    public void testDivideIntegerInteger() {
        NodeValue nv1 = NodeValue.makeInteger(25L);
        NodeValue nv2 = NodeValue.makeInteger(2L);
        NodeValue r = XSDFuncOp.divide(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertEquals("Wrong result", 12.5, r.getDecimal().doubleValue(), 0.0);
    }

    public void testDivideByZero1() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(0L);
        try {
            NodeValue r = XSDFuncOp.divide(nv1, nv2);
            TestXSDFuncOp.fail("No expection from .divide");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testDivideByZero2() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeDouble(0.0);
        NodeValue r = XSDFuncOp.divide(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a +INF: " + r, r.getDouble() == Double.POSITIVE_INFINITY);
    }

    public void testDivideByZero4() {
        NodeValue nv1 = NodeValue.makeInteger(-1L);
        NodeValue nv2 = NodeValue.makeDouble(0.0);
        NodeValue r = XSDFuncOp.divide(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a -INF: " + r, r.getDouble() == Double.NEGATIVE_INFINITY);
    }

    public void testSubtractDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble(4.5);
        NodeValue nv2 = NodeValue.makeDecimal(3.5);
        NodeValue r = XSDFuncOp.subtract(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 1.0, r.getDouble(), 0.0);
    }

    public void testSubtractDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal(3.5);
        NodeValue nv2 = NodeValue.makeInteger(2L);
        NodeValue r = XSDFuncOp.subtract(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertTrue("Wrong result", NodeValue.sameAs(NodeValue.makeDecimal(1.5), r));
    }

    public void testMultiplyDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble(4.5);
        NodeValue nv2 = NodeValue.makeDecimal(3.5);
        NodeValue r = XSDFuncOp.multiply(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 15.75, r.getDouble(), 0.0);
    }

    public void testMultiplyDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal(3.5);
        NodeValue nv2 = NodeValue.makeInteger(2L);
        NodeValue r = XSDFuncOp.multiply(nv1, nv2);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertEquals("Wrong result", 7L, r.getDecimal().longValue());
    }

    public void testCompare1() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeInteger(7L);
        TestXSDFuncOp.assertEquals("Does not compare " + nv5 + " & " + nv7, -1, NodeValue.compare(nv5, nv7));
        NodeValue nv5b = NodeValue.makeInteger(5L);
        TestXSDFuncOp.assertEquals("Does not compare " + nv5 + " & " + nv5b, 0, NodeValue.compare(nv5, nv5b));
    }

    public void testCompare2() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeNodeInteger(7L);
        TestXSDFuncOp.assertEquals("Does not compare " + nv5 + " & " + nv7, -1, NodeValue.compare(nv5, nv7));
        NodeValue nv5b = NodeValue.makeNodeInteger(5L);
        TestXSDFuncOp.assertEquals("Does not compare " + nv5 + " & " + nv5b, 0, NodeValue.compare(nv5, nv5b));
    }

    public void testCompare3() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeDouble(7.0);
        TestXSDFuncOp.assertEquals("Does not compare " + nv5 + " & " + nv7, -1, NodeValue.compare(nv5, nv7));
    }

    public void testCompare4() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeFloat(7.0f);
        TestXSDFuncOp.assertEquals("Does not compare " + nv5 + " & " + nv7, -1, NodeValue.compare(nv5, nv7));
    }

    public void testCompare5() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeDecimal(7L);
        TestXSDFuncOp.assertEquals("Does not compare " + nv5 + " & " + nv7, -1, NodeValue.compare(nv5, nv7));
    }

    public void testCompare10() {
        NodeValue nv1 = NodeValue.makeDateTime("2005-10-14T13:09:43Z");
        NodeValue nv2 = NodeValue.makeNodeDateTime("2005-10-14T14:09:43Z");
        TestXSDFuncOp.assertEquals("Does not compare " + nv1 + " & " + nv2, -1, NodeValue.compare(nv1, nv2));
    }

    public void testCompare11() {
        NodeValue nv1 = NodeValue.makeDateTime("2005-10-14T13:09:43-08:00");
        NodeValue nv2 = NodeValue.makeNodeDateTime("2005-10-14T13:09:43+01:00");
        TestXSDFuncOp.assertEquals("Does not compare " + nv1 + " & " + nv2, 1, NodeValue.compare(nv1, nv2));
    }

    public void testCompare12() {
        if (!ARQ.isTrue(ARQ.strictSPARQL)) {
            NodeValue nv1 = NodeValue.makeDate("2006-07-21-08:00");
            NodeValue nv2 = NodeValue.makeNodeDate("2006-07-21+01:00");
            TestXSDFuncOp.assertEquals("Does not compare " + nv1 + " & " + nv2, 1, NodeValue.compare(nv1, nv2));
        }
    }

    public void testCompare15() {
        NodeValue nv1 = NodeValue.makeDate("2005-10-14Z");
        NodeValue nv2 = NodeValue.makeNodeDateTime("2005-10-14T14:09:43Z");
        try {
            NodeValue.compare(nv1, nv2);
            TestXSDFuncOp.assertFalse("Compared the uncomparable: " + nv1 + " & " + nv2, true);
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
    }

    public void testCompare16() {
        NodeValue nv1 = NodeValue.makeDateTime("2007-08-31T16:20:03");
        NodeValue nv2 = NodeValue.makeDateTime("2007-08-31T16:20:03Z");
        try {
            NodeValue.compare(nv1, nv2);
            TestXSDFuncOp.assertFalse("Compared the uncomparable: " + nv1 + " & " + nv2, true);
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
    }

    public void testCompare17() {
        NodeValue nv1 = NodeValue.makeDate("2007-08-31");
        NodeValue nv2 = NodeValue.makeDate("2007-08-31Z");
        try {
            NodeValue.compare(nv1, nv2);
            TestXSDFuncOp.assertFalse("Compared the uncomparable: " + nv1 + " & " + nv2, true);
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
    }

    public void testCompare18() {
        NodeValue nv1 = NodeValue.makeDateTime("2007-08-31T16:20:03");
        NodeValue nv2 = NodeValue.makeDateTime("2007-08-31T01:20:03Z");
        TestXSDFuncOp.assertEquals(1, NodeValue.compare(nv1, nv2));
    }

    public void testCompare20() {
        NodeValue nv1 = NodeValue.makeString("abcd");
        NodeValue nv2 = NodeValue.makeNodeString("abc");
        TestXSDFuncOp.assertEquals("Does not compare " + nv1 + " & " + nv2, 1, NodeValue.compare(nv1, nv2));
    }

    public void testCompare21() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeString("5");
        try {
            NodeValue.compare(nv5, nv7);
            TestXSDFuncOp.fail("Should not compare (but did) " + nv5 + " & " + nv7);
        }
        catch (ExprEvalException ex) {
            // empty catch block
        }
        int x = NodeValue.compareAlways(nv5, nv7);
        TestXSDFuncOp.assertEquals("Does not compare " + nv5 + " & " + nv7, 1, NodeValue.compareAlways(nv5, nv7));
    }

    public void testCompare22() {
        NodeValue nv1 = NodeValue.makeNodeString("aaa");
        NodeValue nv2 = NodeValue.makeString("aaabbb");
        int x = NodeValue.compare(nv1, nv2);
        TestXSDFuncOp.assertEquals("Not CMP_LESS", x, -1);
        TestXSDFuncOp.assertTrue("It's CMP_GREATER", x != 1);
        TestXSDFuncOp.assertTrue("It's CMP_EQUAL", x != 0);
    }

    public void testCompare23() {
        NodeValue nv1 = NodeValue.makeNode(Node.createAnon());
        NodeValue nv2 = NodeValue.makeString("5");
        try {
            NodeValue.compare(nv1, nv2);
            TestXSDFuncOp.fail("Should not compare (but did) " + nv1 + " & " + nv2);
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testSameUnknown_1() {
        NodeValue nv1 = NodeValue.makeNode(Node.createURI("test:abc"));
        NodeValue nv2 = NodeValue.makeNode(Node.createURI("test:abc"));
        TestXSDFuncOp.assertTrue(NodeValue.sameAs(nv1, nv2));
        TestXSDFuncOp.assertFalse(NodeValue.notSameAs(nv1, nv2));
        try {
            NodeValue.compare(nv1, nv2);
            TestXSDFuncOp.fail("Should not compare (but did) " + nv1 + " & " + nv2);
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testSameUnknown_2() {
        NodeValue nv1 = NodeValue.makeNode(Node.createAnon());
        NodeValue nv2 = NodeValue.makeNode(Node.createURI("test:abc"));
        TestXSDFuncOp.assertFalse(NodeValue.sameAs(nv1, nv2));
        TestXSDFuncOp.assertTrue(NodeValue.notSameAs(nv1, nv2));
        try {
            NodeValue.compare(nv1, nv2);
            TestXSDFuncOp.fail("Should not compare (but did) " + nv1 + " & " + nv2);
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testSameDateTime_1() {
        NodeValue nv1 = NodeValue.makeDateTime("2007-09-04T09:22:03");
        NodeValue nv2 = NodeValue.makeDateTime("2007-09-04T09:22:03");
        TestXSDFuncOp.assertTrue(NodeValue.sameAs(nv1, nv2));
        TestXSDFuncOp.assertFalse(NodeValue.notSameAs(nv1, nv2));
    }

    public void testSameDateTime_2() {
        NodeValue nv1 = NodeValue.makeDateTime("2007-09-04T09:22:03");
        NodeValue nv2 = NodeValue.makeDateTime("2007-09-04T19:00:00");
        TestXSDFuncOp.assertFalse(NodeValue.sameAs(nv1, nv2));
        TestXSDFuncOp.assertTrue(NodeValue.notSameAs(nv1, nv2));
    }

    public void testSameDateTime_3() {
        NodeValue nv1 = NodeValue.makeDateTime("2007-09-04T10:22:03+01:00");
        NodeValue nv2 = NodeValue.makeDateTime("2007-09-04T09:22:03Z");
        TestXSDFuncOp.assertTrue(NodeValue.sameAs(nv1, nv2));
        TestXSDFuncOp.assertFalse(NodeValue.notSameAs(nv1, nv2));
    }

    public void testSameDateTime_4() {
        NodeValue nv1 = NodeValue.makeDateTime("2007-09-04T10:22:03+01:00");
        NodeValue nv2 = NodeValue.makeDateTime("2007-09-04T10:22:03Z");
        TestXSDFuncOp.assertFalse(NodeValue.sameAs(nv1, nv2));
        TestXSDFuncOp.assertTrue(NodeValue.notSameAs(nv1, nv2));
    }

    public void testSameDateTime_5() {
        NodeValue nv1 = NodeValue.makeDateTime("2007-09-04T10:22:03+01:00");
        NodeValue nv2 = NodeValue.makeDateTime("2007-09-04T09:22:03");
        try {
            NodeValue.sameAs(nv1, nv2);
            TestXSDFuncOp.fail("Should not sameValueAs (but did) " + nv1 + " & " + nv2);
        }
        catch (ExprEvalException ex) {
            // empty catch block
        }
        try {
            NodeValue.notSameAs(nv1, nv2);
            TestXSDFuncOp.fail("Should not notSameValueAs (but did) " + nv1 + " & " + nv2);
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testSameDate_1() {
        NodeValue nv1 = NodeValue.makeDate("2007-09-04");
        NodeValue nv2 = NodeValue.makeDate("2007-09-04");
        TestXSDFuncOp.assertTrue(NodeValue.sameAs(nv1, nv2));
        TestXSDFuncOp.assertFalse(NodeValue.notSameAs(nv1, nv2));
    }

    public void testSameDate_2() {
        NodeValue nv1 = NodeValue.makeDate("2007-09-04Z");
        NodeValue nv2 = NodeValue.makeDate("2007-09-04+00:00");
        TestXSDFuncOp.assertTrue(NodeValue.sameAs(nv1, nv2));
        TestXSDFuncOp.assertFalse(NodeValue.notSameAs(nv1, nv2));
    }

    public void testSameDate_3() {
        NodeValue nv1 = NodeValue.makeDate("2007-09-04Z");
        NodeValue nv2 = NodeValue.makeDate("2007-09-04");
        try {
            NodeValue.sameAs(nv1, nv2);
            TestXSDFuncOp.fail("Should not sameValueAs (but did) " + nv1 + " & " + nv2);
        }
        catch (ExprEvalException ex) {
            // empty catch block
        }
        try {
            NodeValue.notSameAs(nv1, nv2);
            TestXSDFuncOp.fail("Should not notSameValueAs (but did) " + nv1 + " & " + nv2);
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testCompareGeneral1() {
        NodeValue nv1 = NodeValue.makeNode(Node.createAnon());
        NodeValue nv2 = NodeValue.makeString("5");
        int x = NodeValue.compareAlways(nv1, nv2);
        TestXSDFuncOp.assertEquals("Does not compare " + nv1 + " & " + nv2, -1, NodeValue.compareAlways(nv1, nv2));
    }

    public void testCompareGeneral2() {
        NodeValue nv1 = NodeValue.makeNode(Node.createAnon());
        NodeValue nv2 = NodeValue.makeNode(Node.createURI("test:abc"));
        int x = NodeValue.compareAlways(nv1, nv2);
        TestXSDFuncOp.assertEquals("Does not compare " + nv1 + " & " + nv2, -1, NodeValue.compareAlways(nv1, nv2));
    }

    public void testCompareGeneral3() {
        NodeValue nv1 = NodeValue.makeNode(Node.createLiteral("test:abc"));
        NodeValue nv2 = NodeValue.makeNode(Node.createURI("test:abc"));
        int x = NodeValue.compareAlways(nv1, nv2);
        TestXSDFuncOp.assertEquals("Does not compare " + nv1 + " & " + nv2, 1, NodeValue.compareAlways(nv1, nv2));
    }

    public void testCompareGeneral4() {
        NodeValue nv1 = NodeValue.makeNode(Node.createURI("test:abc"));
        NodeValue nv2 = NodeValue.makeNode(Node.createURI("test:xyz"));
        int x = NodeValue.compareAlways(nv1, nv2);
        TestXSDFuncOp.assertEquals("Does not compare " + nv1 + " & " + nv2, -1, NodeValue.compareAlways(nv1, nv2));
    }

    public void testAbs1() {
        NodeValue nv = NodeValue.makeInteger(2L);
        NodeValue r = XSDFuncOp.abs(nv);
        TestXSDFuncOp.assertTrue("Not an integer: " + r, r.isInteger());
        TestXSDFuncOp.assertTrue("Not a NodeValueInteger: " + r, r instanceof NodeValueInteger);
        TestXSDFuncOp.assertEquals("Wrong result", 2L, r.getInteger().longValue());
    }

    public void testAbs2() {
        NodeValue nv = NodeValue.makeInteger(-2L);
        NodeValue r = XSDFuncOp.abs(nv);
        TestXSDFuncOp.assertTrue("Not an integer: " + r, r.isInteger());
        TestXSDFuncOp.assertTrue("Not a NodeValueInteger: " + r, r instanceof NodeValueInteger);
        TestXSDFuncOp.assertEquals("Wrong result", 2L, r.getInteger().longValue());
    }

    public void testAbs3() {
        NodeValue nv = NodeValue.makeDecimal(2L);
        NodeValue r = XSDFuncOp.abs(nv);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertEquals("Wrong result", 2.0, r.getDecimal().doubleValue(), 0.0);
    }

    public void testAbs4() {
        NodeValue nv = NodeValue.makeDecimal(-2L);
        NodeValue r = XSDFuncOp.abs(nv);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertEquals("Wrong result", 2.0, r.getDecimal().doubleValue(), 0.0);
    }

    public void testAbs5() {
        NodeValue nv = NodeValue.makeFloat(2.0f);
        NodeValue r = XSDFuncOp.abs(nv);
        TestXSDFuncOp.assertTrue("Not an float: " + r, r.isFloat());
        TestXSDFuncOp.assertTrue("Not a NodeValueFloat: " + r, r instanceof NodeValueFloat);
        TestXSDFuncOp.assertEquals("Wrong result", 2.0, (double)r.getFloat(), 0.0);
    }

    public void testAbs6() {
        NodeValue nv = NodeValue.makeFloat(-2.0f);
        NodeValue r = XSDFuncOp.abs(nv);
        TestXSDFuncOp.assertTrue("Not an float: " + r, r.isFloat());
        TestXSDFuncOp.assertTrue("Not a NodeValueFloat: " + r, r instanceof NodeValueFloat);
        TestXSDFuncOp.assertEquals("Wrong result", 2.0, (double)r.getFloat(), 0.0);
    }

    public void testAbs7() {
        NodeValue nv = NodeValue.makeDouble(2.0);
        NodeValue r = XSDFuncOp.abs(nv);
        TestXSDFuncOp.assertTrue("Not an double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 2.0, r.getDouble(), 0.0);
    }

    public void testAbs8() {
        NodeValue nv = NodeValue.makeDouble(-2.0);
        NodeValue r = XSDFuncOp.abs(nv);
        TestXSDFuncOp.assertTrue("Not an double: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 2.0, r.getDouble(), 0.0);
    }

    public void testCeiling1() {
        NodeValue nv = NodeValue.makeDecimal(2.6);
        NodeValue r = XSDFuncOp.ceiling(nv);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertEquals("Wrong result", 3L, r.getDecimal().longValue());
    }

    public void testCeiling2() {
        NodeValue nv = NodeValue.makeDecimal(-3.6);
        NodeValue r = XSDFuncOp.ceiling(nv);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertEquals("Wrong result", -3L, r.getDecimal().longValue());
    }

    public void testCeiling3() {
        NodeValue nv = NodeValue.makeDouble(2.6);
        NodeValue r = XSDFuncOp.ceiling(nv);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 3.0, r.getDouble(), 0.0);
    }

    public void testCeiling4() {
        NodeValue nv = NodeValue.makeDouble(-3.6);
        NodeValue r = XSDFuncOp.ceiling(nv);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", -3.0, r.getDouble(), 0.0);
    }

    public void testCeiling5() {
        NodeValue nv = NodeValue.makeInteger(3L);
        NodeValue r = XSDFuncOp.ceiling(nv);
        TestXSDFuncOp.assertTrue("Not an integer: " + r, r.isInteger());
        TestXSDFuncOp.assertTrue("Not a NodeValueInteger: " + r, r instanceof NodeValueInteger);
        TestXSDFuncOp.assertEquals("Wrong result", 3L, r.getInteger().longValue());
    }

    public void testFloor1() {
        NodeValue nv = NodeValue.makeDecimal(2.6);
        NodeValue r = XSDFuncOp.floor(nv);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertEquals("Wrong result", 2L, r.getDecimal().longValue());
    }

    public void testFloor2() {
        NodeValue nv = NodeValue.makeDecimal(-3.6);
        NodeValue r = XSDFuncOp.floor(nv);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDecimal());
        TestXSDFuncOp.assertTrue("Not a NodeValueDecimal: " + r, r instanceof NodeValueDecimal);
        TestXSDFuncOp.assertEquals("Wrong result", -4L, r.getDecimal().longValue());
    }

    public void testFloor3() {
        NodeValue nv = NodeValue.makeDouble(2.6);
        NodeValue r = XSDFuncOp.floor(nv);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", 2.0, r.getDouble(), 0.0);
    }

    public void testFloor4() {
        NodeValue nv = NodeValue.makeDouble(-3.6);
        NodeValue r = XSDFuncOp.floor(nv);
        TestXSDFuncOp.assertTrue("Not a decimal: " + r, r.isDouble());
        TestXSDFuncOp.assertTrue("Not a NodeValueDouble: " + r, r instanceof NodeValueDouble);
        TestXSDFuncOp.assertEquals("Wrong result", -4.0, r.getDouble(), 0.0);
    }

    public void testFloor5() {
        NodeValue nv = NodeValue.makeInteger(3L);
        NodeValue r = XSDFuncOp.floor(nv);
        TestXSDFuncOp.assertTrue("Not an integer: " + r, r.isInteger());
        TestXSDFuncOp.assertTrue("Not a NodeValueInteger: " + r, r instanceof NodeValueInteger);
        TestXSDFuncOp.assertEquals("Wrong result", 3L, r.getInteger().longValue());
    }
}

