/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFVisitor;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestRDFNodes
extends ModelTestBase {
    public TestRDFNodes(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRDFNodes.class);
    }

    public void testRDFVisitor() {
        final ArrayList history = new ArrayList();
        Model m = ModelFactory.createDefaultModel();
        final Resource S = m.createResource();
        final Property P = m.createProperty("eh:PP");
        final Literal O = m.createLiteral("LL");
        RDFVisitor rv = new RDFVisitor(){

            public Object visitBlank(Resource R, AnonId id) {
                history.add("blank");
                Assert.assertTrue("must visit correct node", R == S);
                Assert.assertEquals("must have correct field", R.getId(), id);
                return "blank result";
            }

            public Object visitURI(Resource R, String uri) {
                history.add("uri");
                Assert.assertTrue("must visit correct node", R == P);
                Assert.assertEquals("must have correct field", R.getURI(), uri);
                return "uri result";
            }

            public Object visitLiteral(Literal L) {
                history.add("literal");
                Assert.assertTrue("must visit correct node", L == O);
                return "literal result";
            }
        };
        TestRDFNodes.assertEquals((Object)"blank result", S.visitWith(rv));
        TestRDFNodes.assertEquals((Object)"uri result", P.visitWith(rv));
        TestRDFNodes.assertEquals((Object)"literal result", O.visitWith(rv));
        TestRDFNodes.assertEquals(TestRDFNodes.listOfStrings("blank uri literal"), history);
    }

    public void testRemoveAllRemoves() {
        String ps = "x P a; x P b";
        String rest = "x Q c; y P a; y Q b";
        Model m = TestRDFNodes.modelWithStatements(ps + "; " + rest);
        Resource r = TestRDFNodes.resource(m, "x");
        Resource r2 = r.removeAll(TestRDFNodes.property(m, "P"));
        TestRDFNodes.assertSame("removeAll should deliver its receiver", r, r2);
        TestRDFNodes.assertIsoModels("x's P-values should go", TestRDFNodes.modelWithStatements(rest), m);
    }

    public void testRemoveAllBoring() {
        Model m1 = TestRDFNodes.modelWithStatements("x P a; y Q b");
        Model m2 = TestRDFNodes.modelWithStatements("x P a; y Q b");
        TestRDFNodes.resource(m2, "x").removeAll(TestRDFNodes.property(m2, "Z"));
        TestRDFNodes.assertIsoModels("m2 should be unchanged", m1, m2);
    }

    public void testInModel() {
        Model m1 = TestRDFNodes.modelWithStatements("");
        Model m2 = TestRDFNodes.modelWithStatements("");
        Resource r1 = TestRDFNodes.resource(m1, "r1");
        Resource r2 = TestRDFNodes.resource(m1, "_r2");
        TestRDFNodes.assertTrue(r1.getModel() == m1);
        TestRDFNodes.assertTrue(r2.getModel() == m1);
        TestRDFNodes.assertFalse(r1.isAnon());
        TestRDFNodes.assertTrue(r2.isAnon());
        TestRDFNodes.assertTrue(((Resource)r1.inModel(m2)).getModel() == m2);
        TestRDFNodes.assertTrue(((Resource)r2.inModel(m2)).getModel() == m2);
        TestRDFNodes.assertEquals(r1, r1.inModel(m2));
        TestRDFNodes.assertEquals(r2, r2.inModel(m2));
    }

    public void testIsAnon() {
        Model m = TestRDFNodes.modelWithStatements("");
        TestRDFNodes.assertEquals(false, m.createResource("eh:/foo").isAnon());
        TestRDFNodes.assertEquals(true, m.createResource().isAnon());
        TestRDFNodes.assertEquals(false, m.createLiteral(17L).isAnon());
        TestRDFNodes.assertEquals(false, m.createTypedLiteral("hello").isAnon());
    }

    public void testIsLiteral() {
        Model m = TestRDFNodes.modelWithStatements("");
        TestRDFNodes.assertEquals(false, m.createResource("eh:/foo").isLiteral());
        TestRDFNodes.assertEquals(false, m.createResource().isLiteral());
        TestRDFNodes.assertEquals(true, m.createLiteral(17L).isLiteral());
        TestRDFNodes.assertEquals(true, m.createTypedLiteral("hello").isLiteral());
    }

    public void testIsURIResource() {
        Model m = TestRDFNodes.modelWithStatements("");
        TestRDFNodes.assertEquals(true, m.createResource("eh:/foo").isURIResource());
        TestRDFNodes.assertEquals(false, m.createResource().isURIResource());
        TestRDFNodes.assertEquals(false, m.createLiteral(17L).isURIResource());
        TestRDFNodes.assertEquals(false, m.createTypedLiteral("hello").isURIResource());
    }

    public void testIsResource() {
        Model m = TestRDFNodes.modelWithStatements("");
        TestRDFNodes.assertEquals(true, m.createResource("eh:/foo").isResource());
        TestRDFNodes.assertEquals(true, m.createResource().isResource());
        TestRDFNodes.assertEquals(false, m.createLiteral(17L).isResource());
        TestRDFNodes.assertEquals(false, m.createTypedLiteral("hello").isResource());
    }
}

