/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.test.TestPrefixMapping;
import com.hp.hpl.jena.util.CollectionFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.TestSuite;

public class TestNamespace
extends ModelTestBase {
    public TestNamespace(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNamespace.class);
    }

    public void testReadPrefixes() {
        Model m = ModelFactory.createDefaultModel();
        m.read("file:testing/wg/rdf-ns-prefix-confusion/test0014.rdf");
        Map ns = m.getNsPrefixMap();
        TestNamespace.assertEquals("namespace eg", (Object)"http://example.org/", ns.get("eg"));
        TestNamespace.assertEquals("namespace rdf", (Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", ns.get("rdf"));
        TestNamespace.assertEquals("not present", null, ns.get("spoo"));
    }

    public void testWritePrefixes() throws IOException {
        Model m = ModelFactory.createDefaultModel();
        ModelCom.addNamespaces(m, this.makePrefixes("fred=ftp://net.fred.org/;spoo=http://spoo.net/"));
        File f = File.createTempFile("hedgehog", ".rdf");
        m.add(TestNamespace.statement(m, "http://spoo.net/S http://spoo.net/P http://spoo.net/O"));
        m.add(TestNamespace.statement(m, "http://spoo.net/S ftp://net.fred.org/P http://spoo.net/O"));
        m.write(new FileOutputStream(f));
        Model m2 = ModelFactory.createDefaultModel();
        m2.read("file:" + f.getAbsolutePath());
        Map ns = m2.getNsPrefixMap();
        TestNamespace.assertEquals("namespace spoo", (Object)"http://spoo.net/", ns.get("spoo"));
        TestNamespace.assertEquals("namespace fred", (Object)"ftp://net.fred.org/", ns.get("fred"));
        f.deleteOnExit();
    }

    private Map makePrefixes(String prefixes) {
        HashMap<String, Set> result = new HashMap<String, Set>();
        StringTokenizer st = new StringTokenizer(prefixes, ";");
        while (st.hasMoreTokens()) {
            String def = st.nextToken();
            int eq = def.indexOf(61);
            result.put(def.substring(0, eq), this.set(def.substring(eq + 1)));
        }
        return result;
    }

    private Set set(String element) {
        Set s = CollectionFactory.createHashedSet();
        s.add(element);
        return s;
    }

    public void testUseEasyPrefix() {
        TestPrefixMapping.testUseEasyPrefix("default model", ModelFactory.createDefaultModel());
    }
}

