/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestSuite;

public class TestModelBulkUpdate
extends ModelTestBase {
    public TestModelBulkUpdate(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelBulkUpdate.class);
    }

    public void testMBU() {
        this.testMBU(ModelFactory.createDefaultModel());
    }

    public void testContains(Model m, Statement[] statements) {
        for (int i = 0; i < statements.length; ++i) {
            TestModelBulkUpdate.assertTrue("it should be here", m.contains(statements[i]));
        }
    }

    public void testContains(Model m, List statements) {
        for (int i = 0; i < statements.size(); ++i) {
            TestModelBulkUpdate.assertTrue("it should be here", m.contains((Statement)statements.get(i)));
        }
    }

    public void testOmits(Model m, Statement[] statements) {
        for (int i = 0; i < statements.length; ++i) {
            TestModelBulkUpdate.assertFalse("it should not be here", m.contains(statements[i]));
        }
    }

    public void testOmits(Model m, List statements) {
        for (int i = 0; i < statements.size(); ++i) {
            TestModelBulkUpdate.assertFalse("it should not be here", m.contains((Statement)statements.get(i)));
        }
    }

    public void testMBU(Model m) {
        Statement[] sArray = TestModelBulkUpdate.statements(m, "moon orbits earth; earth orbits sun");
        List<Statement> sList = Arrays.asList(TestModelBulkUpdate.statements(m, "I drink tea; you drink coffee"));
        m.add(sArray);
        this.testContains(m, sArray);
        m.add(sList);
        this.testContains(m, sList);
        this.testContains(m, sArray);
        m.remove(sArray);
        this.testOmits(m, sArray);
        this.testContains(m, sList);
        m.remove(sList);
        this.testOmits(m, sArray);
        this.testOmits(m, sList);
    }

    public void testBulkByModel() {
        this.testBulkByModel(ModelFactory.createDefaultModel());
    }

    public void testBulkByModel(Model m) {
        TestModelBulkUpdate.assertEquals("precondition: model must be empty", 0L, m.size());
        Model A = TestModelBulkUpdate.modelWithStatements("clouds offer rain; trees offer shelter");
        Model B = TestModelBulkUpdate.modelWithStatements("x R y; y Q z; z P x");
        m.add(A);
        TestModelBulkUpdate.assertIsoModels(A, m);
        m.add(B);
        m.remove(A);
        TestModelBulkUpdate.assertIsoModels(B, m);
        m.remove(B);
        TestModelBulkUpdate.assertEquals("", 0L, m.size());
    }

    public void testBulkRemoveSelf() {
        Model m = TestModelBulkUpdate.modelWithStatements("they sing together; he sings alone");
        m.remove(m);
        TestModelBulkUpdate.assertEquals("", 0L, m.size());
    }

    public void testBulkByModelReifying() {
        this.testBulkByModelReifying(false);
        this.testBulkByModelReifying(true);
    }

    public void testBulkByModelReifying(boolean suppress) {
        Model m = TestModelBulkUpdate.modelWithStatements(ReificationStyle.Minimal, "a P b");
        this.addReification(m, "x", "S P O");
        this.addReification(m, "a", "x R y");
        Model target = TestModelBulkUpdate.modelWithStatements(ReificationStyle.Minimal, "");
        target.add(m, suppress);
        target.setNsPrefixes(PrefixMapping.Standard);
        TestModelBulkUpdate.assertIsoModels(suppress ? TestModelBulkUpdate.modelWithStatements("a P b") : m, target);
    }

    public void testBulkDeleteByModelReifying() {
        this.testBulkDeleteByModelReifying(false);
        this.testBulkDeleteByModelReifying(true);
    }

    public void testBulkDeleteByModelReifying(boolean suppress) {
        Model target = TestModelBulkUpdate.modelWithStatements(ReificationStyle.Minimal, "");
        this.addReification(target, "x", "S P O");
        this.addReification(target, "y", "A P B");
        Model remove = TestModelBulkUpdate.modelWithStatements("");
        this.addReification(remove, "y", "A P B");
        Model answer = TestModelBulkUpdate.modelWithStatements("");
        this.addReification(answer, "x", "S P O");
        if (suppress) {
            this.addReification(answer, "y", "A P B");
        }
        target.remove(remove, suppress);
        TestModelBulkUpdate.assertIsoModels(answer, target);
    }

    public void addReification(Model m, String tag, String statement) {
        m.createReifiedStatement(tag, TestModelBulkUpdate.statement(m, statement));
    }
}

