/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.states.test;

import com.hp.hpl.jena.rdf.arp.impl.ANode;
import com.hp.hpl.jena.rdf.arp.impl.AbsXMLContext;
import com.hp.hpl.jena.rdf.arp.impl.XMLHandler;
import com.hp.hpl.jena.rdf.arp.states.AbsXMLLiteral;
import com.hp.hpl.jena.rdf.arp.states.HasSubjectFrameI;
import com.hp.hpl.jena.rdf.arp.states.WantsObjectFrameI;
import com.hp.hpl.jena.rdf.arp.states.test.EventRecord;
import junit.framework.Assert;

class TestFrame
extends AbsXMLLiteral
implements WantsObjectFrameI,
HasSubjectFrameI {
    int oCount;
    int pCount;
    int rCount;

    public TestFrame(XMLHandler h, AbsXMLContext x) {
        super(h, x);
    }

    void clear() {
        this.rslt.setLength(0);
        this.oCount = 0;
        this.pCount = 0;
        this.rCount = 0;
    }

    public void endElement() {
    }

    public void theObject(ANode a) {
        ++this.oCount;
    }

    public void aPredAndObj(ANode p, ANode o) {
        ++this.pCount;
    }

    public String info() {
        return (this.rslt.length() == 0 ? "" : "x" + this.rslt.length() + " ") + (this.oCount == 0 ? "" : "O" + this.oCount + " ") + (this.pCount == 0 ? "" : "P" + this.pCount + " ") + (this.rCount == 0 ? "" : "R" + this.rCount + " ");
    }

    public void check(EventRecord r) {
        r.initCounts();
        Assert.assertEquals("object looking for s,p count", r.objects, this.oCount);
        Assert.assertEquals("p,o looking for s count", r.preds, this.pCount);
        Assert.assertEquals("reification count", r.reify, this.rCount);
    }

    public void makeSubjectReificationWith(ANode r) {
        ++this.rCount;
    }
}

