/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestResource
extends OntTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntResource;

    public static TestSuite suite() {
        return new TestResource("TestResource");
    }

    public TestResource(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("OntResource.sameAs", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource c = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                a.addSameAs(b);
                1.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.SAME_AS()));
                1.assertEquals("a should be sameAs b", b, a.getSameAs());
                a.addSameAs(c);
                1.assertEquals("Cardinality should be 2", 2, a.getCardinality(prof.SAME_AS()));
                this.iteratorTest(a.listSameAs(), new Object[]{b, c});
                1.assertTrue("a should be the same as b", a.isSameAs(b));
                1.assertTrue("a should be the same as c", a.isSameAs(c));
                a.setSameAs(b);
                1.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.SAME_AS()));
                1.assertEquals("a should be sameAs b", b, a.getSameAs());
                a.removeSameAs(c);
                1.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.SAME_AS()));
                a.removeSameAs(b);
                1.assertEquals("Cardinality should be 0", 0, a.getCardinality(prof.SAME_AS()));
            }
        }, new OntTestBase.OntTestCase("OntResource.differentFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource c = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                a.addDifferentFrom(b);
                2.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.DIFFERENT_FROM()));
                2.assertEquals("a should be differentFrom b", b, a.getDifferentFrom());
                a.addDifferentFrom(c);
                2.assertEquals("Cardinality should be 2", 2, a.getCardinality(prof.DIFFERENT_FROM()));
                this.iteratorTest(a.listDifferentFrom(), new Object[]{b, c});
                2.assertTrue("a should be diff from b", a.isDifferentFrom(b));
                2.assertTrue("a should be diff from c", a.isDifferentFrom(c));
                a.setDifferentFrom(b);
                2.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.DIFFERENT_FROM()));
                2.assertEquals("a should be differentFrom b", b, a.getDifferentFrom());
                a.removeDifferentFrom(c);
                2.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.DIFFERENT_FROM()));
                a.removeDifferentFrom(b);
                2.assertEquals("Cardinality should be 0", 0, a.getCardinality(prof.DIFFERENT_FROM()));
            }
        }, new OntTestBase.OntTestCase("OntResource.seeAlso", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource c = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                a.addSeeAlso(b);
                3.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.SEE_ALSO()));
                3.assertEquals("a should be seeAlso b", b, a.getSeeAlso());
                a.addSeeAlso(c);
                3.assertEquals("Cardinality should be 2", 2, a.getCardinality(prof.SEE_ALSO()));
                this.iteratorTest(a.listSeeAlso(), new Object[]{b, c});
                3.assertTrue("a should have seeAlso b", a.hasSeeAlso(b));
                3.assertTrue("a should have seeAlso c", a.hasSeeAlso(c));
                a.setSeeAlso(b);
                3.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.SEE_ALSO()));
                3.assertEquals("a should be seeAlso b", b, a.getSeeAlso());
                a.removeSeeAlso(c);
                3.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.SEE_ALSO()));
                a.removeSeeAlso(b);
                3.assertEquals("Cardinality should be 0", 0, a.getCardinality(prof.SEE_ALSO()));
            }
        }, new OntTestBase.OntTestCase("OntResource.isDefinedBy", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource c = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                a.addIsDefinedBy(b);
                4.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.IS_DEFINED_BY()));
                4.assertEquals("a should be isDefinedBy b", b, a.getIsDefinedBy());
                a.addIsDefinedBy(c);
                4.assertEquals("Cardinality should be 2", 2, a.getCardinality(prof.IS_DEFINED_BY()));
                this.iteratorTest(a.listIsDefinedBy(), new Object[]{b, c});
                4.assertTrue("a should be defined by b", a.isDefinedBy(b));
                4.assertTrue("a should be defined by c", a.isDefinedBy(c));
                a.setIsDefinedBy(b);
                4.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.IS_DEFINED_BY()));
                4.assertEquals("a should be isDefinedBy b", b, a.getIsDefinedBy());
                a.removeDefinedBy(c);
                4.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.IS_DEFINED_BY()));
                a.removeDefinedBy(b);
                4.assertEquals("Cardinality should be 0", 0, a.getCardinality(prof.IS_DEFINED_BY()));
            }
        }, new OntTestBase.OntTestCase("OntResource.versionInfo", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                a.addVersionInfo("some info");
                5.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.VERSION_INFO()));
                5.assertEquals("a has wrong version info", "some info", a.getVersionInfo());
                a.addVersionInfo("more info");
                5.assertEquals("Cardinality should be 2", 2, a.getCardinality(prof.VERSION_INFO()));
                this.iteratorTest(a.listVersionInfo(), new Object[]{"some info", "more info"});
                5.assertTrue("a should have some info", a.hasVersionInfo("some info"));
                5.assertTrue("a should have more info", a.hasVersionInfo("more info"));
                a.setVersionInfo("new info");
                5.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.VERSION_INFO()));
                5.assertEquals("a has wrong version info", "new info", a.getVersionInfo());
                a.removeVersionInfo("old info");
                5.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.VERSION_INFO()));
                a.removeVersionInfo("new info");
                5.assertEquals("Cardinality should be 0", 0, a.getCardinality(prof.VERSION_INFO()));
            }
        }, new OntTestBase.OntTestCase("OntResource.label.nolang", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                a.addLabel("some info", null);
                6.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.LABEL()));
                6.assertEquals("a has wrong label", "some info", a.getLabel(null));
                a.addLabel("more info", null);
                6.assertEquals("Cardinality should be 2", 2, a.getCardinality(prof.LABEL()));
                this.iteratorTest(a.listLabels(null), new Object[]{m.createLiteral("some info"), m.createLiteral("more info")});
                6.assertTrue("a should have label some info", a.hasLabel("some info", null));
                6.assertTrue("a should have label more info", a.hasLabel("more info", null));
                a.setLabel("new info", null);
                6.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.LABEL()));
                6.assertEquals("a has wrong label", "new info", a.getLabel(null));
                a.removeLabel("foo", null);
                6.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.LABEL()));
                a.removeLabel("new info", null);
                6.assertEquals("Cardinality should be 0", 0, a.getCardinality(prof.LABEL()));
            }
        }, new OntTestBase.OntTestCase("OntResource.label.lang", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                a.addLabel("good", "EN");
                7.assertEquals("wrong label", "good", a.getLabel(null));
                a.addLabel("bon", "FR");
                7.assertEquals("wrong label", "good", a.getLabel("EN"));
                7.assertEquals("wrong label", null, a.getLabel("EN-GB"));
                7.assertEquals("wrong label", "bon", a.getLabel("FR"));
                7.assertTrue("a should have label good", a.hasLabel("good", "EN"));
                7.assertTrue("a should have label bon", a.hasLabel("bon", "FR"));
                7.assertTrue("a should note have label good (DE)", !a.hasLabel("good", "DE"));
                a.addLabel("spiffing", "EN-GB");
                a.addLabel("duude", "EN-US");
                7.assertEquals("wrong label", "spiffing", a.getLabel("EN-GB"));
                7.assertEquals("wrong label", "duude", a.getLabel("EN-US"));
                7.assertEquals("wrong label", null, a.getLabel("DE"));
                a.addLabel("abcdef", "AB-CD");
                7.assertEquals("wrong label", "abcdef", a.getLabel("AB"));
                7.assertEquals("wrong label", null, a.getLabel("AB-XY"));
                a.removeLabel("abcde", "AB-CD");
                7.assertEquals("Cardinality should be 5", 5, a.getCardinality(a.getProfile().LABEL()));
                a.removeLabel("abcdef", "AB-CD");
                7.assertEquals("Cardinality should be 4", 4, a.getCardinality(a.getProfile().LABEL()));
            }
        }, new OntTestBase.OntTestCase("OntResource.comment.nolang", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                a.addComment("some info", null);
                8.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.COMMENT()));
                8.assertEquals("a has wrong comment", "some info", a.getComment(null));
                a.addComment("more info", null);
                8.assertEquals("Cardinality should be 2", 2, a.getCardinality(prof.COMMENT()));
                this.iteratorTest(a.listComments(null), new Object[]{m.createLiteral("some info"), m.createLiteral("more info")});
                8.assertTrue("a should have comment some info", a.hasComment("some info", null));
                8.assertTrue("a should have comment more info", a.hasComment("more info", null));
                a.setComment("new info", null);
                8.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.COMMENT()));
                8.assertEquals("a has wrong comment", "new info", a.getComment(null));
                a.removeComment("foo", null);
                8.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.COMMENT()));
                a.removeComment("new info", null);
                8.assertEquals("Cardinality should be 0", 0, a.getCardinality(prof.COMMENT()));
            }
        }, new OntTestBase.OntTestCase("OntResource.comment.lang", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                a.addComment("good", "EN");
                9.assertEquals("wrong comment", "good", a.getComment(null));
                a.addComment("bon", "FR");
                9.assertEquals("wrong comment", "good", a.getComment("EN"));
                9.assertEquals("wrong comment", null, a.getComment("EN-GB"));
                9.assertEquals("wrong comment", "bon", a.getComment("FR"));
                9.assertTrue("a should have label good", a.hasComment("good", "EN"));
                9.assertTrue("a should have label bon", a.hasComment("bon", "FR"));
                9.assertTrue("a should note have label good (DE)", !a.hasComment("good", "DE"));
                a.addComment("spiffing", "EN-GB");
                a.addComment("duude", "EN-US");
                9.assertEquals("wrong comment", "spiffing", a.getComment("EN-GB"));
                9.assertEquals("wrong comment", "duude", a.getComment("EN-US"));
                9.assertEquals("wrong comment", null, a.getComment("DE"));
                a.addComment("abcdef", "AB-CD");
                9.assertEquals("wrong comment", "abcdef", a.getComment("AB"));
                9.assertEquals("wrong comment", null, a.getComment("AB-XY"));
                a.removeComment("abcde", "AB-CD");
                9.assertEquals("Cardinality should be 5", 5, a.getCardinality(a.getProfile().COMMENT()));
                a.removeComment("abcdef", "AB-CD");
                9.assertEquals("Cardinality should be 4", 4, a.getCardinality(a.getProfile().COMMENT()));
            }
        }, new OntTestBase.OntTestCase("OntResource.type (no inference)", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass(B);
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                10.assertEquals("Cardinality of rdf:type is wrong", 0, a.getCardinality(RDF.type));
                a.addRDFType(B);
                10.assertEquals("rdf:type of a is wrong", B, a.getRDFType());
                10.assertEquals("rdf:type of a is wrong", B, a.getRDFType(false));
                this.iteratorTest(a.listRDFTypes(false), new Object[]{B});
                this.iteratorTest(a.listRDFTypes(true), new Object[]{B});
                a.addRDFType(A);
                this.iteratorTest(a.listRDFTypes(false), new Object[]{A, B});
                this.iteratorTest(a.listRDFTypes(true), new Object[]{B});
                10.assertTrue("a should not be of class A direct", !a.hasRDFType(A, true));
                10.assertTrue("a should not be of class B direct", a.hasRDFType(B, true));
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                a.setRDFType(C2);
                10.assertTrue("a should be of class C", a.hasRDFType(C2, false));
                10.assertTrue("a should not be of class A", !a.hasRDFType(A, false));
                10.assertTrue("a should not be of class B", !a.hasRDFType(B, false));
                a.removeRDFType(B);
                10.assertEquals("Cardinality should be 1", 1, a.getCardinality(RDF.type));
                a.removeRDFType(C2);
                10.assertEquals("Cardinality should be 0", 0, a.getCardinality(RDF.type));
            }
        }, new OntTestBase.OntTestCase("OntResource.remove", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
                OntClass E = m.createClass("http://jena.hpl.hp.com/testing/ontology#E");
                A.addSubClass(B);
                A.addSubClass(C2);
                C2.addSubClass(D);
                C2.addSubClass(E);
                11.assertTrue("super-class of E", E.hasSuperClass(C2, false));
                this.iteratorTest(A.listSubClasses(), new Object[]{B, C2});
                C2.remove();
                11.assertTrue("super-class of D", !D.hasSuperClass(C2, false));
                11.assertTrue("super-class of E", !E.hasSuperClass(C2, false));
                this.iteratorTest(A.listSubClasses(), new Object[]{B});
            }
        }, new OntTestBase.OntTestCase("OntResource.asClass", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Resource r = m.createResource();
                r.addProperty(RDF.type, m.getProfile().CLASS());
                OntResource or = (OntResource)r.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                12.assertFalse("should not be annotation prop", or.isAnnotationProperty());
                12.assertFalse("should not be all different", or.isAllDifferent());
                12.assertTrue("should be class", or.isClass());
                12.assertFalse("should not be property", or.isProperty());
                12.assertFalse("should not be object property", or.isObjectProperty());
                12.assertFalse("should not be datatype property", or.isDatatypeProperty());
                12.assertTrue("should not be individual", this.owlFull() || !or.isIndividual());
                12.assertFalse("should not be data range", or.isDataRange());
                12.assertFalse("should not be ontology", or.isOntology());
                OntClass n = or.asClass();
                12.assertTrue("Should be OntClass", n instanceof OntClass);
            }
        }, new OntTestBase.OntTestCase("OntResource.asAnnotationProperty", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().ANNOTATION_PROPERTY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, m.getProfile().ANNOTATION_PROPERTY());
                OntResource or = (OntResource)r.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                13.assertTrue("should be annotation prop", or.isAnnotationProperty());
                13.assertFalse("should not be all different", or.isAllDifferent());
                13.assertFalse("should not be class", or.isClass());
                13.assertTrue("should be property", or.isProperty());
                13.assertFalse("should not be object property", or.isObjectProperty());
                13.assertFalse("should not be datatype property", or.isDatatypeProperty());
                13.assertFalse("should not be individual", or.isIndividual());
                13.assertFalse("should not be data range", or.isDataRange());
                13.assertFalse("should not be ontology", or.isOntology());
                AnnotationProperty n = or.asAnnotationProperty();
                13.assertTrue("Should be AnnotationProperty", n instanceof AnnotationProperty);
            }
        }, new OntTestBase.OntTestCase("OntResource.asObjectProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().OBJECT_PROPERTY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, m.getProfile().OBJECT_PROPERTY());
                OntResource or = (OntResource)r.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                14.assertFalse("should not be annotation prop", or.isAnnotationProperty());
                14.assertFalse("should not be all different", or.isAllDifferent());
                14.assertFalse("should not be class", or.isClass());
                14.assertTrue("should be property", or.isProperty());
                14.assertTrue("should be object property", or.isObjectProperty());
                14.assertFalse("should not be datatype property", or.isDatatypeProperty());
                14.assertFalse("should not be individual", or.isIndividual());
                14.assertFalse("should not be data range", or.isDataRange());
                14.assertFalse("should not be ontology", or.isOntology());
                ObjectProperty n = or.asObjectProperty();
                14.assertTrue("Should be ObjectProperty", n instanceof ObjectProperty);
            }
        }, new OntTestBase.OntTestCase("OntResource.asDatatypeProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().DATATYPE_PROPERTY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, m.getProfile().DATATYPE_PROPERTY());
                OntResource or = (OntResource)r.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                15.assertFalse("should not be annotation prop", or.isAnnotationProperty());
                15.assertFalse("should not be all different", or.isAllDifferent());
                15.assertFalse("should not be class", or.isClass());
                15.assertTrue("should be property", or.isProperty());
                15.assertFalse("should not be object property", or.isObjectProperty());
                15.assertTrue("should be datatype property", or.isDatatypeProperty());
                15.assertFalse("should not be individual", or.isIndividual());
                15.assertFalse("should not be data range", or.isDataRange());
                15.assertFalse("should not be ontology", or.isOntology());
                DatatypeProperty n = or.asDatatypeProperty();
                15.assertTrue("Should be DatatypeProperty", n instanceof DatatypeProperty);
            }
        }, new OntTestBase.OntTestCase("OntResource.asAllDifferent", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().ALL_DIFFERENT() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, m.getProfile().ALL_DIFFERENT());
                OntResource or = (OntResource)r.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                16.assertFalse("should not be annotation prop", or.isAnnotationProperty());
                16.assertTrue("should be all different", or.isAllDifferent());
                16.assertFalse("should not be class", or.isClass());
                16.assertFalse("should not be property", or.isProperty());
                16.assertFalse("should not be object property", or.isObjectProperty());
                16.assertFalse("should not be datatype property", or.isDatatypeProperty());
                16.assertFalse("should not be individual", or.isIndividual());
                16.assertFalse("should not be data range", or.isDataRange());
                16.assertFalse("should not be ontology", or.isOntology());
                AllDifferent n = or.asAllDifferent();
                16.assertTrue("Should be AnnotationProperty", n instanceof AllDifferent);
            }
        }, new OntTestBase.OntTestCase("OntResource.asProperty", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Resource r = m.createResource();
                r.addProperty(RDF.type, m.getProfile().PROPERTY());
                OntResource or = (OntResource)r.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                17.assertFalse("should not be annotation prop", or.isAnnotationProperty());
                17.assertFalse("should not be all different", or.isAllDifferent());
                17.assertFalse("should not be class", or.isClass());
                17.assertTrue("should be property", or.isProperty());
                17.assertFalse("should not be object property", or.isObjectProperty());
                17.assertFalse("should not be datatype property", or.isDatatypeProperty());
                17.assertFalse("should not be individual", or.isIndividual());
                17.assertFalse("should not be data range", or.isDataRange());
                17.assertFalse("should not be ontology", or.isOntology());
                OntProperty n = or.asProperty();
                17.assertTrue("Should be OntProperty", n instanceof OntProperty);
            }
        }, new OntTestBase.OntTestCase("OntResource.asIndividual", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Resource r = m.createResource();
                Resource s = m.createResource();
                s.addProperty(RDF.type, m.getProfile().CLASS());
                r.addProperty(RDF.type, s);
                OntResource or = (OntResource)r.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                18.assertFalse("should not be annotation prop", or.isAnnotationProperty());
                18.assertFalse("should not be all different", or.isAllDifferent());
                18.assertFalse("should not be class", or.isClass());
                18.assertFalse("should not be property", or.isProperty());
                18.assertFalse("should not be object property", or.isObjectProperty());
                18.assertFalse("should not be datatype property", or.isDatatypeProperty());
                18.assertTrue("should be individual", or.isIndividual());
                18.assertFalse("should not be data range", or.isDataRange());
                18.assertFalse("should not be ontology", or.isOntology());
                Individual n = or.asIndividual();
                18.assertTrue("Should be individual", n instanceof Individual);
            }
        }, new OntTestBase.OntTestCase("OntResource.asDataRange", true, false, false, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().DATARANGE() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, m.getProfile().DATARANGE());
                OntResource or = (OntResource)r.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                19.assertFalse("should not be annotation prop", or.isAnnotationProperty());
                19.assertFalse("should not be all different", or.isAllDifferent());
                19.assertFalse("should not be class", or.isClass());
                19.assertFalse("should not be property", or.isProperty());
                19.assertFalse("should not be object property", or.isObjectProperty());
                19.assertFalse("should not be datatype property", or.isDatatypeProperty());
                19.assertFalse("should not be individual", or.isIndividual());
                19.assertTrue("should be data range", or.isDataRange());
                19.assertFalse("should not be ontology", or.isOntology());
                DataRange n = or.asDataRange();
                19.assertTrue("Should be DataRange", n instanceof DataRange);
            }
        }, new OntTestBase.OntTestCase("OntResource.asOntology", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().ONTOLOGY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, m.getProfile().ONTOLOGY());
                OntResource or = (OntResource)r.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                20.assertFalse("should not be annotation prop", or.isAnnotationProperty());
                20.assertFalse("should not be all different", or.isAllDifferent());
                20.assertFalse("should not be class", or.isClass());
                20.assertFalse("should not be property", or.isProperty());
                20.assertFalse("should not be object property", or.isObjectProperty());
                20.assertFalse("should not be datatype property", or.isDatatypeProperty());
                20.assertFalse("should not be individual", or.isIndividual());
                20.assertFalse("should not be data range", or.isDataRange());
                20.assertTrue("should be ontology", or.isOntology());
                Ontology n = or.asOntology();
                20.assertTrue("Should be Ontology", n instanceof Ontology);
            }
        }, new OntTestBase.OntTestCase("OntResource.isLanguageTerm", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource or = (OntResource)m.getProfile().CLASS().inModel(m).as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                21.assertTrue("should be a lang term", or.isOntLanguageTerm());
                or = m.createOntResource("http://foo/bar");
                21.assertFalse("should not be a lang term", or.isOntLanguageTerm());
            }
        }, new OntTestBase.OntTestCase("OntResource.getOntModel", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource or = m.createOntResource("http://foo/bar");
                OntModel m0 = or.getOntModel();
                22.assertEquals(m, m0);
            }
        }, new OntTestBase.OntTestCase("OntResource.getPropertyValue - object prop", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource a = m.createOntResource("http://foo/bar#a");
                Resource b = m.createResource("http://foo/bar#b");
                OntProperty p = m.createOntProperty("http://foo/bar#p");
                m.add((Resource)a, (Property)p, b);
                RDFNode bb = a.getPropertyValue(p);
                23.assertEquals(b, bb);
                23.assertTrue("Return value should be an OntResource", bb instanceof OntResource);
            }
        }, new OntTestBase.OntTestCase("OntResource.getPropertyValue - missing prop", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource a = m.createOntResource("http://foo/bar#a");
                Resource b = m.createResource("http://foo/bar#b");
                OntProperty p = m.createOntProperty("http://foo/bar#p");
                OntProperty q = m.createOntProperty("http://foo/bar#q");
                m.add((Resource)a, (Property)p, b);
                RDFNode bb = a.getPropertyValue(q);
                24.assertNull(bb);
            }
        }, new OntTestBase.OntTestCase("OntResource.listPropertyValues - object prop", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource a = m.createOntResource("http://foo/bar#a");
                Resource b = m.createResource("http://foo/bar#b");
                OntProperty p = m.createOntProperty("http://foo/bar#p");
                Literal l = m.createTypedLiteral(false);
                m.add((Resource)a, (Property)p, b);
                m.add((Resource)a, (Property)p, l);
                NodeIterator ni = a.listPropertyValues(p);
                while (ni.hasNext()) {
                    RDFNode n = ni.nextNode();
                    if (!n.isResource()) continue;
                    25.assertEquals(b, n);
                    25.assertTrue("Return value should be an OntResource", n instanceof OntResource);
                }
            }
        }};
    }
}

