/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import junit.framework.TestSuite;

public class TestIndividual
extends OntTestBase {
    public static TestSuite suite() {
        return new TestIndividual("TestIndividual");
    }

    public TestIndividual(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("Individual.sameAs", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                Individual x = m.createIndividual(A);
                Individual y = m.createIndividual(A);
                Individual z = m.createIndividual(A);
                x.addSameAs(y);
                1.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.SAME_AS()));
                1.assertEquals("x should be the same as y", y, x.getSameAs());
                1.assertTrue("x should be the same as y", x.isSameAs(y));
                x.addSameAs(z);
                1.assertEquals("Cardinality should be 2", 2, x.getCardinality(prof.SAME_AS()));
                this.iteratorTest(x.listSameAs(), new Object[]{z, y});
                x.setSameAs(z);
                1.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.SAME_AS()));
                1.assertEquals("x should be same indiv. as z", z, x.getSameAs());
                x.removeSameAs(y);
                1.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.SAME_AS()));
                x.removeSameAs(z);
                1.assertEquals("Cardinality should be 0", 0, x.getCardinality(prof.SAME_AS()));
            }
        }};
    }
}

