/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.mem.faster.GraphMemFasterQueryHandler;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.ontology.impl.OntClassImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelMakerImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.reasoner.dig.DIGReasonerFactory;
import com.hp.hpl.jena.reasoner.dig.DIGWrappedException;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;

public class TestBugReports
extends TestCase {
    public static String NS = "http://example.org/test#";
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Restriction;

    public TestBugReports(String name) {
        super(name);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void test_dn_0() {
        OntModel schema = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM_RULES_INF, null);
        schema.read("file:doc/inference/data/owlDemoSchema.xml", null);
        int count = 0;
        ExtendedIterator i = schema.listIndividuals();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        TestBugReports.assertEquals("Expecting 6 individuals", 6, count);
    }

    public void test_dn_01() {
        OntModel m0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM_RULE_INF, null);
        m0.read("file:testing/ontology/bugs/test_hk_07B.owl");
        OntProperty p0 = m0.getOntProperty("file:testing/ontology/bugs/test_hk_07B.owl#PropB");
        int count = 0;
        ExtendedIterator i = p0.listDomain();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        TestBugReports.assertEquals(3, count);
        OntModel m1 = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM_RULE_INF, null);
        m1.read("file:testing/ontology/bugs/test_hk_07B.owl");
        OntProperty p1 = m1.getOntProperty("file:testing/ontology/bugs/test_hk_07B.owl#PropB");
        count = 0;
        ExtendedIterator i2 = p1.listDomain();
        while (i2.hasNext()) {
            ++count;
            i2.next();
        }
        TestBugReports.assertEquals(3, count);
    }

    public void test_dn_02() {
        OntModel mymod = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        mymod.read("file:testing/ontology/testImport3/a.owl");
        TestBugReports.assertEquals("Graph count..", 2, mymod.getSubGraphs().size());
        ExtendedIterator it = mymod.listImportedModels();
        while (it.hasNext()) {
            mymod.removeSubModel((Model)it.next());
        }
        TestBugReports.assertEquals("Graph count..", 0, mymod.getSubGraphs().size());
    }

    public void test_mra_01() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null, null);
        String myDicURI = "http://somewhere/myDictionaries/1.0#";
        String damlURI = "http://www.daml.org/2001/03/daml+oil#";
        m.setNsPrefix("DAML", damlURI);
        String c1_uri = myDicURI + "C1";
        OntClass c1 = m.createClass(c1_uri);
        DatatypeProperty p1 = m.createDatatypeProperty(myDicURI + "P1");
        p1.setDomain(c1);
        ByteArrayOutputStream strOut = new ByteArrayOutputStream();
        m.write(strOut, "RDF/XML-ABBREV", myDicURI);
    }

    public void test_hk_01() {
        String base = "http://jena.hpl.hp.com/test#";
        String doc = "<rdf:RDF   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"   xmlns:owl=\"http://www.w3.org/2002/07/owl#\">  <owl:Ontology rdf:about=\"\">    <owl:imports rdf:resource=\"http://www.w3.org/2002/07/owl\" />  </owl:Ontology></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        m.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        m.read(new ByteArrayInputStream(doc.getBytes()), base);
        Resource owlClassRes = m.getResource(OWL.Class.getURI());
        OntClass c = (OntClass)owlClassRes.as(OntClass.class);
        TestBugReports.assertNotNull("OntClass c should not be null", c);
    }

    public void test_hk_02() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel(spec, null);
        ontModel.createAllDifferent();
        TestBugReports.assertTrue(ontModel.listAllDifferent().hasNext());
        AllDifferent allDifferent = (AllDifferent)ontModel.listAllDifferent().next();
        TestBugReports.assertFalse(allDifferent.listDistinctMembers().hasNext());
    }

    public void test_hk_03() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel(spec, null);
        ObjectProperty property = ontModel.createObjectProperty("http://www.aldi.de#property");
        ontModel.createMinCardinalityRestriction(null, property, 42);
    }

    public void test_hk_04() {
        OntModel m = ModelFactory.createOntologyModel();
        m.getDocumentManager().addAltEntry("http://jena.hpl.hp.com/testing/ontology/relativenames", "file:testing/ontology/relativenames.rdf");
        m.read("http://jena.hpl.hp.com/testing/ontology/relativenames");
        TestBugReports.assertTrue("#A should be a class", m.getResource("http://jena.hpl.hp.com/testing/ontology/relativenames#A").canAs(OntClass.class));
        TestBugReports.assertFalse("file: #A should not be a class", m.getResource("file:testing/ontology/relativenames.rdf#A").canAs(OntClass.class));
    }

    public void test_hk_05() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel(spec, null);
        String ns = "http://foo.bar/fu#";
        OntClass a = ontModel.createClass(ns + "A");
        OntClass b = ontModel.createClass(ns + "B");
        int oldCount = this.getStatementCount(ontModel);
        RDFList members = ontModel.createList(new RDFNode[]{a, b});
        IntersectionClass intersectionClass = ontModel.createIntersectionClass(null, members);
        intersectionClass.remove();
        TestBugReports.assertEquals("Before and after statement counts are different", oldCount, this.getStatementCount(ontModel));
    }

    public void test_hk_06() throws Exception {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.read("file:testing/ontology/bugs/test_hk_06/a.owl");
        String NSa = "http://jena.hpl.hp.com/2003/03/testont/a#";
        String NSb = "http://jena.hpl.hp.com/2003/03/testont/b#";
        OntClass A = ontModel.getOntClass(NSa + "A");
        TestBugReports.assertTrue("class A should be in the base model", ontModel.isInBaseModel(A));
        OntClass B = ontModel.getOntClass(NSb + "B");
        TestBugReports.assertFalse("class B should not be in the base model", ontModel.isInBaseModel(B));
        TestBugReports.assertTrue("A rdf:type owl:Class should be in the base model", ontModel.isInBaseModel(ontModel.createStatement((Resource)A, RDF.type, OWL.Class)));
        TestBugReports.assertFalse("B rdf:type owl:Class should not be in the base model", ontModel.isInBaseModel(ontModel.createStatement((Resource)B, RDF.type, OWL.Class)));
    }

    public void test_hk_07() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        Resource c = m.createResource();
        c.addProperty(RDF.type, RDFS.Datatype);
        TestBugReports.assertTrue(c.canAs(OntClass.class));
        m = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
        c = m.createResource();
        c.addProperty(RDF.type, RDFS.Datatype);
        TestBugReports.assertTrue(c.canAs(OntClass.class));
        m = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM);
        c = m.createResource();
        c.addProperty(RDF.type, RDFS.Datatype);
        TestBugReports.assertTrue(c.canAs(OntClass.class));
        m = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM);
        c = m.createResource();
        c.addProperty(RDF.type, RDFS.Datatype);
        TestBugReports.assertTrue(c.canAs(OntClass.class));
    }

    public void test_hk_importCache() {
        String BASE = "http://protege.stanford.edu/plugins/owl/testdata/";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        OntDocumentManager dm = OntDocumentManager.getInstance();
        dm.reset();
        dm.setCacheModels(false);
        dm.addAltEntry("http://protege.stanford.edu/plugins/owl/testdata/Import-normalizerBug.owl", "file:testing/ontology/bugs/test_hk_import/Import-normalizerBug.owl");
        dm.addAltEntry("http://protege.stanford.edu/plugins/owl/testdata/normalizerBug.owl", "file:testing/ontology/bugs/test_hk_import/normalizerBug.owl");
        spec.setDocumentManager(dm);
        OntModel oldOntModel = ModelFactory.createOntologyModel(spec, null);
        oldOntModel.read("http://protege.stanford.edu/plugins/owl/testdata/Import-normalizerBug.owl", "RDF/XML-ABBREV");
        Graph oldSubGraph = (Graph)oldOntModel.getSubGraphs().iterator().next();
        int oldTripleCount = this.getTripleCount(oldSubGraph);
        OntClass ontClass = oldOntModel.getOntClass("http://protege.stanford.edu/plugins/owl/testdata/normalizerBug.owl#SuperClass");
        oldSubGraph.add(new Triple(ontClass.asNode(), RDF.type.asNode(), OWL.DeprecatedClass.asNode()));
        TestBugReports.assertEquals(oldTripleCount + 1, this.getTripleCount(oldSubGraph));
        SimpleGraphMaker sgm = (SimpleGraphMaker)((ModelMakerImpl)spec.getImportModelMaker()).getGraphMaker();
        ArrayList toGo = new ArrayList();
        Iterator i = sgm.listGraphs();
        while (i.hasNext()) {
            toGo.add(i.next());
        }
        i = toGo.iterator();
        while (i.hasNext()) {
            sgm.removeGraph((String)i.next());
        }
        dm.clearCache();
        OntModel newOntModel = ModelFactory.createOntologyModel(spec, null);
        newOntModel.read("http://protege.stanford.edu/plugins/owl/testdata/Import-normalizerBug.owl", "RDF/XML-ABBREV");
        Graph newSubGraph = (Graph)newOntModel.getSubGraphs().iterator().next();
        TestBugReports.assertFalse(newOntModel == oldOntModel);
        TestBugReports.assertFalse(newSubGraph == oldSubGraph);
        int newTripleCount = this.getTripleCount(newSubGraph);
        TestBugReports.assertEquals(oldTripleCount, newTripleCount);
    }

    private int getTripleCount(Graph graph) {
        int count = 0;
        ExtendedIterator it = graph.find(null, null, null);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public void test_fc_01() {
        OntModel m = ModelFactory.createOntologyModel();
        ObjectProperty p = m.createObjectProperty(NS + "p");
        Restriction r = m.createRestriction(p);
        HasValueRestriction hv = r.convertToHasValueRestriction(m.createLiteral(1L));
        RDFNode n = hv.getHasValue();
        TestBugReports.assertFalse("Should not be able to convert literal to individual", n.canAs(Individual.class));
    }

    public void test_ck_01() {
        MockTransactionHandler m_t = new MockTransactionHandler();
        Graph g = Factory.createGraphMemWithTransactionHandler(m_t);
        Model m0 = ModelFactory.createModelForGraph(g);
        OntModel m1 = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM, m0);
        TestBugReports.assertFalse("should not initially be in a transaction", m_t.m_inTransaction);
        m1.begin();
        TestBugReports.assertTrue("should be in a transaction", m_t.m_inTransaction);
        m1.abort();
        TestBugReports.assertFalse("should not still be in transaction", m_t.m_inTransaction);
        TestBugReports.assertTrue("transaction should have been aborted", m_t.m_aborted);
        m1.begin();
        TestBugReports.assertTrue("should be in a (new) transaction", m_t.m_inTransaction);
        m1.commit();
        TestBugReports.assertFalse("should not be in transaction post-commit", m_t.m_inTransaction);
        TestBugReports.assertTrue("should be marked committed post-commit", m_t.m_committed);
    }

    public void test_ck_02() {
        OntModel vocabModel = ModelFactory.createOntologyModel();
        ObjectProperty p = vocabModel.createObjectProperty("p");
        OntClass A = vocabModel.createClass("A");
        OntModel workModel = ModelFactory.createOntologyModel();
        Individual sub = workModel.createIndividual("uri1", A);
        Individual obj = workModel.createIndividual("uri2", A);
        workModel.createStatement((Resource)sub, (Property)p, obj);
    }

    public void test_ck_03() {
        OntModel model1 = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null);
        OntModel model2 = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RULE_INF, null);
        Individual sub = model1.createIndividual("http://mytest#i1", model1.getProfile().CLASS());
        OntProperty pred = model1.createOntProperty("http://mytest#");
        Individual obj = model1.createIndividual("http://mytest#i2", model1.getProfile().CLASS());
        OntProperty probabilityP = model1.createOntProperty("http://mytest#prob");
        Statement st = model1.createStatement((Resource)sub, (Property)pred, obj);
        model1.add(st);
        st.createReifiedStatement().addProperty((Property)probabilityP, 0.9);
        TestBugReports.assertTrue("st should be reified", st.isReified());
        Statement st2 = model2.createStatement((Resource)sub, (Property)pred, obj);
        model2.add(st2);
        st2.createReifiedStatement().addProperty((Property)probabilityP, 0.3);
        TestBugReports.assertTrue("st2 should be reified", st2.isReified());
        sub.addProperty((Property)probabilityP, 0.3);
        sub.removeAll(probabilityP).addProperty((Property)probabilityP, 0.3);
        Individual sub2 = model2.createIndividual("http://mytest#i1", model1.getProfile().CLASS());
        sub.addProperty((Property)probabilityP, 0.3);
        sub.removeAll(probabilityP);
        sub2.addProperty((Property)probabilityP, 0.3);
        sub2.removeAll(probabilityP);
    }

    public void test_sjooseng_01() {
        String source = "<rdf:RDF xmlns:daml='http://www.daml.org/2001/03/daml+oil#'    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' >    <daml:Class rdf:about='http://localhost:8080/kc2c#C1'>        <daml:subClassOf>            <daml:Restriction>                <daml:onProperty rdf:resource='http://localhost:8080/kc2c#p1'/>                <daml:hasClass>                    <daml:Class>                        <daml:oneOf rdf:parseType=\"daml:collection\">                            <daml:Thing rdf:about='http://localhost:8080/kc2c#i1'/>                            <daml:Thing rdf:about='http://localhost:8080/kc2c#i2'/>                        </daml:oneOf>                    </daml:Class>                </daml:hasClass>            </daml:Restriction>        </daml:subClassOf>    </daml:Class>    <daml:ObjectProperty rdf:about='http://localhost:8080/kc2c#p1'>        <rdfs:label>p1</rdfs:label>    </daml:ObjectProperty></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel("http://www.daml.org/2001/03/daml+oil#");
        m.read(new ByteArrayInputStream(source.getBytes()), "http://localhost:8080/kc2c");
        OntClass kc1 = m.getOntClass("http://localhost:8080/kc2c#C1");
        boolean found = false;
        ExtendedIterator it = kc1.listSuperClasses(false);
        while (it.hasNext()) {
            SomeValuesFromRestriction sr;
            OntClass sc;
            Restriction r;
            OntClass oc = (OntClass)it.next();
            if (!oc.isRestriction() || !(r = oc.asRestriction()).isSomeValuesFromRestriction() || !(sc = (OntClass)(sr = r.asSomeValuesFromRestriction()).getSomeValuesFrom()).isEnumeratedClass()) continue;
            EnumeratedClass ec = sc.asEnumeratedClass();
            TestBugReports.assertEquals("Enumeration size should be 2", 2, ec.getOneOf().size());
            found = true;
        }
        TestBugReports.assertTrue(found);
    }

    public void test_afs_01() {
        String sourceT = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'   xmlns:owl=\"http://www.w3.org/2002/07/owl#\">    <owl:Class rdf:about='http://example.org/foo#A'>   </owl:Class></rdf:RDF>";
        String sourceA = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl=\"http://www.w3.org/2002/07/owl#\">    <rdf:Description rdf:about='http://example.org/foo#x'>    <rdf:type rdf:resource='http://example.org/foo#A' />   </rdf:Description></rdf:RDF>";
        Model tBox = ModelFactory.createDefaultModel();
        tBox.read(new ByteArrayInputStream(sourceT.getBytes()), "http://example.org/foo");
        Model aBox = ModelFactory.createDefaultModel();
        aBox.read(new ByteArrayInputStream(sourceA.getBytes()), "http://example.org/foo");
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        reasoner = reasoner.bindSchema(tBox);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM_RULE_INF);
        spec.setReasoner(reasoner);
        OntModel m = ModelFactory.createOntologyModel(spec, aBox);
        ArrayList inds = new ArrayList();
        ExtendedIterator i = m.listIndividuals();
        while (i.hasNext()) {
            inds.add(i.next());
        }
        TestBugReports.assertTrue("x should be an individual", inds.contains(m.getResource("http://example.org/foo#x")));
    }

    public void test_to_01() {
        String sourceT = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:daml='http://www.daml.org/2001/03/daml+oil#'>  <daml:Class rdf:about='http://example.org/foo#A'>    <daml:intersectionOf rdf:parseType=\"daml:collection\">       <daml:Class rdf:ID=\"B\" />       <daml:Class rdf:ID=\"C\" />    </daml:intersectionOf>  </daml:Class></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null);
        m.read(new ByteArrayInputStream(sourceT.getBytes()), "http://example.org/foo");
        OntClass A = m.getOntClass("http://example.org/foo#A");
        TestBugReports.assertNotNull(A);
        IntersectionClass iA = A.asIntersectionClass();
        TestBugReports.assertNotNull(iA);
        RDFList intersection = iA.getOperands();
        TestBugReports.assertNotNull(intersection);
        TestBugReports.assertEquals(2, intersection.size());
        TestBugReports.assertTrue(intersection.contains(m.getOntClass("http://example.org/foo#B")));
        TestBugReports.assertTrue(intersection.contains(m.getOntClass("http://example.org/foo#C")));
    }

    public void test_tl_01() {
        Resource r;
        String sourceT = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl=\"http://www.w3.org/2002/07/owl#\">   <owl:SymmetricProperty rdf:about='http://example.org/foo#p1'>   </owl:SymmetricProperty>   <owl:TransitiveProperty rdf:about='http://example.org/foo#p2'>   </owl:TransitiveProperty>   <owl:InverseFunctionalProperty rdf:about='http://example.org/foo#p3'>   </owl:InverseFunctionalProperty></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        m.read(new ByteArrayInputStream(sourceT.getBytes()), "http://example.org/foo");
        boolean foundP1 = false;
        boolean foundP2 = false;
        boolean foundP3 = false;
        ExtendedIterator i = m.listOntProperties();
        while (i.hasNext()) {
            r = (Resource)i.next();
            foundP1 = foundP1 || r.getURI().equals("http://example.org/foo#p1");
            foundP2 = foundP2 || r.getURI().equals("http://example.org/foo#p2");
            foundP3 = foundP3 || r.getURI().equals("http://example.org/foo#p3");
        }
        TestBugReports.assertTrue("p1 not listed", foundP1);
        TestBugReports.assertTrue("p2 not listed", foundP2);
        TestBugReports.assertTrue("p3 not listed", foundP3);
        foundP1 = false;
        foundP2 = false;
        foundP3 = false;
        i = m.listObjectProperties();
        while (i.hasNext()) {
            r = (Resource)i.next();
            foundP1 = foundP1 || r.getURI().equals("http://example.org/foo#p1");
            foundP2 = foundP2 || r.getURI().equals("http://example.org/foo#p2");
            foundP3 = foundP3 || r.getURI().equals("http://example.org/foo#p3");
        }
        TestBugReports.assertTrue("p1 not listed", foundP1);
        TestBugReports.assertTrue("p2 not listed", foundP2);
        TestBugReports.assertTrue("p3 not listed", foundP3);
    }

    public void test_der_01() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM_TRANS_INF, null);
        Resource a = m.createResource("http://example.org#A");
        Resource b = m.createResource("http://example.org#B");
        OntClassImpl A = new OntClassImpl(a.asNode(), (EnhGraph)((Object)m)){

            protected boolean hasSuperClassDirect(Resource cls) {
                throw new RuntimeException("did not find direct reasoner");
            }
        };
        A.hasSuperClass(b, true);
    }

    public void test_if_01() {
        OntModel m = ModelFactory.createOntologyModel();
        m.getDocumentManager().addAltEntry("http://www.w3.org/2001/sw/WebOnt/guide-src/wine", "file:testing/ontology/bugs/oldwine.owl");
        m.getDocumentManager().addAltEntry("http://www.w3.org/2001/sw/WebOnt/guide-src/food", "file:testing/ontology/bugs/oldfood.owl");
        m.getDocumentManager().setProcessImports(false);
        m.read("http://www.w3.org/2001/sw/WebOnt/guide-src/wine");
        m.getDocumentManager().setProcessImports(true);
        m.getDocumentManager().loadImport(m, "http://www.w3.org/2001/sw/WebOnt/guide-src/food");
        OntClass ontclass = m.getOntClass("http://www.w3.org/2001/sw/WebOnt/guide-src/wine#Wine");
        int nNamed = 0;
        int nRestriction = 0;
        int nAnon = 0;
        ExtendedIterator iter2 = ontclass.listSuperClasses(true);
        while (iter2.hasNext()) {
            OntClass ontsuperclass = (OntClass)iter2.next();
            if (!ontsuperclass.isAnon()) {
                ++nNamed;
                continue;
            }
            if (ontsuperclass.canAs(class$com$hp$hpl$jena$ontology$Restriction == null ? TestBugReports.class$("com.hp.hpl.jena.ontology.Restriction") : class$com$hp$hpl$jena$ontology$Restriction)) {
                ontsuperclass.asRestriction();
                ++nRestriction;
                continue;
            }
            ++nAnon;
        }
        TestBugReports.assertEquals("Should be two named super classes ", 2, nNamed);
        TestBugReports.assertEquals("Should be nine named super classes ", 9, nRestriction);
        TestBugReports.assertEquals("Should be no named super classes ", 0, nAnon);
    }

    public void test_lt_01() {
        OntModel m = ModelFactory.createOntologyModel();
        DatatypeProperty p = m.createDatatypeProperty(NS + "p");
        OntClass c = m.createClass(NS + "A");
        Individual i = m.createIndividual(NS + "i", c);
        i.addProperty((Property)p, "testData");
        int count = 0;
        NodeIterator j = i.listPropertyValues(p);
        while (j.hasNext()) {
            j.next();
            ++count;
        }
        TestBugReports.assertEquals("i should have one property", 1, count);
    }

    public void test_dk_01() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/bugs/test_dk_01.xml");
        String NS = "http://localhost:8080/Repository/QueryAgent/UserOntology/qgen-example-1#";
        String[] classes = new String[]{NS + "C1", NS + "C3", NS + "C2"};
        for (int i = 0; i < classes.length; ++i) {
            OntClass c = m.getOntClass(classes[i]);
            ExtendedIterator j = c.listDeclaredProperties();
            while (j.hasNext()) {
                j.next();
            }
        }
    }

    public void test_ppds_01() {
        DAMLModel m = ModelFactory.createDAMLModel();
        DAMLClass c = m.createDAMLClass(NS + "C");
        DAMLInstance x = m.createDAMLInstance(c, NS + "x");
        DAMLProperty p = m.createDAMLProperty(NS + "p");
        x.addProperty((Property)p, "(s (s 0))");
        PropertyAccessor a = x.accessProperty(p);
        TestBugReports.assertNull("Property accessor value should be null", a.getDAMLValue());
    }

    public void test_anon_0() {
        String NS = "http://example.org/foo#";
        String sourceT = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:ex='http://example.org/foo#'    xmlns:owl='http://www.w3.org/2002/07/owl#'>   <owl:ObjectProperty rdf:about='http://example.org/foo#p' />   <owl:Class rdf:about='http://example.org/foo#A' />   <ex:A rdf:about='http://example.org/foo#x' />   <owl:Class rdf:about='http://example.org/foo#B'>     <owl:equivalentClass>      <owl:Restriction>        <owl:onProperty rdf:resource='http://example.org/foo#p' />        <owl:hasValue rdf:resource='http://example.org/foo#x' />      </owl:Restriction>     </owl:equivalentClass>   </owl:Class></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        m.read(new ByteArrayInputStream(sourceT.getBytes()), "http://example.org/foo");
        OntClass B = m.getOntClass(NS + "B");
        Restriction r = B.getEquivalentClass().asRestriction();
        HasValueRestriction hvr = r.asHasValueRestriction();
        RDFNode n = hvr.getHasValue();
        TestBugReports.assertTrue("Should be an individual", n instanceof Individual);
    }

    public void test_zj_0() {
        String NS = "file:/C:/orel/orel0_5.owl#";
        String sourceT = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:ex='http://example.org/foo#'    xmlns:owl='http://www.w3.org/2002/07/owl#'      xmlns:orel='file:/C:/orel/orel0_5.owl#'      xml:base='file:/C:/orel/orel0_5.owl#'      xmlns='file:/C:/orel/orel0_5.owl#'> <owl:ObjectProperty rdf:ID='hasAgent' /> <owl:ObjectProperty rdf:ID='hasResource' /> <owl:Class rdf:ID='MyPlay'>    <rdfs:subClassOf>      <owl:Restriction>        <owl:onProperty rdf:resource='file:/C:/orel/orel0_5.owl#hasResource'/>        <owl:hasValue>          <orel:Resource rdf:ID='myResource'>            <orel:resourceURI>http://mp3.com/newcd/sample.mp3</orel:resourceURI>          </orel:Resource>        </owl:hasValue>      </owl:Restriction>    </rdfs:subClassOf>    <rdfs:subClassOf rdf:resource='http://www.w3.org/2002/07/owl#Thing'/>    <rdfs:subClassOf>      <owl:Restriction>        <owl:onProperty rdf:resource='file:/C:/orel/orel0_5.owl#hasAgent'/>        <owl:hasValue>          <orel:Agent rdf:ID='myAgent'>            <orel:agentPK>123456789</orel:agentPK>          </orel:Agent>        </owl:hasValue>      </owl:Restriction>    </rdfs:subClassOf>    <rdfs:subClassOf rdf:resource='file:/C:/orel/orel0_5.owl#Play'/>  </owl:Class></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        m.read(new ByteArrayInputStream(sourceT.getBytes()), "file:/C:/orel/orel0_5.owl");
        OntClass myPlay = m.getOntClass(NS + "MyPlay");
        ExtendedIterator i = myPlay.listDeclaredProperties();
        while (i.hasNext()) {
            i.next();
        }
    }

    public void test_ej_01() {
        String BASE = "http://jena.hpl.hp.com/testing/ontology";
        String NS = BASE + "#";
        DAMLModel m = ModelFactory.createDAMLModel();
        DAMLClass A = m.createDAMLClass(NS + "A");
        DAMLClass B = m.createDAMLClass(NS + "B");
        DAMLClass C2 = m.createDAMLClass(NS + "C");
        DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C2});
        TestBugReports.assertTrue(l.isValid());
        Model baseModel = m.getBaseModel();
        RDFWriter writer = baseModel.getWriter("RDF/XML-ABBREV");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.write(baseModel, out, BASE);
    }

    public void test_hc_01() throws Exception {
        for (int i = 0; i < 5; ++i) {
            OntModel m = ModelFactory.createOntologyModel();
            FileInputStream ifs = new FileInputStream("testing/ontology/relativenames.rdf");
            m.read(ifs, "http://example.org/foo");
            ifs.close();
            m.close();
        }
    }

    public void test_sb_01() {
        OntModel model = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RDFS_INF, null);
        OntResource result = null;
        Resource nullValueForResourceType = null;
        result = model.createOntResource(OntResource.class, nullValueForResourceType, "http://www.somewhere.com/models#SomeResourceName");
        TestBugReports.assertNotNull(result);
    }

    public void test_der_02() {
        String SOURCE = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF xmlns:owl ='&owl;' xmlns:rdf='&rdf;' xmlns:rdfs='&rdfs;' xmlns:dc='&dc;' xmlns='&base;#' xml:base='&base;'>  <owl:ObjectProperty rdf:ID='hasPublications'>    <rdfs:domain>      <owl:Class>        <owl:unionOf rdf:parseType='Collection'>          <owl:Class rdf:about='#Project'/>          <owl:Class rdf:about='#Task'/>        </owl:unionOf>      </owl:Class>    </rdfs:domain>    <rdfs:domain rdf:resource='#Dummy' />    <rdfs:range rdf:resource='#Publications'/>  </owl:ObjectProperty>  <owl:Class rdf:ID='Dummy'>  </owl:Class></rdf:RDF>";
        String NS = "http://jena.hpl.hp.com/test#";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_MICRO_RULE_INF, null);
        m.read(new ByteArrayInputStream(SOURCE.getBytes()), NS);
    }

    public void test_der_03() {
        String NS = "http://jena.hpl.hp.com/test#";
        OntModel om = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass A = om.createClass(NS + "A");
        OntClass B = om.createClass(NS + "B");
        OntClass C2 = om.createClass(NS + "C");
        A.addSuperClass(B);
        A.addSuperClass(C2);
        B.addSuperClass(C2);
        C2.addSuperClass(B);
        TestUtil.assertIteratorValues(this, A.listSuperClasses(true), new Object[]{B, C2});
    }

    public void test_pd_01() {
        String SOURCE = "<?xml version='1.0'?><rdf:RDF    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl='http://www.w3.org/2002/07/owl#'    xml:base='http://iasi.cnr.it/leks/localSchema1#'    xmlns:test='http://iasi.cnr.it/test/test1#'    xmlns='http://iasi.cnr.it/test/test1#'>    <owl:Ontology rdf:about=''/>    <owl:Class rdf:ID='Hotel'/>    <owl:Class rdf:ID='Hotel5Stars'>        <rdfs:subClassOf>            <owl:Restriction>                <owl:onProperty rdf:resource='#hasCategory'/>                <owl:hasValue rdf:resource='#Category5'/>            </owl:Restriction>        </rdfs:subClassOf>    </owl:Class>    <owl:DatatypeProperty rdf:ID='hasCategory'>        <rdfs:range rdf:resource='http://www.w3.org/2001/XMLSchema#string'/>        <rdfs:domain rdf:resource='#Hotel'/>        <rdf:type rdf:resource='http://www.w3.org/2002/07/owl#FunctionalProperty'/>    </owl:DatatypeProperty>    <owl:Thing rdf:ID='Category5'/></rdf:RDF>";
        String NS = "http://iasi.cnr.it/leks/localSchema1#";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM, null);
        m.read(new ByteArrayInputStream(SOURCE.getBytes()), NS);
        ExtendedIterator j = m.listRestrictions();
        while (j.hasNext()) {
            Restriction r = (Restriction)j.next();
            if (!r.isHasValueRestriction()) continue;
            HasValueRestriction hv = r.asHasValueRestriction();
            ((Object)hv.getHasValue()).toString();
        }
    }

    public void xxtest_oh_01() {
        String NS = "http://www.idi.ntnu.no/~herje/ja/";
        Resource[] expected = new Resource[]{ResourceFactory.createResource(NS + "reiseliv.owl#Reiseliv"), ResourceFactory.createResource(NS + "hotell.owl#Hotell"), ResourceFactory.createResource(NS + "restaurant.owl#Restaurant"), ResourceFactory.createResource(NS + "restaurant.owl#UteRestaurant"), ResourceFactory.createResource(NS + "restaurant.owl#UteBadRestaurant"), ResourceFactory.createResource(NS + "restaurant.owl#UteDoRestaurant"), ResourceFactory.createResource(NS + "restaurant.owl#SkogRestaurant")};
        this.test_oh_01scan(OntModelSpec.OWL_MEM, "No inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_MINI_RULE_INF, "Mini rule inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_RULE_INF, "Full rule inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_MICRO_RULE_INF, "Micro rule inf", expected);
    }

    private void test_oh_01scan(OntModelSpec s, String prompt, Resource[] expected) {
        String NS = "http://www.idi.ntnu.no/~herje/ja/reiseliv.owl#";
        OntModel m = ModelFactory.createOntologyModel(s, null);
        m.read("file:testing/ontology/bugs/test_oh_01.owl");
        System.out.println(prompt);
        OntClass r = m.getOntClass(NS + "Reiseliv");
        ArrayList<OntClass> q = new ArrayList<OntClass>();
        HashSet<OntClass> seen = new HashSet<OntClass>();
        q.add(r);
        while (!q.isEmpty()) {
            OntClass c = (OntClass)q.remove(0);
            seen.add(c);
            ExtendedIterator i = c.listSubClasses(true);
            while (i.hasNext()) {
                OntClass sub = (OntClass)i.next();
                if (seen.contains(sub)) continue;
                q.add(sub);
            }
            System.out.println("  Seen class " + c);
        }
        int mask = (1 << expected.length) - 1;
        for (int j = 0; j < expected.length; ++j) {
            if (seen.contains(expected[j])) {
                mask &= ~(1 << j);
                continue;
            }
            System.out.println("Expected but did not see " + expected[j]);
        }
        Iterator k = seen.iterator();
        while (k.hasNext()) {
            Resource res = (Resource)k.next();
            boolean isExpected = false;
            for (int j = 0; !isExpected && j < expected.length; ++j) {
                isExpected = ((Object)expected[j]).equals(res);
            }
            if (isExpected) continue;
            System.out.println("Got unexpected result " + res);
        }
        TestBugReports.assertEquals("Some expected results were not seen", 0, mask);
    }

    public void test_sf_927641() {
        String NS = "http://example.org/test#";
        OntModel m0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass c0 = m0.createClass(NS + "C0");
        OntClass c1 = m0.createClass(NS + "C1");
        OntClass c2 = m0.createClass(NS + "C2");
        OntClass c3 = m0.createClass(NS + "C3");
        c0.addSubClass(c1);
        c1.addSubClass(c2);
        c2.addEquivalentClass(c3);
        TestBugReports.assertFalse("pass 1: c0 should not be a direct super of c2", c2.hasSuperClass(c0, true));
        TestBugReports.assertFalse("pass 1: c3 should not be a direct super of c2", c2.hasSuperClass(c3, true));
        TestBugReports.assertFalse("pass 1: c2 should not be a direct super of c2", c2.hasSuperClass(c2, true));
        TestBugReports.assertTrue("pass 1: c1 should be a direct super of c2", c2.hasSuperClass(c1, true));
        m0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF);
        c0 = m0.createClass(NS + "C0");
        c1 = m0.createClass(NS + "C1");
        c2 = m0.createClass(NS + "C2");
        c3 = m0.createClass(NS + "C3");
        c0.addSubClass(c1);
        c1.addSubClass(c2);
        c2.addEquivalentClass(c3);
        TestBugReports.assertFalse("pass 2: c0 should not be a direct super of c2", c2.hasSuperClass(c0, true));
        TestBugReports.assertFalse("pass 2: c3 should not be a direct super of c2", c2.hasSuperClass(c3, true));
        TestBugReports.assertFalse("pass 2: c2 should not be a direct super of c2", c2.hasSuperClass(c2, true));
        TestBugReports.assertTrue("pass 2: c1 should be a direct super of c2", c2.hasSuperClass(c1, true));
    }

    public void test_sf_934528() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        Resource r = (Resource)OWL.Thing.inModel(m);
        OntClass thingClass = (OntClass)r.as(OntClass.class);
        TestBugReports.assertNotNull(thingClass);
        r = (Resource)OWL.Nothing.inModel(m);
        OntClass nothingClass = (OntClass)r.as(OntClass.class);
        TestBugReports.assertNotNull(nothingClass);
        OntClass c = m.getOntClass(OWL.Thing.getURI());
        TestBugReports.assertNotNull(c);
        TestBugReports.assertEquals(c, OWL.Thing);
        c = m.getOntClass(OWL.Nothing.getURI());
        TestBugReports.assertNotNull(c);
        TestBugReports.assertEquals(c, OWL.Nothing);
    }

    public void test_sf_937810() throws IllegalAccessException {
        Field[] specs = OntModelSpec.class.getDeclaredFields();
        for (int i = 0; i < specs.length; ++i) {
            if (!Modifier.isPublic(specs[i].getModifiers()) || !Modifier.isStatic(specs[i].getModifiers()) || !specs[i].getType().equals(class$com$hp$hpl$jena$ontology$OntModelSpec == null ? TestBugReports.class$("com.hp.hpl.jena.ontology.OntModelSpec") : class$com$hp$hpl$jena$ontology$OntModelSpec)) continue;
            OntModelSpec s = (OntModelSpec)specs[i].get(null);
            TestBugReports.assertNotNull(s.getDescription());
        }
    }

    public void test_sf_940570() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass C2 = m.createClass(NS + "C");
        Resource a = m.createResource(NS + "a", C2);
        TestUtil.assertIteratorValues(this, m.listIndividuals(), new Object[]{a});
        OntModel dm = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RULE_INF);
        OntClass D = dm.createClass(NS + "D");
        Resource b = dm.createResource(NS + "b", D);
        TestUtil.assertIteratorValues(this, dm.listIndividuals(), new Object[]{b});
    }

    public void test_sf_940570_rdfs() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass C2 = m.createClass(NS + "C");
        Resource a = m.createResource(NS + "a", C2);
        TestUtil.assertIteratorValues(this, m.listIndividuals(), new Object[]{a});
    }

    public void test_sf_940570_daml() {
        OntModel dm = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RULE_INF);
        OntClass D = dm.createClass(NS + "D");
        Resource b = dm.createResource(NS + "b", D);
        TestUtil.assertIteratorValues(this, dm.listIndividuals(), new Object[]{b});
    }

    public void test_sf_945436() {
        String SOURCE = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF xmlns:owl ='&owl;' xmlns:rdf='&rdf;' xmlns:rdfs='&rdfs;' xmlns:dc='&dc;' xmlns='&base;#' xml:base='&base;'>  <C rdf:ID='x'>    <rdfs:label xml:lang=''>a_label</rdfs:label>  </C>  <owl:Class rdf:ID='C'>  </owl:Class></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        m.read(new StringReader(SOURCE), null);
        Individual x = m.getIndividual("http://jena.hpl.hp.com/test#x");
        TestBugReports.assertEquals("Label on resource x", "a_label", x.getLabel(null));
        TestBugReports.assertEquals("Label on resource x", "a_label", x.getLabel(""));
        TestBugReports.assertSame("fr label on resource x", null, x.getLabel("fr"));
    }

    public void test_sf_948995() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
        DatatypeProperty dp = m.createDatatypeProperty(NS + "dp");
        dp.addRDFType(OWL.InverseFunctionalProperty);
        boolean ex = false;
        try {
            dp.as(InverseFunctionalProperty.class);
        }
        catch (ConversionException e2) {
            ex = true;
        }
        TestBugReports.assertTrue("Should have been a conversion exception", ex);
        m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        dp = m.createDatatypeProperty(NS + "dp");
        dp.addRDFType(OWL.InverseFunctionalProperty);
        ex = false;
        try {
            dp.as(InverseFunctionalProperty.class);
        }
        catch (ConversionException e3) {
            ex = true;
        }
        TestBugReports.assertFalse("Should not have been a conversion exception", ex);
    }

    public void test_sf_969475() {
        String SOURCE = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF xmlns:owl ='&owl;' xmlns:rdf='&rdf;' xmlns:rdfs='&rdfs;' xmlns:dc='&dc;' xmlns='&base;#' xml:base='&base;'>  <owl:ObjectProperty rdf:ID='p0'>    <owl:inverseOf>      <owl:ObjectProperty rdf:ID='q0' />    </owl:inverseOf>  </owl:ObjectProperty>  <owl:ObjectProperty rdf:ID='p1'>    <owl:inverseOf>      <owl:ObjectProperty rdf:ID='q1' />    </owl:inverseOf>  </owl:ObjectProperty></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        m.read(new StringReader(SOURCE), null);
        ObjectProperty p0 = m.getObjectProperty("http://jena.hpl.hp.com/test#p0");
        OntProperty invP0 = p0.getInverseOf();
        TestBugReports.assertEquals(m.getResource("http://jena.hpl.hp.com/test#q0"), invP0);
        TestBugReports.assertTrue("Should be an ObjectProperty facet", invP0 instanceof ObjectProperty);
        ObjectProperty q1 = m.getObjectProperty("http://jena.hpl.hp.com/test#q1");
        OntProperty invQ1 = q1.getInverse();
        TestBugReports.assertEquals(m.getResource("http://jena.hpl.hp.com/test#p1"), invQ1);
        TestBugReports.assertTrue("Should be an ObjectProperty facet", invQ1 instanceof ObjectProperty);
    }

    public void test_sf_978259() {
        OntModel md = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
        OntModel ml = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM);
        DataRange drd = md.createDataRange(md.createList(new Resource[]{OWL.Thing}));
        TestBugReports.assertNotNull(drd);
        HasValueRestriction hvrd = md.createHasValueRestriction(null, RDFS.seeAlso, OWL.Thing);
        TestBugReports.assertNotNull(hvrd);
        boolean ex = false;
        try {
            drd = ml.createDataRange(md.createList(new Resource[]{OWL.Thing}));
        }
        catch (ProfileException e2) {
            ex = true;
        }
        TestBugReports.assertTrue(ex);
        ex = false;
        try {
            hvrd = ml.createHasValueRestriction(null, RDFS.seeAlso, OWL.Thing);
        }
        catch (ProfileException e3) {
            ex = true;
        }
        TestBugReports.assertTrue(ex);
    }

    public void test_jb_01() {
        Model schema = ModelFactory.createDefaultModel();
        Model data = ModelFactory.createDefaultModel();
        Resource c = schema.createResource("http://example.com/foo#AClass");
        Resource i = data.createResource("http://example.com/foo#anInd");
        schema.add(c, RDF.type, OWL.Class);
        data.add(i, RDF.type, c);
        OntModel composite = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, schema);
        composite.addSubModel(data);
        Set s = composite.listIndividuals().toSet();
        TestBugReports.assertEquals("should be one individual", 1, s.size());
        TestBugReports.assertTrue(s.contains(i));
    }

    public void test_jt_01() {
        Model cModel = ModelFactory.createDefaultModel();
        Resource conf = cModel.createResource();
        conf.addProperty(ReasonerVocabulary.EXT_REASONER_URL, cModel.createResource("http://localhost:2004"));
        DIGReasonerFactory drf = (DIGReasonerFactory)ReasonerRegistry.theRegistry().getFactory("http://jena.hpl.hp.com/2003/DIGReasoner");
        DIGReasoner r = (DIGReasoner)drf.create(conf);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner(r);
        OntModel m = ModelFactory.createOntologyModel(spec, null);
        boolean ex = false;
        try {
            ExtendedIterator i = m.listIndividuals();
            System.out.println(i.hasNext());
        }
        catch (DIGWrappedException e2) {
            ex = true;
        }
        TestBugReports.assertTrue("Should have seen a dig wrapped exception for connection fail", ex);
    }

    public void test_dab_01() {
        OntModel m0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass c0 = m0.createClass(NS + "c0");
        ObjectProperty p0 = m0.createObjectProperty(NS + "p0");
        p0.setDomain(c0);
        OntModel m1 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass c1 = m1.createClass(NS + "c1");
        c1.addSuperClass(c0);
        m1.addSubModel(m0);
        OntClass cc0 = m1.getOntClass(NS + "c0");
        TestBugReports.assertNotNull(cc0);
        TestUtil.assertIteratorValues(this, c1.listDeclaredProperties(), new Object[]{p0});
        TestUtil.assertIteratorValues(this, c0.listDeclaredProperties(false), new Object[]{p0});
        TestUtil.assertIteratorValues(this, cc0.listDeclaredProperties(false), new Object[]{p0});
    }

    public void test_dab_02a() {
        String SOURCEA = "<rdf:RDF    xmlns:rdf          ='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:owl          ='http://www.w3.org/2002/07/owl#'    xml:base           ='http://example.com/a#'><rdf:Description>  <owl:unionOf   rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/> </rdf:Description></rdf:RDF>";
        OntModel a0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        a0.read(new StringReader(SOURCEA), null);
        ExtendedIterator i = a0.listUnionClasses();
        while (i.hasNext()) {
            i.next();
        }
        OntModel a1 = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
        a1.read(new StringReader(SOURCEA), null);
        ExtendedIterator i2 = a1.listUnionClasses();
        while (i2.hasNext()) {
            i2.next();
        }
    }

    public void test_dab_02b() {
        String SOURCEA = "<rdf:RDF    xmlns:rdf          ='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:owl          ='http://www.w3.org/2002/07/owl#'    xml:base           ='http://example.com/a#'><rdf:Description>  <owl:intersectionOf   rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/> </rdf:Description></rdf:RDF>";
        OntModel a0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        a0.read(new StringReader(SOURCEA), null);
        ExtendedIterator i = a0.listIntersectionClasses();
        while (i.hasNext()) {
            i.next();
        }
        OntModel a1 = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
        a1.read(new StringReader(SOURCEA), null);
        ExtendedIterator i2 = a1.listIntersectionClasses();
        while (i2.hasNext()) {
            i2.next();
        }
        OntModel a2 = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM);
        a2.read(new StringReader(SOURCEA), null);
        ExtendedIterator i3 = a2.listIntersectionClasses();
        while (i3.hasNext()) {
            i3.next();
        }
    }

    public void test_dab_02c() {
        String SOURCEA = "<rdf:RDF    xmlns:rdf          ='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:owl          ='http://www.w3.org/2002/07/owl#'    xml:base           ='http://example.com/a#'><rdf:Description>  <owl:complementOf   rdf:resource='http://www.w3.org/2002/07/owl#Nothing'/> </rdf:Description></rdf:RDF>";
        OntModel a0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        a0.read(new StringReader(SOURCEA), null);
        ExtendedIterator i = a0.listComplementClasses();
        while (i.hasNext()) {
            i.next();
        }
        OntModel a1 = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
        a1.read(new StringReader(SOURCEA), null);
        ExtendedIterator i2 = a1.listComplementClasses();
        while (i2.hasNext()) {
            i2.next();
        }
    }

    public void test_on_01() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM);
        Individual i = m.createIndividual(DAML_OIL.Thing);
        TestBugReports.assertTrue(i.isIndividual());
    }

    public void test_kers_01() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM);
        OntClass r = m.createClass(NS + "r");
        OntClass a = m.createClass(NS + "a");
        OntClass b = m.createClass(NS + "b");
        OntClass c = m.createClass(NS + "c");
        OntClass d = m.createClass(NS + "d");
        OntClass e2 = m.createClass(NS + "e");
        OntClass f = m.createClass(NS + "f");
        OntClass g = m.createClass(NS + "g");
        g.addSuperClass(c);
        f.addSuperClass(c);
        e2.addSuperClass(b);
        d.addSuperClass(b);
        c.addSuperClass(a);
        b.addSuperClass(a);
        r.addSubClass(a);
        r.addSubClass(b);
        r.addSubClass(c);
        r.addSubClass(d);
        r.addSubClass(e2);
        r.addSubClass(f);
        r.addSubClass(g);
        TestUtil.assertIteratorValues(this, r.listSubClasses(true), new Object[]{a});
    }

    public void test_kers_02() {
        OntModel A = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        Model B = ModelFactory.createDefaultModel();
        TestBugReports.assertTrue(A.getGraph().queryHandler() instanceof SimpleQueryHandler);
        TestBugReports.assertTrue(B.getGraph().queryHandler() instanceof GraphMemFasterQueryHandler);
        TestBugReports.assertTrue(A.getBaseModel().getGraph().queryHandler() instanceof GraphMemFasterQueryHandler);
    }

    public void test_am_01() {
        OntModel m0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntModel m1 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass c = m1.createClass(NS + "c");
        TestBugReports.assertFalse(m0.containsResource(c));
        m0.addSubModel(m1);
        TestBugReports.assertTrue(m0.containsResource(c));
        m0.removeSubModel(m1);
        TestBugReports.assertFalse(m0.containsResource(c));
    }

    public void test_am_02() {
        OntDocumentManager.getInstance().setProcessImports(false);
        OntDocumentManager.getInstance().addAltEntry("http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine", "file:testing/ontology/owl/Wine/wine.owl");
        OntModel m0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        OntModel m1 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        String namespace2 = "http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine";
        String classURI = namespace2 + "#Wine";
        m1.read(namespace2);
        OntClass c = m1.getOntClass(classURI);
        TestBugReports.assertFalse(m0.containsResource(c));
        m0.addSubModel(m1);
        TestBugReports.assertTrue(m0.containsResource(c));
        m0.removeSubModel(m1);
        TestBugReports.assertFalse(m0.containsResource(c));
    }

    public void test_am_03() {
        OntModel m0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntModel m1 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass c = m1.createClass(NS + "c");
        TestBugReports.assertFalse(m0.containsResource(c));
        m0.addSubModel(m1);
        TestBugReports.assertTrue(m0.containsResource(c));
        m0.removeSubModel(m1);
        TestBugReports.assertFalse(m0.containsResource(c));
    }

    public void test_am_04() {
        OntModel m0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RDFS_INF);
        OntModel m1 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass c = m1.createClass(NS + "c");
        TestBugReports.assertFalse(m0.containsResource(c));
        m0.addSubModel(m1);
        TestBugReports.assertTrue(m0.containsResource(c));
        m0.removeSubModel(m1);
        TestBugReports.assertFalse(m0.containsResource(c));
    }

    public void testHolgersPolyadicPrefixMappingBug() {
        String IMPORTED_NAMESPACE = "http://imported#";
        String LOCAL_NAMESPACE = "http://local#";
        Model importedModel = ModelFactory.createDefaultModel();
        importedModel.setNsPrefix("", "http://imported#");
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.setNsPrefix("", "http://local#");
        ontModel.addSubModel(importedModel);
        TestBugReports.assertNull(ontModel.getNsURIPrefix("http://imported#"));
    }

    public void test_tina_01() {
        String rule = "(?x rdf:type rdfs:Class) -> (?x rdf:type owl:Class).";
        GenericRuleReasoner reasoner = new GenericRuleReasoner(Rule.parseRules(rule));
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(reasoner);
        OntModel ml = ModelFactory.createOntologyModel(spec, null);
        ExtendedIterator it3 = ml.listHierarchyRootClasses();
        while (it3.hasNext()) {
            it3.next();
        }
    }

    public void test_mongolito_01() {
        String SOURCEA = "<rdf:RDF    xmlns:rdf          ='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:owl          ='http://www.w3.org/2002/07/owl#'    xml:base           ='http://example.com/a#'>  <owl:Ontology>          <owl:imports rdf:resource='http://example.com/b' />  </owl:Ontology></rdf:RDF>";
        OntDocumentManager.getInstance().addAltEntry("http://example.com/b", "file:testing/ontology/bugs/test_dk_01.xml");
        OntModel a0 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        a0.read(new StringReader(SOURCEA), null);
        long a0count = a0.size();
        OntDocumentManager.getInstance().getModel("http://example.com/b").close();
        OntModel a1 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        a1.read(new StringReader(SOURCEA), null);
        TestBugReports.assertEquals("Models should be same size", a0count, a1.size());
    }

    public void test_isindividual() {
        OntModel defModel = ModelFactory.createOntologyModel();
        OntClass c = defModel.createClass("http://example.com/test#A");
        Individual i = c.createIndividual();
        TestBugReports.assertTrue("i should be an individual", i.isIndividual());
    }

    public void test_getClassOwlLite() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM);
        OntClass c = m.getOntClass("http://example.com/foo");
    }

    public void xxtestModelMakerOpen() {
        ModelMaker mm = ModelFactory.createMemModelMaker();
        Model m = mm.openModel("http://example.com/foo");
        TestBugReports.assertTrue(m.isEmpty());
        m.close();
        boolean closed = false;
        Model m0 = mm.openModel("http://example.com/foo");
        try {
            TestBugReports.assertTrue(m0.isEmpty());
        }
        catch (ClosedException unexpected) {
            closed = true;
        }
        TestBugReports.assertFalse("ModelMaker.openModel returned a closed model", closed);
    }

    private int getStatementCount(OntModel ontModel) {
        int count = 0;
        StmtIterator it = ontModel.listStatements();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    static class MockTransactionHandler
    extends SimpleTransactionHandler {
        boolean m_inTransaction = false;
        boolean m_aborted = false;
        boolean m_committed = false;

        MockTransactionHandler() {
        }

        public void begin() {
            this.m_inTransaction = true;
        }

        public void abort() {
            this.m_inTransaction = false;
            this.m_aborted = true;
        }

        public void commit() {
            this.m_inTransaction = false;
            this.m_committed = true;
        }
    }
}

