/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.QueryNode;
import com.hp.hpl.jena.graph.query.QueryNodeFactory;
import com.hp.hpl.jena.graph.query.QueryTriple;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import junit.framework.TestSuite;

public class TestQueryNodeFactory
extends QueryTestBase {
    QueryNodeFactory qnf = QueryNode.factory;

    public TestQueryNodeFactory(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestQueryNodeFactory.class);
    }

    public void testFixed() {
        Node f = NodeCreateUtils.create("constant");
        QueryNode F = this.qnf.createFixed(f);
        TestQueryNodeFactory.assertInstanceOf(QueryNode.Fixed.class, F);
        TestQueryNodeFactory.assertSame(f, F.node);
    }

    public void testAny() {
        QueryNode A = this.qnf.createAny();
        TestQueryNodeFactory.assertInstanceOf(QueryNode.Any.class, A);
        TestQueryNodeFactory.assertSame(Node.ANY, A.node);
    }

    public void testBind() {
        Node b = NodeCreateUtils.create("?x");
        QueryNode B = this.qnf.createBind(b, 1);
        TestQueryNodeFactory.assertInstanceOf(QueryNode.Bind.class, B);
        TestQueryNodeFactory.assertSame(b, B.node);
    }

    public void testJustBound() {
        Node j = NodeCreateUtils.create("?y");
        QueryNode J = this.qnf.createJustBound(j, 1);
        TestQueryNodeFactory.assertInstanceOf(QueryNode.JustBound.class, J);
        TestQueryNodeFactory.assertSame(j, J.node);
    }

    public void testBound() {
        Node u = NodeCreateUtils.create("?z");
        QueryNode U = this.qnf.createBound(u, 2);
        TestQueryNodeFactory.assertInstanceOf(QueryNode.Bound.class, U);
        TestQueryNodeFactory.assertSame(u, U.node);
    }

    public void testTriple() {
        QueryNode S = this.qnf.createBound(TestQueryNodeFactory.node("?x"), 0);
        QueryNode P = this.qnf.createFixed(TestQueryNodeFactory.node("P"));
        QueryNode O = this.qnf.createBind(TestQueryNodeFactory.node("?y"), 1);
        QueryTriple t = this.qnf.createTriple(S, P, O);
        TestQueryNodeFactory.assertSame(t.S, S);
        TestQueryNodeFactory.assertSame(t.P, P);
        TestQueryNodeFactory.assertSame(t.O, O);
    }

    public void testArray() {
        QueryTriple[] a = this.qnf.createArray(42);
        TestQueryNodeFactory.assertEquals(42, a.length);
    }
}

