/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class TestUnionStatistics
extends GraphTestBase {
    public TestUnionStatistics(String name) {
        super(name);
    }

    public void testUnionValues() {
        this.testUnion(0, 0, 0, 0);
    }

    public void testCopiesSingleNonZeroResult() {
        this.testUnion(1, 1, 0, 0);
        this.testUnion(1, 0, 1, 0);
        this.testUnion(1, 0, 0, 1);
        this.testUnion(1, 1, 0, 0);
        this.testUnion(2, 0, 2, 0);
        this.testUnion(4, 0, 0, 4);
    }

    public void testResultIsSumOfBaseResults() {
        this.testUnion(3, 1, 2, 0);
        this.testUnion(5, 1, 0, 4);
        this.testUnion(6, 0, 2, 4);
        this.testUnion(7, 1, 2, 4);
        this.testUnion(3, 0, 2, 1);
        this.testUnion(5, 4, 1, 0);
        this.testUnion(6, 2, 2, 2);
        this.testUnion(7, 6, 0, 1);
    }

    public void testUnknownOverrulesAll() {
        this.testUnion(-1, -1, 0, 0);
        this.testUnion(-1, 0, -1, 0);
        this.testUnion(-1, 0, 0, -1);
        this.testUnion(-1, -1, 1, 1);
        this.testUnion(-1, 1, -1, 1);
        this.testUnion(-1, 1, 1, -1);
    }

    private void testUnion(int expected, int av, int bv, int cv) {
        AnInteger a = new AnInteger(av);
        AnInteger b = new AnInteger(bv);
        AnInteger c = new AnInteger(cv);
        Graph g1 = TestUnionStatistics.graphWithGivenStatistic(a);
        Graph g2 = TestUnionStatistics.graphWithGivenStatistic(b);
        Graph g3 = TestUnionStatistics.graphWithGivenStatistic(c);
        Graph[] graphs = new Graph[]{g1, g2, g3};
        MultiUnion mu = new MultiUnion(graphs);
        MultiUnion.MultiUnionStatisticsHandler gs = new MultiUnion.MultiUnionStatisticsHandler(mu);
        TestUnionStatistics.assertEquals((long)expected, gs.getStatistic(Node.ANY, Node.ANY, Node.ANY));
    }

    static Graph graphWithGivenStatistic(final AnInteger x) {
        return new GraphBase(){

            protected ExtendedIterator graphBaseFind(TripleMatch m) {
                throw new RuntimeException("should never be called");
            }

            protected GraphStatisticsHandler createStatisticsHandler() {
                return new GraphStatisticsHandler(){

                    public long getStatistic(Node S, Node P, Node O) {
                        return (this).x.value;
                    }
                };
            }
        };
    }

    static class AnInteger {
        public int value = 0;

        public AnInteger(int value) {
            this.value = value;
        }
    }
}

