/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.LocationMapperAssembler;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.LocationMapper;
import com.hp.hpl.jena.vocabulary.LocationMappingVocab;
import java.util.Iterator;
import java.util.Set;

public class TestLocationMapperAssembler
extends AssemblerTestBase {
    public TestLocationMapperAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return LocationMapperAssembler.class;
    }

    public void testLocationMapperAssemblerType() {
        this.testDemandsMinimalType(new LocationMapperAssembler(), JA.LocationMapper);
    }

    public void testLocationMapperVocabulary() {
        this.assertSubclassOf(JA.LocationMapper, JA.Object);
        this.assertDomain(JA.LocationMapper, LocationMappingVocab.mapping);
    }

    public void testCreatesLocationMapper() {
        Resource root = this.resourceInModel("r rdf:type ja:LocationMapper");
        LocationMapperAssembler a = new LocationMapperAssembler();
        Object x = a.open(root);
        TestLocationMapperAssembler.assertInstanceOf(LocationMapper.class, x);
    }

    public void testCreatesWithCorrectContent() {
        Resource root = this.resourceInModel("r rdf:type ja:LocationMapper; r lm:mapping _m; _m lm:name 'alpha'; _m lm:altName 'beta'");
        LocationMapperAssembler a = new LocationMapperAssembler();
        Object x = a.open(root);
        TestLocationMapperAssembler.assertInstanceOf(LocationMapper.class, x);
        this.assertEqualMaps(new LocationMapper(root.getModel()), (LocationMapper)x);
    }

    private void assertEqualMaps(LocationMapper expected, LocationMapper got) {
        String key;
        Set eAltEntryKeys = IteratorCollection.iteratorToSet(expected.listAltEntries());
        Set gAltEntryKeys = IteratorCollection.iteratorToSet(got.listAltEntries());
        Set eAltPrefixKeys = IteratorCollection.iteratorToSet(expected.listAltPrefixes());
        Set gAltPrefixKeys = IteratorCollection.iteratorToSet(got.listAltPrefixes());
        TestLocationMapperAssembler.assertEquals("altEntry keys dhould be equal", eAltEntryKeys, gAltEntryKeys);
        TestLocationMapperAssembler.assertEquals("prefixEntry keys should be equal", eAltPrefixKeys, gAltPrefixKeys);
        Iterator altKeys = eAltEntryKeys.iterator();
        while (altKeys.hasNext()) {
            key = (String)altKeys.next();
            TestLocationMapperAssembler.assertEquals("alt entrys should be equal", expected.getAltEntry(key), got.getAltEntry(key));
        }
        Iterator preKeys = eAltPrefixKeys.iterator();
        while (preKeys.hasNext()) {
            key = (String)preKeys.next();
            TestLocationMapperAssembler.assertEquals("prefix entiries should be equal", expected.getAltPrefix(key), got.getAltPrefix(key));
        }
    }
}

