/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.policy;

import java.util.List;
import java.util.Vector;
import net.ponder2.Event;
import net.ponder2.ManagedObject;
import net.ponder2.Policy;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.objects.P2Block;
import net.ponder2.objects.P2Boolean;
import net.ponder2.objects.P2Object;

public class ObligationPolicy
extends Policy
implements ManagedObject {
    private P2Object eventTemplate = null;
    private List<P2Block> conditions = new Vector<P2Block>();
    private List<P2Block> actions = new Vector<P2Block>();
    private P2Object myP2Object;

    @Ponder2op(value="create")
    public ObligationPolicy(P2Object myP2Object) {
        this.myP2Object = myP2Object;
    }

    public P2Object event(Event event) throws Ponder2Exception {
        P2Boolean value = this.operation_canExecute(event);
        if (value == P2Boolean.False) {
            return value;
        }
        return this.operation_execute(event);
    }

    @Ponder2op(value="canExecute:")
    protected P2Boolean operation_canExecute(P2Object anEvent) throws Ponder2Exception {
        if (!this.isActive()) {
            return P2Boolean.False;
        }
        if (!(anEvent instanceof Event)) {
            throw new Ponder2ArgumentException("Obligation Policy: execute not given Event");
        }
        Event event = (Event)anEvent;
        if (this.eventTemplate != event.getEventTemplate()) {
            return P2Boolean.False;
        }
        for (P2Block condition : this.conditions) {
            boolean result = condition.operation_valueHash(this.myP2Object, event).asBoolean();
            if (result) continue;
            return P2Boolean.False;
        }
        return P2Boolean.True;
    }

    @Ponder2op(value="execute:")
    protected P2Object operation_execute(P2Object anEvent) throws Ponder2Exception {
        if (!(anEvent instanceof Event)) {
            throw new Ponder2ArgumentException("Obligation Policy: execute not given Event");
        }
        Event event = (Event)anEvent;
        P2Object value = P2Object.create();
        for (P2Block action : this.actions) {
            value = action.operation_valueHash(this.myP2Object, event);
        }
        return value;
    }

    @Ponder2op(value="event:")
    protected P2Object operation_event(P2Object anEventTemplate) {
        this.eventTemplate = anEventTemplate;
        return anEventTemplate;
    }

    @Ponder2op(value="condition:")
    protected P2Object operation_condition(P2Block aBlock) {
        this.conditions.add(aBlock);
        return aBlock;
    }

    @Ponder2op(value="action:")
    protected P2Object operation_action(P2Block aBlock) {
        this.actions.add(aBlock);
        return aBlock;
    }
}

