/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.parser;

import com.twicom.qdparser.Element;
import com.twicom.qdparser.TaggedElement;
import com.twicom.qdparser.XMLParseException;
import com.twicom.qdparser.XMLReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import net.ponder2.OID;
import net.ponder2.Util;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.exception.Ponder2ResolveException;
import net.ponder2.objects.P2Array;
import net.ponder2.objects.P2Block;
import net.ponder2.objects.P2Boolean;
import net.ponder2.objects.P2Hash;
import net.ponder2.objects.P2Number;
import net.ponder2.objects.P2Object;
import net.ponder2.objects.P2String;

public class XMLParser {
    public static boolean trace = false;
    P2Hash variables;

    public XMLParser() {
        this.variables = new P2Hash();
        this.variables.put("Variables", this.variables);
    }

    public XMLParser(P2Hash variables) {
        this.variables = variables;
    }

    public P2Object execute(P2Object source, String xmlString) throws Ponder2Exception {
        StringReader reader = new StringReader(xmlString);
        return this.execute(source, reader);
    }

    public P2Object execute(P2Object source, Reader reader) throws Ponder2Exception {
        P2Object value = P2Object.create();
        TaggedElement element = XMLParser.readXML(reader);
        if (element != null) {
            value = this.execute(source, element);
        }
        return value;
    }

    public P2Object execute(P2Object source, TaggedElement xml) throws Ponder2Exception {
        return this.executeObject(source, xml);
    }

    private P2Object executeObject(P2Object source, TaggedElement xml) throws Ponder2Exception {
        P2Object value;
        block14: {
            value = P2Object.create();
            try {
                String command = xml.getTag();
                if (trace) {
                    System.err.print("Command is " + command);
                    if (xml.getAttribute("name") != null) {
                        System.err.print(" " + xml.getAttribute("name"));
                    }
                    System.err.println();
                }
                if (command.equals("ponder2")) {
                    value = this.executeXML(source, xml);
                    break block14;
                }
                if (command.equals("assign")) {
                    value = this.executeAssign(source, xml);
                    break block14;
                }
                if (command.equals("send")) {
                    value = this.executeSend(source, xml);
                    break block14;
                }
                if (command.equals("use")) {
                    value = this.executeUse(xml);
                    break block14;
                }
                if (command.equals("string")) {
                    value = new P2String(xml.getAttribute("value"));
                    break block14;
                }
                if (command.equals("boolean")) {
                    value = P2Boolean.from(xml.getAttribute("value"));
                    break block14;
                }
                if (command.equals("number")) {
                    value = new P2Number(xml.getAttribute("value"));
                    break block14;
                }
                if (command.equals("block")) {
                    value = new P2Block(this.variables, xml);
                    break block14;
                }
                if (command.equals("array")) {
                    value = this.createArray(source, xml);
                    break block14;
                }
                if (command.equals("oid")) {
                    value = this.executeOID(xml);
                    break block14;
                }
                throw new Ponder2ArgumentException("Unknown element type: " + command);
            }
            catch (Ponder2ArgumentException e2) {
                e2.addXML(xml);
                throw e2;
            }
        }
        return value;
    }

    private P2Object executeXML(P2Object source, TaggedElement xml) throws Ponder2Exception {
        P2Object value = null;
        Iterator iter = xml.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            if (!(element instanceof TaggedElement)) {
                System.out.println(element);
                continue;
            }
            try {
                value = this.executeObject(source, (TaggedElement)element);
            }
            catch (Ponder2ArgumentException e2) {
                e2.addSource(xml.getAttribute("source", "unknown source"));
                throw e2;
            }
        }
        return value;
    }

    private P2Object executeAssign(P2Object source, TaggedElement xml) throws Ponder2Exception {
        String name = xml.getAttribute("name");
        P2Object value = this.executeObject(source, (TaggedElement)xml.getChild(0));
        this.variables.put(name, value);
        return value;
    }

    private P2Object executeSend(P2Object source, TaggedElement xml) throws Ponder2Exception {
        P2Object obj;
        Iterator iter = xml.iterator();
        TaggedElement objxml = (TaggedElement)iter.next();
        P2Object value = obj = this.executeObject(source, objxml);
        TaggedElement currentXML = xml;
        try {
            while (iter.hasNext()) {
                TaggedElement message;
                Element element = (Element)iter.next();
                if (!(element instanceof TaggedElement)) {
                    System.out.println(element);
                    continue;
                }
                currentXML = message = (TaggedElement)element;
                assert (message.equals(message.getTag()));
                String name = message.getAttribute("name");
                int size = Integer.parseInt(message.getAttribute("args", "0"));
                P2Object[] args = new P2Object[size];
                int i = 0;
                while (i < size) {
                    TaggedElement arg = (TaggedElement)message.getChild(i);
                    currentXML = (TaggedElement)arg.getChild(0);
                    args[i] = this.executeObject(source, currentXML);
                    ++i;
                }
                value = name.equals("self") ? obj : obj.operation(source, name, args);
            }
        }
        catch (Ponder2ArgumentException e2) {
            e2.addXML(currentXML);
            throw e2;
        }
        return value;
    }

    private P2Object executeUse(TaggedElement xml) throws Ponder2Exception {
        String name = xml.getAttribute("name");
        P2Object value = this.variables.get(name);
        if (value != null) {
            return value;
        }
        try {
            return Util.resolve("/", name);
        }
        catch (Ponder2ResolveException e2) {
            throw new Ponder2ArgumentException("path not found '" + name + "'");
        }
    }

    private P2Object createArray(P2Object source, TaggedElement xml) throws Ponder2Exception {
        int children = xml.elements();
        P2Object[] values = new P2Object[children];
        int i = 0;
        while (i < children) {
            Element element = xml.getChild(i);
            if (!(element instanceof TaggedElement)) {
                throw new Ponder2ArgumentException("Array element of incorrect type: " + element);
            }
            values[i] = this.executeObject(source, (TaggedElement)element);
            ++i;
        }
        return new P2Array(values);
    }

    private P2Object executeOID(TaggedElement xml) throws Ponder2ArgumentException, Ponder2OperationException {
        OID oid = OID.fromXML(xml);
        if (oid == null) {
            throw new Ponder2ArgumentException("OID not found: " + xml.toString());
        }
        return oid.getP2Object();
    }

    public static TaggedElement readXML(Reader input) {
        TaggedElement element = null;
        try {
            XMLReader reader = new XMLReader("xml", input);
            element = reader.parse();
        }
        catch (XMLParseException e2) {
            System.out.println("XMLParser: readXML");
            e2.printStackTrace();
        }
        catch (IOException e3) {
            System.out.println("XMLParser: readXML");
            e3.printStackTrace();
        }
        return element;
    }
}

