/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.apt;

import com.sun.mirror.apt.Filer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ponder2.apt.DocWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocWriterHtml
extends DocWriter {
    private PrintWriter out;
    private Filer filer;
    private static Map<String, String> objects = new HashMap<String, String>();
    private static int indexCount = 0;

    DocWriterHtml(Filer filer, String className) throws IOException {
        super(filer, className);
        this.filer = filer;
        this.out = filer.createTextFile(Filer.Location.SOURCE_TREE, "doc", new File(String.valueOf(className) + ".html"), null);
    }

    @Override
    public void writeClass(String className, String superClass, String comment) {
        comment = this.strip(comment);
        objects.put(className, comment);
        this.writeIndexFile(this.filer, objects);
        this.writeHeader(this.out, className);
        if (!superClass.equals("net.ponder2.P2ObjectAdaptor")) {
            this.out.println("<h2>Based on " + superClass + "</h2>");
            this.out.println("<p>");
        }
        this.out.println(comment);
        this.out.println("<p>");
    }

    @Override
    public void section(int section) {
        String text;
        switch (section) {
            case 0: {
                text = "Factory Messages";
                break;
            }
            case 1: {
                text = "Operational Messages";
                break;
            }
            default: {
                text = "Danger Will Robinson, error in Doc Writer!";
            }
        }
        this.out.println("<h2>" + text + "</h2>");
    }

    @Override
    public void writeOperation(List<String> operation, String comment, List<String> parameters) {
        int opSize = operation.size();
        int paramSize = parameters.size();
        String line = "<h3>";
        int i = 0;
        while (i < opSize) {
            String op = operation.get(i);
            line = String.valueOf(line) + op;
            char ch = op.charAt(0);
            if ((ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && !line.endsWith(":")) break;
            line = String.valueOf(line) + " ";
            line = i < paramSize ? String.valueOf(line) + parameters.get(i) : String.valueOf(line) + "<b>ERROR PARAM MISSING</b>";
            line = String.valueOf(line) + " ";
            ++i;
        }
        line = String.valueOf(line) + "</h3>";
        this.out.println(String.valueOf(line) + "<p>");
        this.out.println(comment);
        this.out.println("<p>");
    }

    @Override
    public void close() {
        this.out.close();
    }

    private void writeIndexFile(Filer filer, Map<String, String> objects) {
        try {
            PrintWriter index = filer.createTextFile(Filer.Location.SOURCE_TREE, "doc", new File("index" + ++indexCount + ".html"), null);
            this.writeHeader(index, "PonderTalk Object Reference");
            index.println("");
            index.println("");
            for (Map.Entry<String, String> entry : objects.entrySet()) {
                index.println("<p>");
                index.println("<a href=\"" + entry.getKey() + ".html" + "\">" + entry.getKey() + "</a>");
                index.println("<br>" + entry.getValue());
            }
            index.println("</body>");
            index.println("</html>");
            index.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void writeHeader(PrintWriter pw, String title) {
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<meta http-equiv=Content-Type content=\"text/html; charset=windows-1252\">");
        pw.println("<title>" + title + "</title>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>" + title + "</h1>");
        pw.println("<p>");
    }
}

