/*
 * Decompiled with CFR 0.152.
 */
package jena.test;

import [Ljava.lang.String;;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import jena.schemagen;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Test_schemagen
extends TestCase {
    String PREFIX = "@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix owl: <http://www.w3.org/2002/07/owl#> .\n@prefix ex: <http://example.com/sg#> .\n";
    private static Log log = LogFactory.getLog(Test_schemagen.class);

    public void testNoBaseURI0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        boolean ex = false;
        try {
            this.testSchemagenOutput(SOURCE, null, new String[0], new String[0], new String[0]);
        }
        catch (RuntimeException e2) {
            Test_schemagen.assertEquals("Could not determine the base URI for the input vocabulary", e2.getMessage());
            ex = true;
        }
        Test_schemagen.assertTrue("Expected abort", ex);
    }

    public void testClass0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{".*public static final Resource A.*"}, new String[0]);
    }

    public void testClass1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[0], new String[]{".*public static final Resource A.*"});
    }

    public void testClass2() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[0], new String[]{".*public static final Resource A.*"});
    }

    public void testClass3() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[]{".*public static final Resource A.*"}, new String[0]);
    }

    public void testProperty0() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a owl:ObjectProperty .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{".*public static final Property p.*"}, new String[0]);
    }

    public void testProperty1() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{".*public static final Property p.*"}, new String[0]);
    }

    public void testProperty2() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a owl:ObjectProperty .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[0], new String[]{".*public static final Property p.*"});
    }

    public void testProperty3() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[]{".*public static final Property p.*"}, new String[0]);
    }

    public void testInstance0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{".*public static final Resource i.*"}, new String[0]);
    }

    public void testInstance1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{".*public static final Resource i.*"}, new String[0]);
    }

    public void testInstance3() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[]{".*public static final Resource i.*"}, new String[0]);
    }

    public void testRC0() throws Exception {
        String SOURCE = this.PREFIX + "ex:class a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[0], new String[]{".*public static final Resource class .*"});
    }

    public void testComment0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class ; rdfs:comment \"commentcomment\" .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{" */\\*\\* <p>commentcomment</p> \\*/ *"}, new String[0]);
    }

    public void testComment1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class ; rdfs:comment \"commentcomment\" .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--nocomments"}, new String[0], new String[]{" */\\*\\* <p>commentcomment</p> \\*/ *"});
    }

    public void testOntClass0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--ontology"}, new String[]{".*public static final OntClass A.*"}, new String[0]);
    }

    public void testOntClass1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--ontology"}, new String[0], new String[]{".*public static final OntClass A.*"});
    }

    public void testOntClass2() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--ontology"}, new String[0], new String[]{".*public static final OntClass A.*"});
    }

    public void testOntClass3() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--ontology"}, new String[]{".*public static final OntClass A.*"}, new String[0]);
    }

    public void testOntProperty0() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a owl:ObjectProperty .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--ontology"}, new String[]{".*public static final ObjectProperty p.*"}, new String[0]);
    }

    public void testOntProperty1() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--ontology"}, new String[]{".*public static final OntProperty p.*"}, new String[0]);
    }

    public void testOntProperty2() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a owl:ObjectProperty .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--ontology"}, new String[0], new String[]{".*public static final ObjectProperty p.*"});
    }

    public void testOntProperty3() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--ontology"}, new String[]{".*public static final OntProperty p.*"}, new String[0]);
    }

    public void testHeader() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--header", "/* header */\n%package%\n%imports%\n"}, new String[]{"/\\* header \\*/"}, new String[0]);
    }

    public void testFooter() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--footer", "/* footer */"}, new String[]{"/\\* footer \\*/"}, new String[0]);
    }

    public void testPackage() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--package", "test.test"}, new String[]{"package test.test;\\s*"}, new String[0]);
    }

    public void testClassname() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        SchemaGenAux fixture = new SchemaGenAux(){

            protected String getValue(Object option) {
                if (option.equals(OPT_INPUT)) {
                    return "http://example.org/soggy";
                }
                return super.getValue(option);
            }
        };
        this.testSchemagenOutput(SOURCE, fixture, new String[]{"-a", "http://example.com/soggy#", "--ontology", "--package", "test.test", "-n", "Sg"}, new String[0], new String[0]);
    }

    public void testClassdec() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--classdec", "\n    implements java.lang.Cloneable\n"}, new String[]{"\\s*implements java.lang.Cloneable\\s*"}, new String[0]);
    }

    public void testDeclarations() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--declarations", "protected String m_gnole = \"Fungle\";;\n"}, new String[]{".*Fungle.*"}, new String[0]);
    }

    public void testNoClasses() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--noclasses"}, new String[0], new String[]{".*OntClass A.*"});
    }

    public void testNoProperties() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a owl:ObjectProperty .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--ontology", "--noproperties"}, new String[0], new String[]{".*Property p.*"});
    }

    public void testNoIndividuals() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--noindividuals"}, new String[]{".*Resource A.*"}, new String[]{".*Resource i.*"});
    }

    public void testNoHeader() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--noheader"}, new String[0], new String[]{"/\\*\\*.*"});
    }

    public void testUCNames() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--uppercase"}, new String[]{".*Resource A.*", ".*Resource I.*"}, new String[0]);
    }

    public void testInference0() throws Exception {
        String SOURCE = this.PREFIX + "ex:p rdfs:domain ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[0], new String[]{".*Resource A.*", ".*Property p.*"});
    }

    public void testInference1() throws Exception {
        String SOURCE = this.PREFIX + "ex:p rdfs:domain ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--inference"}, new String[]{".*Resource A.*", ".*Property p.*"}, new String[0]);
    }

    public void testInference2() throws Exception {
        String SOURCE = this.PREFIX + "ex:p rdfs:domain ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--inference"}, new String[]{".*Resource A.*", ".*Property p.*"}, new String[0]);
    }

    public void testStrictIndividuals0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A . <http://example.com/different#j> a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[]{".*Resource i.*", ".*Resource j.*"}, new String[0]);
    }

    public void testStrictIndividuals1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A . <http://example.com/different#j> a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--strictIndividuals"}, new String[]{".*Resource i.*"}, new String[]{".*Resource j.*"});
    }

    public void testLineEnd0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A . ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--strictIndividuals"}, new String[0], new String[]{".*\r.*"});
    }

    public void testLineEnd1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A . ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--dos"}, new String[]{".*\\r"}, new String[]{".*[^\r]"});
    }

    protected String testSchemagenOutput(String source, SchemaGenAux sg, String[] args, String[] posPatterns, String[] negPatterns) throws Exception {
        sg = sg == null ? new SchemaGenAux() : sg;
        Model m = ModelFactory.createDefaultModel();
        m.read(new StringReader(source), "http://example.com/sg#", "N3");
        sg.setSource(m);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        sg.setOutput(new PrintStream(buf));
        sg.testGo(args);
        String result = buf.toString();
        if (log.isDebugEnabled()) {
            log.debug(result);
        }
        StringTokenizer tokens = new StringTokenizer(result, "\n");
        boolean[] foundPos = new boolean[posPatterns.length];
        while (tokens.hasMoreTokens()) {
            Pattern pat;
            String line = tokens.nextToken();
            int i = 0;
            while (i < posPatterns.length) {
                pat = Pattern.compile(posPatterns[i]);
                int n = i++;
                foundPos[n] = foundPos[n] | pat.matcher(line).matches();
            }
            for (i = 0; i < negPatterns.length; ++i) {
                pat = Pattern.compile(negPatterns[i]);
                Test_schemagen.assertFalse("negative match pattern ||" + negPatterns[i] + "|| matched on line: " + line, pat.matcher(line).matches());
            }
        }
        for (int i = 0; i < posPatterns.length; ++i) {
            String msg = "Expecting a positive match to pattern: ||" + posPatterns[i] + "||";
            Test_schemagen.assertTrue(msg + " in:\n" + result, foundPos[i]);
        }
        this.testCompile(result, "Sg");
        return result;
    }

    protected void testCompile(String source, String className) throws Exception {
        File tmpDir = FileUtils.getScratchDirectory("schemagen");
        File srcFile = new File(tmpDir, className + ".java");
        FileWriter out = new FileWriter(srcFile);
        out.write(source);
        out.close();
        try {
            Class<?> jcMain = Class.forName("sun.tools.javac.Main");
            Constructor<?> jcConstruct = jcMain.getConstructor(OutputStream.class, String.class);
            Method jcCompile = jcMain.getMethod("compile", String;.class);
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            Object jc = jcConstruct.newInstance(byteOut, "javac");
            String[] args = new String[]{"-classpath", this.getClassPath(tmpDir), "-d", tmpDir.getPath(), srcFile.getPath()};
            Boolean success = (Boolean)jcCompile.invoke(jc, new Object[]{args});
            log.debug("compiled - success = " + success);
            log.debug("message = " + byteOut.toString());
            Test_schemagen.assertTrue("Errors reported from compilation of schemagen output", success);
        }
        catch (ClassNotFoundException nf) {
            log.debug("sun.tools.java.Main not found (no tools.jar on classpath?). schemagen compilation test skipped.");
        }
        srcFile.deleteOnExit();
        new File(tmpDir, className + ".class").deleteOnExit();
        tmpDir.deleteOnExit();
    }

    protected String getClassPath(File tmpDir) {
        return System.getProperty("java.class.path") + System.getProperty("path.separator") + tmpDir.getPath();
    }

    static class SchemaGenAux
    extends schemagen {
        protected PrintStream m_auxOutput;
        protected Model m_auxSource;

        SchemaGenAux() {
        }

        public void setOutput(PrintStream out) {
            this.m_auxOutput = out;
        }

        public void setSource(Model m) {
            this.m_auxSource = m;
        }

        protected void selectInput() {
            this.m_source.add(this.m_auxSource);
        }

        protected void selectOutput() {
            super.selectOutput();
            this.m_output = this.m_auxOutput;
        }

        public void testGo(String[] args) {
            this.go(args);
        }

        protected String getValue(Object option) {
            if (option.equals(OPT_INPUT)) {
                return "http://example.org/sg";
            }
            return super.getValue(option);
        }

        protected Resource getResource(Object option) {
            if (option.equals(OPT_INPUT)) {
                return ResourceFactory.createResource("http://example.org/sg");
            }
            return super.getResource(option);
        }

        protected void abort(String msg, Exception e2) {
            throw new RuntimeException(msg, e2);
        }
    }
}

