/*
 * Decompiled with CFR 0.152.
 */
package hospital.actors.gui;

import hospital.actors.NurseMO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class NurseGUI
extends JPanel
implements ActionListener {
    private String newline = "\n";
    protected static final String patientNameString = "Patient Path";
    protected static final String ftfString = "Nurse Level";
    protected static final String buttonString = "OK";
    JFormattedTextField nurseLevel;
    JTextField patientField;
    JTextArea textArea;
    NurseMO nurse;
    protected JLabel actionLabel;

    public NurseGUI() {
        this.setLayout(new BorderLayout());
        this.patientField = new JTextField("/patient/ward1/patient1", 10);
        this.patientField.setActionCommand(patientNameString);
        this.patientField.addActionListener(this);
        this.nurseLevel = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.nurseLevel.setActionCommand(patientNameString);
        this.nurseLevel.addActionListener(this);
        JLabel textFieldLabel = new JLabel("Patient Path: ");
        textFieldLabel.setLabelFor(this.patientField);
        JLabel ftfLabel = new JLabel("Nurse Level: ");
        ftfLabel.setLabelFor(this.nurseLevel);
        this.actionLabel = new JLabel("Type Patient Path and Nurse Level and then press the OK button.");
        this.actionLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JButton button = new JButton();
        button.setText(buttonString);
        button.setActionCommand(buttonString);
        button.addActionListener(this);
        JPanel textControlsPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        textControlsPane.setLayout(gridbag);
        JLabel[] labels = new JLabel[]{textFieldLabel, ftfLabel};
        JTextField[] textFields = new JTextField[]{this.patientField, this.nurseLevel};
        this.addLabelTextRows(labels, textFields, gridbag, textControlsPane);
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        textControlsPane.add((Component)this.actionLabel, c);
        textControlsPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Input Fields"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        c.anchor = 13;
        c.weightx = 1.0;
        textControlsPane.add((Component)button, c);
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Serif", 0, 16));
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        JScrollPane areaScrollPane = new JScrollPane(this.textArea);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setPreferredSize(new Dimension(500, 500));
        areaScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Nurse Output"), BorderFactory.createEmptyBorder(5, 5, 5, 5)), areaScrollPane.getBorder()));
        this.add((Component)textControlsPane, "First");
        this.add((Component)areaScrollPane, "Center");
    }

    private void addLabelTextRows(JLabel[] labels, JTextField[] textFields, GridBagLayout gridbag, Container container2) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        int numLabels = labels.length;
        int i = 0;
        while (i < numLabels) {
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            container2.add((Component)labels[i], c);
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            container2.add((Component)textFields[i], c);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e2) {
        if (buttonString.equals(e2.getActionCommand())) {
            this.getInput();
        }
    }

    private void getInput() {
        String patientPath = this.patientField.getText();
        String slevel = this.nurseLevel.getText();
        int level = slevel.equals("") ? this.nurse.getNurseLevel() : Integer.parseInt(slevel);
        this.textArea.append("Going to retrieve the record for patient " + patientPath + this.newline);
        this.textArea.append("The level of this nurse is set to " + level + this.newline);
        this.output(String.valueOf(this.nurse.checkRecord(patientPath, level)) + " " + this.newline);
    }

    private void output(String s) {
        this.textArea.append(s);
    }

    private void createAndShowGUI(NurseMO n) {
        this.nurse = n;
        JFrame frame = new JFrame(n.getNursePath());
        frame.setDefaultCloseOperation(3);
        this.setOpaque(true);
        frame.setContentPane(this);
        frame.pack();
        frame.setVisible(true);
    }

    public void start(final NurseMO nurse) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NurseGUI.this.createAndShowGUI(nurse);
            }
        });
    }
}

