/*
 * Decompiled with CFR 0.152.
 */
package com.twicom.qdparser;

import com.twicom.qdparser.DocHandler;
import com.twicom.qdparser.QDParser;
import com.twicom.qdparser.TaggedElement;
import com.twicom.qdparser.XMLParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class XMLReader
implements DocHandler {
    private String comment;
    private Reader input;
    private TaggedElement top;
    private TaggedElement element;
    Stack stack;

    public static TaggedElement parse(String xml) {
        return XMLReader.parse("XML string", xml);
    }

    public static TaggedElement parse(String comment, String xml) {
        TaggedElement result = null;
        try {
            result = new XMLReader(xml).parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public XMLReader(String xml) {
        this.initialise("XML String", new StringReader(xml));
    }

    public XMLReader(String comment, String xml) {
        this.initialise(comment, new StringReader(xml));
    }

    public XMLReader(String comment, Reader input) {
        this.initialise(comment, input);
    }

    public XMLReader(String comment, URI uri) {
        String scheme = uri.getScheme();
        if (scheme != null && scheme.equals("resource")) {
            Reader input = XMLReader.openResource(uri.getSchemeSpecificPart());
            this.initialise(comment, input);
        }
    }

    private void initialise(String comment, Reader input) {
        this.comment = comment;
        this.input = input;
    }

    public TaggedElement parse() throws XMLParseException, IOException {
        this.top = null;
        this.element = null;
        this.stack = new Stack();
        QDParser.parse(this, this.input);
        return this.top;
    }

    public void startDocument() throws XMLParseException {
        this.top = null;
    }

    public void endDocument() throws XMLParseException {
    }

    public void startElement(String nameSpace, String tag, Map attributes, int line, int col) throws XMLParseException {
        String fullns = "xmlns";
        if (nameSpace != null) {
            fullns = String.valueOf(fullns) + ":" + nameSpace;
        }
        if (attributes.containsKey(fullns)) {
            nameSpace = (String)attributes.get(fullns);
        }
        TaggedElement newElement = new TaggedElement(nameSpace, tag);
        this.log("startElement:" + newElement.getName());
        newElement.setLocation(line, col);
        newElement.setComment(this.comment);
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            newElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.top == null) {
            this.top = newElement;
        } else {
            this.element.add(newElement);
        }
        if (this.element != null) {
            this.stack.push(this.element);
        }
        this.element = newElement;
    }

    public void endElement(String nameSpace, String tag) throws XMLParseException {
        this.log("endElement " + this.element.getName());
        if (!this.stack.isEmpty()) {
            this.element = (TaggedElement)this.stack.pop();
        }
    }

    public void text(String str2, int line, int col) throws XMLParseException {
        if ((str2 = str2.trim()).length() != 0 && this.element != null) {
            this.element.add(str2);
        }
    }

    public static Reader openResource(String name) {
        InputStream istream = name.getClass().getResourceAsStream(name);
        if (istream == null && !name.startsWith("/")) {
            istream = name.getClass().getResourceAsStream("/" + name);
        }
        if (istream == null) {
            return null;
        }
        return new InputStreamReader(istream);
    }

    private void log(String msg) {
    }
}

