/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.Locator;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocatorURL
implements Locator {
    static Log log = LogFactory.getLog(LocatorURL.class);
    static final String acceptHeader = "application/rdf+xml,application/xml;q=0.9,*/*;q=0.5";
    static final String[] schemeNames = new String[]{"http:", "https:"};

    public InputStream open(String filenameOrURI) {
        if (!this.acceptByScheme(filenameOrURI)) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("Not found : " + filenameOrURI);
            }
            return null;
        }
        try {
            URL url = new URL(filenameOrURI);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Accept", acceptHeader);
            conn.setRequestProperty("Accept-Charset", "utf-8,*");
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.connect();
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            if (in == null) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace("Not found: " + filenameOrURI);
                }
                return null;
            }
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("Found: " + filenameOrURI);
            }
            return in;
        }
        catch (FileNotFoundException ex) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("LocatorURL: not found: " + filenameOrURI);
            }
            return null;
        }
        catch (MalformedURLException ex) {
            log.warn("Malformed URL: " + filenameOrURI);
            return null;
        }
        catch (UnknownHostException ex) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("LocatorURL: not found (UnknownHostException): " + filenameOrURI);
            }
            return null;
        }
        catch (ConnectException ex) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("LocatorURL: not found (ConnectException): " + filenameOrURI);
            }
            return null;
        }
        catch (SocketException ex) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("LocatorURL: not found (SocketException): " + filenameOrURI);
            }
            return null;
        }
        catch (IOException ex) {
            log.warn("I/O Exception opening URL: " + filenameOrURI + "  " + ex.getMessage(), ex);
            return null;
        }
    }

    public boolean equals(Object other) {
        return other instanceof LocatorURL;
    }

    public int hashCode() {
        return LocatorURL.class.hashCode();
    }

    public String getName() {
        return "LocatorURL";
    }

    private boolean acceptByScheme(String filenameOrURI) {
        String uriSchemeName = this.getScheme(filenameOrURI);
        if (uriSchemeName == null) {
            return false;
        }
        uriSchemeName = uriSchemeName.toLowerCase();
        for (int i = 0; i < schemeNames.length; ++i) {
            if (!uriSchemeName.equals(schemeNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean hasScheme(String uri, String scheme) {
        String actualScheme = this.getScheme(uri);
        if (actualScheme == null) {
            return false;
        }
        return actualScheme.equalsIgnoreCase(scheme);
    }

    private String getScheme(String uri) {
        int ch = uri.indexOf(58);
        if (ch < 0) {
            return null;
        }
        return uri.substring(0, ch + 1);
    }
}

