/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderNode;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSSE_Builder
extends TestCase {
    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestSSE_Builder.class);
        ts.setName("SSE Op");
        return ts;
    }

    public void test_01() {
        SSE.parseTriple("[triple ?s ?p ?o]");
    }

    public void test_02() {
        SSE.parseTriple("[?s ?p ?o]");
    }

    public void test_03() {
        SSE.parseTriple("[?s ?p ?o]");
    }

    public void test_04() {
        SSE.parseTriple("(?s ?p ?o)");
    }

    public void test_05() {
        SSE.parseQuad("(_ ?s ?p ?o)");
    }

    public void test_06() {
        SSE.parseQuad("(quad _ ?s ?p ?o)");
    }

    public void test_07() {
        SSE.parseExpr("1");
    }

    public void test_08() {
        SSE.parseExpr("(+ 1 2)");
    }

    public void testOp_01() {
        TestSSE_Builder.opSame("(null)");
    }

    public void testOp_02() {
        TestSSE_Builder.opSame("(null)", new OpNull());
    }

    public void testOp_03() {
        TestSSE_Builder.opSame("(bgp [triple ?s ?p ?o])");
    }

    private static void opSame(String str2) {
        TestSSE_Builder.opSame(str2, SSE.parseOp(str2));
    }

    private static void opSame(String str2, Op other) {
        Op op = SSE.parseOp(str2);
        TestSSE_Builder.assertEquals(op, other);
    }

    public void testBuildInt_01() {
        Item item = SSE.parseItem("1");
        int i = BuilderNode.buildInt(item);
        TestSSE_Builder.assertEquals(1, i);
    }

    public void testBuildInt_02() {
        Item item = SSE.parseItem("1");
        int i = BuilderNode.buildInt(item, 23);
        TestSSE_Builder.assertEquals(1, i);
    }

    public void testBuildInt_03() {
        Item item = SSE.parseItem("_");
        int i = BuilderNode.buildInt(item, 23);
        TestSSE_Builder.assertEquals(23, i);
    }
}

