/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DataFormat;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.EarlTestCase;
import com.hp.hpl.jena.sparql.junit.QueryTest;
import com.hp.hpl.jena.sparql.junit.QueryTestException;
import com.hp.hpl.jena.sparql.junit.SurpressedTest;
import com.hp.hpl.jena.sparql.junit.SyntaxTest;
import com.hp.hpl.jena.sparql.junit.TestItem;
import com.hp.hpl.jena.sparql.junit.TestQueryUtils;
import com.hp.hpl.jena.sparql.junit.TestSerialization;
import com.hp.hpl.jena.sparql.vocabulary.TestManifest;
import com.hp.hpl.jena.sparql.vocabulary.TestManifestX;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.junit.TestFactoryManifest;
import com.hp.hpl.jena.util.junit.TestUtils;
import junit.framework.Test;
import junit.framework.TestSuite;

public class QueryTestSuiteFactory
extends TestFactoryManifest {
    private FileManager fileManager = FileManager.get();
    public static EarlReport results = null;

    public static TestSuite make(String filename) {
        QueryTestSuiteFactory tFact = new QueryTestSuiteFactory();
        return tFact.process(filename);
    }

    public static TestSuite make(String query2, String data, String result) {
        TestItem item = new TestItem(query2, query2, data, result);
        QueryTest t = new QueryTest(item.getName(), null, FileManager.get(), item);
        TestSuite ts = new TestSuite();
        ts.setName(TestUtils.safeName(query2));
        ts.addTest(t);
        return ts;
    }

    public Test makeTest(Resource manifest, Resource entry, String testName, Resource action, Resource result) {
        Syntax querySyntax = TestQueryUtils.getQuerySyntax(manifest);
        if (!(querySyntax == null || querySyntax.equals(Syntax.syntaxRDQL) || querySyntax.equals(Syntax.syntaxARQ) || querySyntax.equals(Syntax.syntaxSPARQL))) {
            throw new QueryTestException("Unknown syntax: " + querySyntax);
        }
        Resource defaultTestType = TestUtils.getResource(manifest, TestManifestX.defaultTestType);
        TestItem item = new TestItem(entry, defaultTestType, querySyntax, DataFormat.langXML);
        EarlTestCase test = null;
        if (item.getTestType() != null) {
            if (((Object)item.getTestType()).equals(TestManifest.PositiveSyntaxTest) || ((Object)item.getTestType()).equals(TestManifestX.TestSyntax)) {
                test = new SyntaxTest(testName, results, item);
            }
            if (((Object)item.getTestType()).equals(TestManifest.NegativeSyntaxTest) || ((Object)item.getTestType()).equals(TestManifestX.TestBadSyntax)) {
                test = new SyntaxTest(testName, results, item, false);
            }
            if (((Object)item.getTestType()).equals(TestManifestX.TestSerialization)) {
                test = new TestSerialization(testName, results, item);
            }
            if (((Object)item.getTestType()).equals(TestManifest.QueryEvaluationTest) || ((Object)item.getTestType()).equals(TestManifestX.TestQuery)) {
                test = new QueryTest(testName, results, this.fileManager, item);
            }
            if (((Object)item.getTestType()).equals(TestManifestX.TestSurpressed)) {
                test = new SurpressedTest(testName, results, item);
            }
            if (test == null) {
                System.err.println("Test type '" + item.getTestType() + "' not recognized");
            }
        }
        if (test == null) {
            test = new QueryTest(testName, results, this.fileManager, item);
        }
        return test;
    }
}

