/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.ref;

import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.algebra.table.TableN;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConcat;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterDistinct;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterGroup;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProject;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterReduced;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSlice;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSort;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.engine.ref.Evaluator;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.List;

class EvaluatorSimple
implements Evaluator {
    private ExecutionContext execCxt;
    boolean debug = false;

    EvaluatorSimple(ExecutionContext context) {
        this.execCxt = context;
    }

    public ExecutionContext getExecContext() {
        return this.execCxt;
    }

    public Table basicPattern(BasicPattern pattern) {
        QueryIterator qIter = StageBuilder.compile(pattern, QueryIterRoot.create(this.execCxt), this.execCxt);
        return TableFactory.create(qIter);
    }

    public Table join(Table tableLeft, Table tableRight) {
        if (this.debug) {
            System.out.println("Join");
            EvaluatorSimple.dump(tableLeft);
            EvaluatorSimple.dump(tableRight);
        }
        return this.joinWorker(tableLeft, tableRight, false, null);
    }

    public Table leftJoin(Table tableLeft, Table tableRight, ExprList exprs) {
        if (this.debug) {
            System.out.println("Left Join");
            EvaluatorSimple.dump(tableLeft);
            EvaluatorSimple.dump(tableRight);
            if (exprs != null) {
                System.out.println(exprs.toString());
            }
        }
        return this.joinWorker(tableLeft, tableRight, true, exprs);
    }

    public Table diff(Table tableLeft, Table tableRight) {
        if (this.debug) {
            System.out.println("Diff");
            EvaluatorSimple.dump(tableLeft);
            EvaluatorSimple.dump(tableRight);
        }
        return this.diffWorker(tableLeft, tableRight);
    }

    public Table filter(ExprList expressions, Table table) {
        if (this.debug) {
            System.out.println("Restriction");
            System.out.println(expressions.toString());
            EvaluatorSimple.dump(table);
        }
        QueryIterator iter = table.iterator(this.execCxt);
        ArrayList<Binding> output = new ArrayList<Binding>();
        while (iter.hasNext()) {
            Binding b = iter.nextBinding();
            if (!expressions.isSatisfied(b, this.execCxt)) continue;
            output.add(b);
        }
        return new TableN(new QueryIterPlainWrapper(output.iterator(), this.execCxt));
    }

    public Table union(Table tableLeft, Table tableRight) {
        if (this.debug) {
            System.out.println("Union");
            EvaluatorSimple.dump(tableLeft);
            EvaluatorSimple.dump(tableRight);
        }
        QueryIterConcat output = new QueryIterConcat(this.execCxt);
        output.add(tableLeft.iterator(this.execCxt));
        output.add(tableRight.iterator(this.execCxt));
        return new TableN(output);
    }

    public Table list(Table table) {
        return table;
    }

    public Table order(Table table, List conditions) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterSort(qIter, conditions, this.getExecContext());
        return new TableN(qIter);
    }

    public Table groupBy(Table table, VarExprList groupVars, List aggregators) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterGroup(qIter, groupVars, aggregators, this.getExecContext());
        return new TableN(qIter);
    }

    public Table project(Table table, VarExprList project) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterProject(qIter, project, this.getExecContext());
        return new TableN(qIter);
    }

    public Table reduced(Table table) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterReduced(qIter, this.getExecContext());
        return new TableN(qIter);
    }

    public Table distinct(Table table) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterDistinct(qIter, this.getExecContext());
        return new TableN(qIter);
    }

    public Table slice(Table table, long start, long length) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterSlice(qIter, start, length, this.getExecContext());
        return new TableN(qIter);
    }

    public Table unit() {
        return TableFactory.createUnit();
    }

    private Table joinWorker(Table tableLeft, Table tableRight, boolean leftJoin, ExprList conditions) {
        QueryIterator left = tableLeft.iterator(this.execCxt);
        QueryIterConcat output = new QueryIterConcat(this.execCxt);
        while (left.hasNext()) {
            Binding b = left.nextBinding();
            QueryIterator x = tableRight.matchRightLeft(b, leftJoin, conditions, this.execCxt);
            if (x == null) continue;
            output.add(x);
        }
        tableLeft.close();
        tableRight.close();
        return new TableN(output);
    }

    private Table diffWorker(Table tableLeft, Table tableRight) {
        QueryIterator left = tableLeft.iterator(this.execCxt);
        TableN r = new TableN();
        while (left.hasNext()) {
            Binding b = left.nextBinding();
            if (!tableRight.contains(b)) continue;
            r.addBinding(b);
        }
        tableLeft.close();
        tableRight.close();
        return r;
    }

    private static void dump(Table table) {
        System.out.println("Table: " + Utils.className(table));
        QueryIterator qIter = table.iterator(null);
        ResultSetStream rs = new ResultSetStream(table.getVarNames(), null, table.iterator(null));
        ResultSetFormatter.out(rs);
    }
}

