/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.AlgebraGenerator;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.OpExec;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.PlanOp;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.NodeFactory;

public abstract class QueryEngineBase
implements OpExec {
    private DatasetGraph dataset = null;
    private Context context;
    private Binding startBinding;
    private Op queryOp = null;
    private Plan plan = null;

    protected QueryEngineBase(Query query2, DatasetGraph dataset, AlgebraGenerator gen, Binding input, Context context) {
        this(dataset, input, context);
        query2.setResultVars();
        this.setOp(this.createOp(query2, gen));
    }

    protected QueryEngineBase(Op op, DatasetGraph dataset, Binding input, Context context) {
        this(dataset, input, context);
        this.setOp(op);
    }

    private QueryEngineBase(DatasetGraph dataset, Binding input, Context context) {
        this.dataset = dataset;
        if (context == null) {
            context = ARQ.getContext().copy();
        }
        this.context = context;
        if (input == null) {
            ALog.warn(this, "Null initial input");
            input = BindingRoot.create();
        }
        this.startBinding = input;
        context.set(ARQConstants.sysCurrentTime, NodeFactory.nowAsDateTime());
    }

    public Plan getPlan() {
        if (this.plan == null) {
            this.plan = this.createPlan();
        }
        return this.plan;
    }

    protected Plan createPlan() {
        Op op = this.modifyOp(this.queryOp);
        QueryIterator queryIterator = null;
        if (this.dataset != null) {
            queryIterator = this.eval(op, this.dataset, this.startBinding, this.context);
        }
        return new PlanOp(this.getOp(), queryIterator);
    }

    protected Op modifyOp(Op op) {
        return op;
    }

    protected Op createOp(Query query2, AlgebraGenerator gen) {
        Op op = gen.compile(query2);
        return op;
    }

    public QueryIterator eval(Op op, Graph graph) {
        return this.eval(op, new DataSourceGraphImpl(graph), ARQ.getContext().copy());
    }

    public QueryIterator eval(Op op, DatasetGraph dsg, Context context) {
        return this.eval(op, dsg, BindingRoot.create(), context);
    }

    public abstract QueryIterator eval(Op var1, DatasetGraph var2, Binding var3, Context var4);

    public Op getOp() {
        return this.queryOp;
    }

    protected void setOp(Op op) {
        this.queryOp = op;
    }
}

