/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;

public class TestConsistency
extends TestCase {
    public void testConsistent0() {
        String NS = "http://example.org/foo#";
        OntModel base = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM, null);
        OntClass F0 = base.createClass(NS + "F0");
        OntClass F1 = base.createClass(NS + "F1");
        F0.addDisjointWith(F1);
        Individual i0 = base.createIndividual(NS + "i0", OWL.Thing);
        i0.setRDFType(F0);
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner(r);
        OntModel m = ModelFactory.createOntologyModel(spec, base);
        TestConsistency.assertTrue("KB should be consistent", m.validate().isValid());
    }

    public void testConsistent1() {
        String NS = "http://example.org/foo#";
        OntModel base = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM, null);
        OntClass F0 = base.createClass(NS + "F0");
        OntClass F1 = base.createClass(NS + "F1");
        F0.addDisjointWith(F1);
        Individual i0 = base.createIndividual(NS + "i0", OWL.Thing);
        i0.setRDFType(F0);
        i0.addRDFType(F1);
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner(r);
        OntModel m = ModelFactory.createOntologyModel(spec, base);
        ValidityReport report = m.validate();
        if (!report.isValid()) {
            Iterator i = report.getReports();
            while (i.hasNext()) {
                ValidityReport.Report rp = (ValidityReport.Report)i.next();
                LogFactory.getLog(this.getClass()).debug("Problem report: " + rp.type + " - " + rp.description);
            }
        }
        TestConsistency.assertFalse("KB should not be consistent", m.validate().isValid());
    }

    public void testConsistent2() {
        String NS = "http://example.org/foo#";
        OntModel base = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM, null);
        OntClass F0 = base.createClass(NS + "F0");
        OntClass F1 = base.createClass(NS + "F1");
        OntClass F2 = base.createClass(NS + "F2");
        F0.addDisjointWith(F1);
        F2.addSuperClass(F0);
        F2.addSuperClass(F1);
        DIGReasoner r = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner(r);
        OntModel m = ModelFactory.createOntologyModel(spec, base);
        ValidityReport report = m.validate();
        if (!report.isValid()) {
            Iterator i = report.getReports();
            while (i.hasNext()) {
                ValidityReport.Report rp = (ValidityReport.Report)i.next();
                LogFactory.getLog(this.getClass()).debug("Problem report: " + rp.type + " - " + rp.description);
            }
        }
        TestConsistency.assertFalse("KB should not be consistent", m.validate().isValid());
    }
}

