/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;

public abstract class HashCommon {
    protected static final double loadFactor = 0.5;
    protected Object[] keys;
    public int capacity;
    protected int threshold;
    protected int size = 0;
    protected int changes;
    static final int[] primes = new int[]{7, 19, 37, 79, 149, 307, 617, 1237, 2477, 4957, 9923, 19853, 39709, 79423, 158849, 317701, 635413, 1270849, 2541701, 5083423};

    protected HashCommon(int initialCapacity) {
        this.capacity = initialCapacity;
        this.keys = new Object[this.capacity];
        this.threshold = (int)((double)this.capacity * 0.5);
    }

    protected void removeAssociatedValues(int here) {
    }

    protected void moveAssociatedValues(int here, int scan) {
    }

    public Object getItemForTestingAt(int i) {
        return this.keys[i];
    }

    protected final int initialIndexFor(Object key) {
        return (key.hashCode() & Integer.MAX_VALUE) % this.capacity;
    }

    protected final int findSlot(Object key) {
        int index = this.initialIndexFor(key);
        Object current;
        while ((current = this.keys[index]) != null) {
            if (key.equals(current)) {
                return ~index;
            }
            if (--index >= 0) continue;
            index += this.capacity;
        }
        return index;
    }

    public void remove(Object key) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.removeFrom(~slot);
        }
    }

    protected void growCapacityAndThreshold() {
        this.capacity = HashCommon.nextSize(this.capacity * 2);
        this.threshold = (int)((double)this.capacity * 0.5);
    }

    protected static int nextSize(int atLeast) {
        for (int i = 0; i < primes.length; ++i) {
            if (primes[i] <= atLeast) continue;
            return primes[i];
        }
        return atLeast;
    }

    protected Object removeFrom(int here) {
        int original = here;
        Object wrappedAround = null;
        --this.size;
        while (true) {
            Object key;
            int r;
            this.keys[here] = null;
            this.removeAssociatedValues(here);
            int scan = here;
            do {
                if (--scan < 0) {
                    scan += this.capacity;
                }
                if ((key = this.keys[scan]) != null) continue;
                return wrappedAround;
            } while (scan <= (r = this.initialIndexFor(key)) && r < here || r < here && here < scan || here < scan && scan <= r);
            if (here <= original && scan > original) {
                wrappedAround = this.keys[scan];
            }
            this.keys[here] = this.keys[scan];
            this.moveAssociatedValues(here, scan);
            here = scan;
        }
    }

    void showkeys() {
    }

    public ExtendedIterator keyIterator() {
        return this.keyIterator(NotifyEmpty.ignore);
    }

    public ExtendedIterator keyIterator(NotifyEmpty container2) {
        this.showkeys();
        ArrayList movedKeys = new ArrayList();
        BasicKeyIterator basic = new BasicKeyIterator(this.changes, container2, movedKeys);
        MovedKeysIterator leftovers = new MovedKeysIterator(this.changes, container2, movedKeys);
        return basic.andThen(leftovers);
    }

    protected final class BasicKeyIterator
    extends NiceIterator {
        protected final List movedKeys;
        int index = 0;
        final int initialChanges;
        final NotifyEmpty container;

        protected BasicKeyIterator(int initialChanges, NotifyEmpty container2, List movedKeys) {
            this.movedKeys = movedKeys;
            this.initialChanges = initialChanges;
            this.container = container2;
        }

        public boolean hasNext() {
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            while (this.index < HashCommon.this.capacity && HashCommon.this.keys[this.index] == null) {
                ++this.index;
            }
            return this.index < HashCommon.this.capacity;
        }

        public Object next() {
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                this.noElements("HashCommon keys");
            }
            return HashCommon.this.keys[this.index++];
        }

        public void remove() {
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            Object moved = HashCommon.this.removeFrom(this.index - 1);
            if (moved != null) {
                this.movedKeys.add(moved);
            }
            if (HashCommon.this.size == 0) {
                this.container.emptied();
            }
            if (HashCommon.this.size < 0) {
                throw new BrokenException("BROKEN");
            }
            HashCommon.this.showkeys();
        }
    }

    protected final class MovedKeysIterator
    extends NiceIterator {
        private final List keys;
        protected int index = 0;
        final int initialChanges;
        final NotifyEmpty container;

        protected MovedKeysIterator(int initialChanges, NotifyEmpty container2, List keys) {
            this.keys = keys;
            this.initialChanges = initialChanges;
            this.container = container2;
        }

        public boolean hasNext() {
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            return this.index < this.keys.size();
        }

        public Object next() {
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                this.noElements("");
            }
            return this.keys.get(this.index++);
        }

        public void remove() {
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            HashCommon.this.remove(this.keys.get(this.index - 1));
            if (HashCommon.this.size == 0) {
                this.container.emptied();
            }
        }
    }

    public static interface NotifyEmpty {
        public static final NotifyEmpty ignore = new NotifyEmpty(){

            public void emptied() {
            }
        };

        public void emptied();
    }
}

