/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemWriter;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class sse
extends CmdGeneral {
    protected final ArgDecl fileDecl = new ArgDecl(true, "file");
    protected final ArgDecl numberDecl = new ArgDecl(true, "num", "number");
    protected final ArgDecl noPrintDecl = new ArgDecl(false, "n");
    protected final ArgDecl noResolveDecl = new ArgDecl(false, "raw");
    private boolean print = true;
    private boolean structural = true;
    private boolean lineNumbers = false;
    private List filenames;
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    boolean needDivider = false;

    public static void main(String[] argv) {
        new sse(argv).main();
    }

    public sse(String[] argv) {
        super(argv);
        super.getUsage().startCategory("SSE");
        super.add(this.fileDecl, "--file=FILE", "Algebra file to parse");
        super.add(this.noPrintDecl, "-n", "Don't print the expression");
        super.add(this.numberDecl, "--num [on|off]", "Numbers");
        super.add(this.noResolveDecl, "--raw", "Don't handle base or prefix names specially");
    }

    protected void processModulesAndArgs() {
        if (this.contains(this.fileDecl)) {
            this.filenames = this.getValues(this.fileDecl);
        }
        if (this.filenames == null) {
            this.filenames = new ArrayList();
        }
        boolean bl = this.print = !this.contains(this.noPrintDecl);
        if (this.contains(this.numberDecl)) {
            this.lineNumbers = this.getValue(this.numberDecl).equalsIgnoreCase("on");
        }
        if (this.contains(this.noResolveDecl)) {
            SSE.setUseResolver(false);
        }
    }

    protected String getCommandName() {
        return Utils.className(this);
    }

    protected String getSummary() {
        return this.getCommandName();
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    protected void exec() {
        try {
            Iterator iter = this.filenames.iterator();
            while (iter.hasNext()) {
                String fn = (String)iter.next();
                this.execFilename(fn);
            }
            iter = super.getPositional().listIterator();
            while (iter.hasNext()) {
                String str2 = (String)iter.next();
                this.execString(str2);
            }
        }
        catch (SSEParseException sseEx) {
            System.err.println(sseEx.getMessage());
            throw new TerminationException(99);
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
        }
    }

    protected void execFilename(String filename) {
        Item item = null;
        item = filename.equals("-") ? SSE.parse(System.in) : SSE.readFile(filename);
        this.print(item);
    }

    protected void execString(String string) {
        Item item = SSE.parse(string);
        this.print(item);
    }

    protected void print(Item item) {
        if (!this.print) {
            return;
        }
        if (item == null) {
            System.err.println("No expression");
            throw new TerminationException(9);
        }
        this.divider();
        IndentedWriter out = new IndentedWriter(System.out, this.lineNumbers);
        PrefixMapping pmap = null;
        SerializationContext sCxt = new SerializationContext(pmap);
        ItemWriter.write(out, item, sCxt);
        out.ensureStartOfLine();
        out.flush();
    }
}

