/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpBase;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.expr.E_LessThan;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;

public class AlgebraExec {
    public static void main(String[] argv) {
        String BASE = "http://example/";
        BasicPattern bp = new BasicPattern();
        Var var_x = Var.alloc("x");
        Var var_z = Var.alloc("z");
        bp.add(new Triple(var_x, Node.createURI(BASE + "p"), var_z));
        OpBase op = new OpBGP(bp);
        E_LessThan expr = new E_LessThan(new ExprVar(var_z), NodeValue.makeNodeInteger(2L));
        op = OpFilter.filter(expr, (Op)op);
        Model m = AlgebraExec.makeModel();
        m.write(System.out, "TTL");
        System.out.println("--------------");
        System.out.print(op);
        System.out.println("--------------");
        QueryIterator qIter = Algebra.exec((Op)op, m.getGraph());
        ArrayList<String> varNames = new ArrayList<String>();
        varNames.add("x");
        varNames.add("z");
        ResultSetStream rs = new ResultSetStream(varNames, m, qIter);
        ResultSetFormatter.out(rs);
        qIter.close();
        System.exit(0);
    }

    private static Model makeModel() {
        String BASE = "http://example/";
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("", BASE);
        Resource r1 = model.createResource(BASE + "r1");
        Resource r2 = model.createResource(BASE + "r2");
        Property p1 = model.createProperty(BASE + "p");
        Property p2 = model.createProperty(BASE + "p2");
        Literal v1 = model.createTypedLiteral("1", (RDFDatatype)XSDDatatype.XSDinteger);
        Literal v2 = model.createTypedLiteral("2", (RDFDatatype)XSDDatatype.XSDinteger);
        r1.addProperty(p1, v1).addProperty(p1, v2);
        r1.addProperty(p2, v1).addProperty(p2, v2);
        r2.addProperty(p1, v1).addProperty(p1, v2);
        return model;
    }
}

