/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline.test;

import arq.cmdline.ArgDecl;
import arq.cmdline.CmdLineArgs;
import java.util.Iterator;
import junit.framework.TestCase;

public class TestCmdLine
extends TestCase {
    public void test_Simple1() {
        String[] args = new String[]{""};
        CmdLineArgs cl = new CmdLineArgs(args);
        cl.process();
    }

    public void test_Flag1() {
        String[] args = new String[]{""};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(false, "-a");
        cl.add(argA);
        cl.process();
        TestCmdLine.assertTrue("-a argument found", !cl.contains(argA));
    }

    public void test_Flag2() {
        String[] args = new String[]{"-a"};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(false, "-a");
        cl.add(argA);
        cl.process();
        TestCmdLine.assertTrue("No -a argument found", cl.contains(argA));
    }

    public void test_Flag3() {
        String[] args = new String[]{"-a", "filename"};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(false, "-a");
        cl.add(argA);
        cl.process();
        TestCmdLine.assertTrue("No -a argument found", cl.contains(argA));
    }

    public void test_Arg1() {
        String[] args = new String[]{""};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(true, "-arg");
        cl.add(argA);
        cl.process();
        TestCmdLine.assertTrue("-arg argument found", !cl.contains(argA));
    }

    public void test_Arg2() {
        String[] args = new String[]{"-arg=ARG", "filename"};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(true, "-arg");
        cl.add(argA);
        cl.process();
        TestCmdLine.assertTrue("No -arg= argument found", cl.contains(argA));
        TestCmdLine.assertEquals("", cl.getValue(argA), "ARG");
        TestCmdLine.assertEquals("", cl.getArg("arg").getValue(), "ARG");
    }

    public void test_nArg1() {
        String[] args = new String[]{"-arg=V1", "--arg=V2", "-v"};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(true, "-arg");
        cl.add(argA);
        ArgDecl argV = new ArgDecl(false, "-v");
        cl.add(argV);
        cl.process();
        TestCmdLine.assertTrue("No -arg= argument found", cl.contains(argA));
        Iterator iter = cl.getValues("arg").iterator();
        TestCmdLine.assertEquals("Argument 1", iter.next(), (Object)"V1");
        TestCmdLine.assertEquals("Argument 2", iter.next(), (Object)"V2");
    }
}

