/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModBase;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.core.DataFormat;
import com.hp.hpl.jena.sparql.util.DatasetUtils;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import java.util.List;

public class ModDataset
extends ModBase {
    protected final ArgDecl graphDecl = new ArgDecl(true, "graph", "data");
    protected final ArgDecl namedGraphDecl = new ArgDecl(true, "named", "namedgraph", "namedGraph", "namedData", "nameddata");
    protected final ArgDecl lmapDecl = new ArgDecl(true, "lmap");
    private List graphURLs = null;
    private List namedGraphURLs = null;
    private DataFormat dataSyntax = null;
    protected Dataset dataset = null;
    private FileManager fileManager = FileManager.get();

    public void registerWith(CmdGeneral cl) {
        cl.getUsage().startCategory("Dataset");
        cl.add(this.graphDecl, "--graph", "Graph for default graph of the datset");
        cl.add(this.namedGraphDecl, "--namedGraph", "Add a graph into the dataset as a named graph");
        cl.add(this.lmapDecl, "--lmap", "Specify a location mapping file");
    }

    public void processArgs(CmdArgModule cmdLine) {
        this.graphURLs = cmdLine.getValues(this.graphDecl);
        this.namedGraphURLs = cmdLine.getValues(this.namedGraphDecl);
        if (cmdLine.contains(this.lmapDecl)) {
            String lmapFile = cmdLine.getValue(this.lmapDecl);
            LocationMapper locMap = new LocationMapper(lmapFile);
            this.fileManager = new FileManager(locMap);
        }
    }

    public Dataset getDataset() {
        if (this.dataset != null) {
            return this.dataset;
        }
        if (!(this.graphURLs != null && this.graphURLs.size() != 0 || this.namedGraphURLs != null && this.namedGraphURLs.size() != 0)) {
            return null;
        }
        DataSource ds = DatasetFactory.create();
        this.addGraphs(ds);
        this.dataset = ds;
        return this.dataset;
    }

    protected void addGraphs(DataSource ds) {
        try {
            if (this.graphURLs != null || this.namedGraphURLs != null) {
                this.dataset = DatasetUtils.addInGraphs(ds, this.graphURLs, this.namedGraphURLs, this.fileManager, null);
            }
        }
        catch (LabelExistsException ex) {
            throw new CmdException(ex.getMessage());
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Error creating dataset", ex);
        }
    }

    public List getGraphURLs() {
        return this.graphURLs;
    }

    public List getNamedGraphURLs() {
        return this.namedGraphURLs;
    }
}

