/***************************************************************************
                          RTSPServerModule.h
                         -------------------
    begin                : Mo Jun 03 2002
  
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file RTSPServerModule.h
This file declares the class RTSPServerModule.
*/


#include "omnetpp.h"

#include "sockets.h"
#include "in_addr.h"
#include "in_port.h"
#include "RTSPMessage_m.h"

/*! \class RTSPServerModule
The class RTSPServerModule is responsible for receiving and
processing messages from a rtsp client. It 
forwards the messages to the right session (RTSPServerProcess). 
If the session does not exist, it creates a new session.
*/
class RTSPServerModule : public cSimpleModule {

	Module_Class_Members(RTSPServerModule, cSimpleModule, 0);
	
	/*!
	Initializes variables.
	*/
	virtual void initialize();
	
	/*!
	Handles incoming messages.
	*/
	virtual void handleMessage(cMessage *msg);
	
		
	protected:
		
		/*!
		Handles messages received from server process.
		*/
		virtual void handleMessageFromServerProcess(cMessage *msg);
					
		/*!
		Handles messages received from the socket layer.
		*/
		virtual void handleMessageFromSocketLayer(cMessage *msg);
	
		/*!
		Handles messages received from the socket layer.
		*/
		virtual void handleSelfMessage(cMessage *msg);
	
		/*!
		Generates a new session ID.
		*/
		virtual char* generateSessionId();
		
		/*!
		Handles all requests.	
		*/
		virtual void handleRequest();		

		/*!
		Creates a new session.
		*/
		virtual void createSession();		
	
	private:
		
		/*!
		The rtsp port.
		*/
		IN_Port _portRTSP;
		
		/*!
		The rtp port.
		*/
		IN_Port _portRTP;
				
		/*!
		The handled request.
		*/
		rtspRequest *request;
		
		/*!
		The remote address.
		*/
		IN_Addr	remote_addr;
		
		/*!
		The remote port.
		*/
		IN_Port	remote_port;
					
		/*!
		The rtsp server socket file descriptor.
		*/
		Socket::Filedesc _socketFd;

		/*!
		A debug parameter.
		*/
		bool _debug;		
					
		/*!
		Writes a request to omnet environment.
		*/
		virtual void writeRequestContents(rtspRequest *request);
		
		/*!
		Writes a response to omnet environment.
		*/
		virtual void writeResponseContents(rtspResponse *response);	
	
};
