/***************************************************************************
                          RTSPServerModule.cc  
                          -------------------
    begin                : Mo Jun 03 2002
  ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file RTSPServerModule.cc
This file contains the implementation of member functions of the class
RTSPServerModule.              
*/
					
#include "omnetpp.h"
#include "SocketInterfacePacket.h"
#include "ip_address.h"
#include "RTSPServerModule.h"
#include "RTSPMessage_m.h"


Define_Module(RTSPServerModule);

//
// methods inherited from cSimpleModule
//


void RTSPServerModule::initialize() {

	_socketFd = Socket::FILEDESC_UNDEF;
		
	_portRTSP = IN_Port((int)(par("portNumberRTSP").longValue()));
	_portRTP = IN_Port((int)(par("portNumberRTP").longValue()));

	_debug = par("debug");

	cMessage *startMessage = new cMessage("startMessage()");
	scheduleAt(0.0, startMessage);

};



void RTSPServerModule::handleMessage(cMessage *msg) {
	
	if (msg->isSelfMessage()) {
		handleSelfMessage(msg);
	}

	else if (msg->arrivalGateId() == findGate("fromSocketLayer")) {
		handleMessageFromSocketLayer(msg);
	} 

	else if (msg->arrivalGateId() == findGate("fromServerProcess")) {
		handleMessageFromServerProcess(msg);
	}
	else {
		opp_error("RTSPServerModule: Message from unknown gate.");
	}
	
};



void RTSPServerModule::handleMessageFromSocketLayer(cMessage *msg) {
	
	SocketInterfacePacket *sifpIn = (SocketInterfacePacket *)msg;
		
	remote_addr = sifpIn->fAddr();
	remote_port = sifpIn->fPort();
		
	if (sifpIn->action() == SocketInterfacePacket::SA_SOCKET_RET) {
		_socketFd = sifpIn->filedesc();
		delete sifpIn;
		
		SocketInterfacePacket *sifpOut = new SocketInterfacePacket("bind()");
			
		sifpOut->bind(_socketFd, IN_Addr(IN_Addr::ADDR_UNDEF), _portRTSP);
		send(sifpOut, "toSocketLayer");
	}

	else if (sifpIn->action() == SocketInterfacePacket::SA_READ_RET) {
		
		request = (rtspRequest *)(sifpIn->decapsulate());
		delete sifpIn;
		handleRequest();
	}

	else {
		ev << "RTSPServerModule: Unknown SocketInterfacePacket type " << sifpIn->action() << " !" << endl;
	}
	
};	


	
void RTSPServerModule::handleSelfMessage(cMessage *msg) {

	if (!opp_strcmp(par("rtspTransportProtocol"), "UDP")) {
		SocketInterfacePacket *sifpOut = new SocketInterfacePacket("socket()");
		sifpOut->socket(Socket::AF_INET, Socket::SOCK_DGRAM, Socket::UDP);
		send(sifpOut, "toSocketLayer");	
	}

	else if (!opp_strcmp(par("rtspTransportProtocol"), "TCP")) {	
		SocketInterfacePacket *sifpOut = new SocketInterfacePacket("socket()");
		sifpOut->socket(Socket::AF_INET, Socket::SOCK_DGRAM, Socket::TCP);
		send(sifpOut, "toSocketLayer");	
	}
	
	else {
		error("Unknown transport protocol %s",par("rtspTransportProtocol").stringValue());
	}
	
	delete msg;
			
};


	
void RTSPServerModule::handleRequest() {	
			
	if (request->getMethod() == SETUP) {
		createSession();
	}	   
	
	else  {

		// Unknown session ID
		if (findSubmodule(request->getSessionId()) == -1) {
	    
	        if (_debug) {
				ev << "RTSPServerModule: Unknown SessionID = "  << request->getSessionId() << endl;
			}	

			rtspResponse *response = new rtspResponse();
			SocketInterfacePacket *sifpOut = new SocketInterfacePacket("rtspResponse()");	
			
			response->setRtspVersion(request->getRtspVersion());
			response->setSessionId(request->getSessionId());				

			response->setStatusCode(454);
			response->setReasonPhrase("Session Not Found");

		    if (_debug) {
				writeResponseContents(response);
			}
			
			sifpOut->write(_socketFd, response);
			send(sifpOut, "toSocketLayer");
			
			delete request;

		}

   		else {

			// forward message to RTSPServerProcess 
			cModule *mod = simulation.module(findSubmodule(request->getSessionId()));
			sendDirect(request, 0.0, mod, "fromServerModule" );			
			
		} 
	}	
	
};	



void RTSPServerModule::createSession() {	     	     
     
	if (_debug) {
		writeRequestContents(request);
	}
	
	request->setSessionId(generateSessionId());
	
	
	cModuleType	*moduleType = findModuleType("RTSPServerProcess");
	cModule *mod = moduleType->create(request->getSessionId(),this);
	mod->par("portNumberRTP") = par("portNumberRTP");
	mod->par("rtspTransportProtocol") = par("rtspTransportProtocol");
	mod->par("debug") = par("debug");
	
	mod->par("remote_addr") = remote_addr;
	mod->par("remote_port") = remote_port;
	moduleType->buildInside(mod);
	mod->callInitialize();
	mod->scheduleStart(simTime());
	
	cModule *socketMod = gate("toSocketLayer")->toGate()->ownerModule();
	
	//find free gate at SocketLayer
	int j = 0;
	while (socketMod->gate("from_appl",j)->isConnected()) {
		j++;
		if (socketMod->gate("from_appl")->size() == j) opp_error("SocketLayer gateSize() to small.");
	}
		
	mod->gate("toSocketLayerRTSP")->setTo(socketMod->gate("from_appl", j));
	mod->gate("fromSocketLayerRTSP")->setFrom(socketMod->gate("to_appl", j));
	socketMod->gate("from_appl", j) -> setFrom(mod->gate("toSocketLayerRTSP"));
	socketMod->gate("to_appl", j) -> setTo(mod->gate("fromSocketLayerRTSP"));
		
	// locate free SocketLayer link
	j = 0;
	while (socketMod->gate("from_appl",j)->isConnected()) {
		j++;
		if (socketMod->gate("from_appl")->size() == j) opp_error("RTSPClientLayer: SocketLayer gateSize() to small.");
	}
		
	// set links from and to SocketLayerRTP
	mod->gate("toSocketLayerRTP")->setTo(socketMod->gate("from_appl", j));
	mod->gate("fromSocketLayerRTP")->setFrom(socketMod->gate("to_appl", j));
	socketMod->gate("from_appl", j) -> setFrom(mod->gate("toSocketLayerRTP"));
	socketMod->gate("to_appl", j) -> setTo(mod->gate("fromSocketLayerRTP"));

	// locate free SocketLayer link
	j = 0;
	while (socketMod->gate("from_appl",j)->isConnected()) {
		j++;
		if (socketMod->gate("from_appl")->size() == j) opp_error("RTSPClientLayer: SocketLayer gateSize() to small.");
	}
	
	// set links from and to SocketLayerRTCP	
	mod->gate("toSocketLayerRTCP")->setTo(socketMod->gate("from_appl", j));
	mod->gate("fromSocketLayerRTCP")->setFrom(socketMod->gate("to_appl", j));
	socketMod->gate("from_appl", j)->setFrom(mod->gate("toSocketLayerRTCP"));
	socketMod->gate("to_appl", j)->setTo(mod->gate("fromSocketLayerRTCP"));
	
	sendDirect(request, 0.0, mod, "fromServerModule");
     	
};



char* RTSPServerModule::generateSessionId() {		

	long x;
	do {
	} while ((x = intrand(100000000)) < 10000000L);

	char *sessionId = (char *)malloc(10);
	sprintf(sessionId, "%ld", x);	
	
	return sessionId;

};
    
    
	     
void RTSPServerModule::handleMessageFromServerProcess(cMessage *msg) {
	
	if (!opp_strcmp(msg->name(), "closeSession()")) {
		cModule *mod = simulation.module(msg->senderModuleId())->parentModule();
		mod->deleteModule();
		delete msg;
	}
	
};



void RTSPServerModule::writeRequestContents(rtspRequest *request) {
	
	ev << "\nRTSPServerModule: receiving request...\n"
	     << "-----------------------------------------------------------------------------\n"; 
		switch (request->getMethod()) {
		case SETUP: 
				ev << "SETUP"
				<< " rtsp://" 
			   	<< request->getDestinationAddress() 
				<< "/" 
				<< request->getFileName() 
				<< " RTSP/"
				<< request->getRtspVersion() 
				<< endl
				<< "CSeq: " 
				<< request->getCseq() 
				<< endl
				<< "Transport: " 
				<< request->getTransport() 
				<< endl;	
		break;
		
		case PLAY:
				ev << "PLAY"
				<< " rtsp://" 
			   	<< request->getDestinationAddress() 
				<< "/" 
				<< request->getFileName() 
				<< " RTSP/"
				<< request->getRtspVersion() 
				<< endl
				<< "CSeq: " 
				<< request->getCseq() 
				<< endl
				<< "Session: " 
				<< request->getSessionId() 
				<< endl	
				<< "Range: " 
				<< request->getRange() 
				<< endl;	

		break;
		
		case PAUSE: 
				ev << "PAUSE"
				<< " rtsp://" 
			   	<< request->getDestinationAddress() 
				<< "/" 
				<< request->getFileName() 
				<< " RTSP/"
				<< request->getRtspVersion() 
				<< endl
				<< "CSeq: " 
				<< request->getCseq() 
				<< endl
				<< "Session: " 
				<< request->getSessionId() 
				<< endl;	
		break;
		
		case TEARDOWN:
			ev << "TEARDOWN"
				<< " rtsp://" 
			   	<< request->getDestinationAddress() 
				<< "/" 
				<< request->getFileName() 
				<< " RTSP/"
				<< request->getRtspVersion() 
				<< endl
				<< "CSeq: " 
				<< request->getCseq() 
				<< endl
				<< "Session: " 
				<< request->getSessionId() 
				<< endl;	
		}			
	
	   ev << "-----------------------------------------------------------------------------\n\n" ;	
};



void RTSPServerModule::writeResponseContents(rtspResponse *response) {

	ev << "\nRTSPServerModule: sending response...\n"
	   << "-----------------------------------------------------------------------------\n"
	   << "RTSP/" 
	   << response->getRtspVersion() 
	   << " " 
	   << response->getStatusCode() 
	   << " " 
	   << response->getReasonPhrase()
	   << endl
	   << "CSeq: " 
	   << response->getCseq() 
	   << endl
	   << "Session: " 
	   << response->getSessionId() 
	   << endl
	   << "-----------------------------------------------------------------------------\n\n"; 
};
