/***************************************************************************
                          RTSPServerLayer.h  
                         -------------------
    begin                : Sun Jun 09 2002
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file RTSPServerLayer.h
This header file declares the class RTSPServerLayer.
*/

#include "omnetpp.h"

#include "sockets.h"
#include "in_addr.h"
#include "in_port.h"

#include "RTSPMessage_m.h"
#include "RTPInterfacePacket.h"

/*! \class RTSPServerLayer
An RTSPClientLayer module is the center of the rtsp server layer.
It sends and receives rtsp responses.
It also communicates with the rtp layer and the RTSPServerModule.
*/
class RTSPServerLayer : public cSimpleModule {

	Module_Class_Members(RTSPServerLayer, cSimpleModule, 0);
	
	/*!
	The finite state machine states.
	*/
	enum FSM_STATES {

	     INIT        = 0,
	     READY       = FSM_Steady(1),
	     PLAYING     = FSM_Steady(2),
	};
			
	/*!
	Initializes variables.
	*/
	virtual void initialize();
	
	/*!
	Handles incoming messages.
	*/
	virtual void handleMessage(cMessage *msg);
	
		
	protected:
	
		/*!
		The finite state machine.
		*/
		cFSM fsm;
				
		/*!
		Handles messages received from socket layer.
		*/
		virtual void handleMessageFromSocketLayer(cMessage *msg);
		
		/*!
		Handles messages received from server module.
		*/
		virtual void handleMessageFromServerModule(cMessage *msg);
		
		/*!
		Handles messages received from rtp.
		*/
		virtual void handleMessageFromRTP(cMessage *msg);
					
		/*!
		Handles all requests.
		*/
		virtual void handleRequest();
		
		/*!
		Handles requests state INIT.
		*/
		virtual void handleRequestStateInit();

		/*!
		Handles requests state READY.
		*/
		virtual void handleRequestStateReady();

		/*!
		Handles requests state PLAYING.
		*/
		virtual void handleRequestStatePlaying();

		/*!
		Handles self messages.
		*/
		virtual void handleSelfMessage(cMessage *msg);
	
	private:
		
		/*!
		A debug parameter.
		*/					
		bool _debug;
			
		/*!
		The rtp port.
		*/
		IN_Port _portRTP;
		
		/*!
		The RTP SSRC.
		*/
		u_int32 _ssrc;
		
		/*!
		The RTSP response. 
		*/
		rtspResponse *response;
		
		/*!
		The RTSP request. 
		*/
		rtspRequest *request;
		
		/*!
		The rtsp server socket file descriptor.
		*/
		Socket::Filedesc _socketFd;

		/*!
		The filename of the file to transmit.
		*/
		char *_filename;	
		
		/*!
		The play range "from".
		*/
		float _rangeFrom;
		
		/*!
		The play range "to".
		*/
		float _rangeTo;

		/*!
		The current URL.
		*/
		char _url[255];
		
		/*!
		Writes a request to omnet environment.
		*/
		virtual void writeRequestContents(rtspRequest *request);
		
		/*!
		Writes a response to omnet environment.
		*/
		virtual void writeResponseContents(rtspResponse *response);	
		
};
